# -*- coding: UTF-8 -*-
# Copyright (c) Huawei Technologies Co., Ltd. 2019-2021. All rights reserved.

from memory_inspect.adapter.java_adapter import get_msg
from memory_inspect.rule.memory_rule import RuleBase


class ExpSesRule(RuleBase):
    ERR_TYPE_DICT = {"exp_ses_1": 10, "exp_ses_2": 10, "exp_ses_3": 3}

    def __init__(self, rule_context):
        super(ExpSesRule, self).__init__(rule_context)
        self.new_err_obj_ids = {}

    def execute(self, time_period_day=7):
        result = False
        for err_type, count_err in self.ERR_TYPE_DICT.items():
            self._query_new_err_obj_ids(err_type)
            self.logger.info("error_type:{} new_err_obj_ids:{}".format(
                err_type, self.new_err_obj_ids)
            )
            if not self.new_err_obj_ids.get(err_type):
                continue
            if self._check_rule(err_type, time_period_day, count_err):
                result = True
        self.err_msg = list(set(self.err_msg))
        return result

    def _check_rule(self, err_type, time_period_day, count_err):
        time_period_day = int(time_period_day)
        start_time = self.get_time_by_delta_process(self.rule_context.current_time, days=-1 * time_period_day)
        sql_str = "SELECT time, obj_id, err_type, ctrl, matched_data FROM tbl_log_err_info " \
                  "WHERE time >= '{}' and sn = '{}' and err_type='{}'". \
            format(start_time, self.rule_context.sn, err_type)
        self.logger.info("sql_str:{} ".format(sql_str))
        records = self.db_service.log_err_tbl.query(sql_str)
        records = self._sort_records_by_ctrl_and_obj_id(records)
        self.add_db_record_to_origin_info(records[-100:], "{}(total:{}):".format(err_type, len(records)))
        return self._check_rule_by_record(records, count_err, err_type)

    def _sort_records_by_ctrl_and_obj_id(self, data_list):
        """
        按控制器、和obj, 时间 排序
        :param data_list:
        :return:
        """
        if not data_list:
            return data_list
        result_list = []

        ctrl_group_data = self.group_by(data_list, "ctrl")
        for ctrl, tmp_data_list in ctrl_group_data.items():
            tmp_result_list = []
            obj_group_data = self.group_by(tmp_data_list, "obj_id")
            for key, obj_data_list in obj_group_data.items():
                sorted_records = sorted(obj_data_list,
                                        key=lambda x: x.get("time"))
                obj_group_data[key] = sorted_records
            data_keys = list(obj_group_data.keys())
            data_keys.sort()
            [tmp_result_list.extend(obj_group_data.get(key)) for key in
             data_keys]
            ctrl_group_data[ctrl] = tmp_result_list
        ctrl_keys = list(ctrl_group_data.keys())
        ctrl_keys.sort()
        [result_list.extend(ctrl_group_data.get(key)) for key in ctrl_keys]
        return result_list

    def _query_new_err_obj_ids(self, err_type):
        self.logger.info("last_err_time:{} ".format(self.rule_context.last_err_time))
        sql_str = "SELECT time, obj_id, err_type FROM tbl_log_err_info " \
                  "WHERE time > '{}' and sn = '{}' and err_type='{}'". \
            format(self.rule_context.last_err_time, self.rule_context.sn, err_type)

        new_records = self.db_service.log_err_tbl.query(sql_str)
        self.new_err_obj_ids[err_type] = [
            record.get("obj_id") for record in new_records]
        self.logger.info("error_type:{} new_err_obj_ids:{}".format(
            err_type, self.new_err_obj_ids)
        )

    def _check_rule_by_record(self, records, count_err, err_type):
        """
        records示例：
        # [{obj_id:"0A", time: "2021-05-01 22:00:00", err_type: "exp_ses_1"}]
        """
        ctrl_grouped_records = self.group_by(records, 'ctrl')
        for ctrl, ctrl_obj_records in ctrl_grouped_records.items():
            obj_grouped_records = self.group_by(ctrl_obj_records, 'obj_id')
            for obj_id, one_obj_records in obj_grouped_records.items():
                if obj_id not in self.new_err_obj_ids.get(err_type, []):
                    continue
                if len(one_obj_records) > count_err:
                    error_key = "ctrl.exp.ses.except"
                    self.err_msg.append(get_msg(self.lang, error_key, obj_id))
        return bool(self.err_msg)
