# -*- coding: UTF-8 -*-

import traceback
import common
import cliUtil
from cbb.business.operate.fru.common.checkItem import compute_storage_common
from cbb.frame.checkitem.context_adapter import InspectContext

import java.lang.Exception as JException

PY_JAVA_ENV = py_java_env
LANG = common.getLang(PY_JAVA_ENV)
LOGGER = common.getLogger(PY_LOGGER, __file__)
URL = "/fce/monitor/v1/events?severity=critical&eventType=Uncleared"


def execute(cli):
    """
    紧急告警检查
    @param cli: cli
    """
    ret = ""
    try:
        context = InspectContext(PY_JAVA_ENV, cli)
        inspect_context = context.get_context()
        inspect_context["devNode0"] = inspect_context.get("devInfo")
        ret = compute_storage_common.get_fcv_rest_record(inspect_context, URL, "events")
        LOGGER.logInfo("critical alarms records={}".format(ret))
        if not ret:
            return True, ret, ""
        return False, ret, common.getMsg(LANG, "system.exists.critical.alarm")
    except (Exception, JException) as ex:
        LOGGER.logException(ex)
        LOGGER.logError(str(traceback.format_exc()))
        return cliUtil.RESULT_NOCHECK, "\n".join(ret), common.getMsg(LANG, "query.result.abnormal")
