# -*- coding: UTF-8 -*-
import time

import cliUtil
import common
import expandconfig
from frameone.util import common as frameCommon

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
DISK_TYPE_BLACK_LIST = ["SSD", "SSD SED"]

expConfigObj = expandconfig.ExpandConfig(py_java_env)
devInfo = common.getCurDeviceInfo(py_java_env)
productModel = str(devInfo.getDeviceType())


@frameCommon.fakeProgress(py_java_env, totalSeconds=30, logger=LOGGER, interval=1)
def execute(cli):
    """
        硬盘域扩容CPU利用率检查:
            1、如果新扩硬盘类型不是SSD硬盘，检查通过。
            2、如果新扩目标逻辑引擎不包含新扩的硬盘类型，检查通过。
            3、如果新扩目标逻辑引擎CPU的利用率均值超过50%（3秒统计一次，共统计10次），检查不通过，否则，检查通过。
    """
    flag = True
    errMsg = ""
    cli_ret_all = ""
    try:
        # 获取非新建硬盘域的配置信息
        expDiskInfoDict = expConfigObj.getExpDiskInfo()
        LOGGER.logInfo("The expDiskInfoDict is %s" % expDiskInfoDict)

        # 若只有新建硬盘域,则检查通过
        if not expDiskInfoDict:
            return True, cli_ret_all, errMsg

        # 需继续检查CPU利用率的逻辑引擎集合
        expLogicEngs = set()
        # 同一硬盘域，同一逻辑引擎下新扩硬盘类型为SSD盘的集合
        domain_eng_info = set()
        for domainId in expDiskInfoDict.keys():
            diskList = expDiskInfoDict.get(domainId)
            for disk in diskList:
                logicEng = disk.getDiskLogicEngId()
                if disk.getDiskType() in DISK_TYPE_BLACK_LIST:
                    domain_eng_info.add((domainId, logicEng))

        # 1、如果新扩硬盘类型不是SSD硬盘，检查通过
        if len(domain_eng_info) == 0:
            return flag, cli_ret_all, errMsg

        # 2、检查新扩目标逻辑引擎是否包含新扩的硬盘类型
        flag, type_cli_ret, errMsg = checkExpDiskType(cli, domain_eng_info, expLogicEngs)
        cli_ret_all += type_cli_ret

        # 3、若上一项不通过，则检查CPU利用率
        if flag is False:
            flag, cpu_cli_ret, errMsg = checkCpuUsage(cli, expLogicEngs)
            cli_ret_all += cpu_cli_ret
            if flag is False:
                return flag, cli_ret_all, errMsg

        return flag, cli_ret_all, errMsg

    except Exception, exception:
        LOGGER.logException(exception)
        return cliUtil.RESULT_NOCHECK, cli_ret_all, common.getMsg(LANG, "query.result.abnormal")


def checkExpDiskType(cli, domain_eng_info, expLogicEngs):
    """
    @summary:新扩硬盘类型检查：如果新扩目标逻辑引擎不包含新扩的硬盘类型，检查通过。
    """
    flag = True
    cliRet = ""
    errMsg = ""

    for domain_eng in domain_eng_info:
        ddID = domain_eng[0]
        cmd = "show disk in_domain disk_domain_id=" + ddID
        LOGGER.logExecCmd(cmd)
        checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        if not checkRet[0]:
            LOGGER.logSysAbnormal()
            return checkRet

        disk_cli_ret = checkRet[1]
        cliRet += disk_cli_ret
        cliRetLinesList = cliUtil.getHorizontalCliRet(disk_cli_ret)
        if len(cliRetLinesList) == 0:
            errMsg = common.getMsg(LANG, "cannot.get.disk.on.domain", args=ddID)
            LOGGER.logNoPass("Cannot get disk info in disk_domain ID=%s" % ddID)
            return cliUtil.RESULT_NOCHECK, cliRet, errMsg

        for retDict in cliRetLinesList:
            diskId = str(retDict.get("ID"))
            diskType = str(retDict.get("Type"))
            logicEng = str(common.getLogicEngineOfDisk(diskId, productModel))
            if logicEng == domain_eng[1] and diskType in DISK_TYPE_BLACK_LIST:
                expLogicEngs.add(logicEng)

    if len(expLogicEngs) > 0:
        return False, cliRet, errMsg

    return flag, cliRet, errMsg


def checkCpuUsage(cli, expLogicEngs):
    """
    @summary:控制器CPU利用率检查：如果CPU的利用率均值超过50%（3秒统计一次，共统计10次），检查不通过，否则，检查通过。
    """
    flag = True
    cliRet_all = ""
    errMsg = ""
    sleepTimes = 3
    loopFrequency = loopTimes = 10
    cpuUsageStan = 50

    # 所有控制器查询10次的CPU利用率均值
    controllers = {}
    while loopFrequency > 0:

        cmd = "show controller general"
        LOGGER.logExecCmd(cmd)
        checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG, cliUtil.endWithSignToAdmin)
        if not checkRet[0]:
            LOGGER.logSysAbnormal()
            cliRet_all += checkRet
            return cliRet_all

        cliRet = checkRet[1]
        cliRet_all += cliRet
        cliRetLinesList = cliUtil.getVerticalCliRetFilterElabel(cliRet, False)
        if len(cliRetLinesList) == 0:
            errMsg = common.getMsg(LANG, "cannot.get.controller.info")
            LOGGER.logNoPass("Cannot get information about controller")
            return cliUtil.RESULT_NOCHECK, cliRet_all, errMsg

        for retDict in cliRetLinesList:
            ctrlId = str(retDict.get("Controller"))
            cpuUsage = int(retDict.get("CPU Usage(%)"))
            controllers[ctrlId] = controllers.get(ctrlId, 0) + cpuUsage
            if loopFrequency == 1:
                controllers[ctrlId] = controllers.get(ctrlId, 0) / loopTimes

        loopFrequency -= 1
        time.sleep(sleepTimes)

    LOGGER.logInfo("all controllers cpu usage: %s" % controllers)

    # 获取待检查控制器列表
    ctrlsToCheck = []
    for engId in expLogicEngs:
        pEngId = common.getDisplayEngId(engId, productModel)
        if len(pEngId.split("/")) == 2:
            ctrlsToCheck.extend(pEngId.split("/"))
        else:
            ctrlsToCheck.extend([ctrl_check for ctrl_check in controllers.keys() if ctrl_check.startswith(engId)])
    ctrlsToCheck = set(ctrlsToCheck)
    LOGGER.logInfo("controllers to check: %s" % ctrlsToCheck)

    # 待检查CPU利用率均值超过50%的控制器列表
    overLoadCtrls = []
    for ctrl in ctrlsToCheck:
        if controllers.get(ctrl, 0) > cpuUsageStan:
            overLoadCtrls.append((ctrl, "%.2f" % controllers.get(ctrl, 0)))

    if len(overLoadCtrls) > 0:
        for overLoadCtrl in overLoadCtrls:
            errMsg += common.getMsg(LANG, "controller.cpu.usage.abnormal",
                                    args=(overLoadCtrl[0], str(cpuUsageStan), overLoadCtrl[1]))
        LOGGER.logNoPass(errMsg)
        return False, cliRet_all, errMsg

    return flag, cliRet_all, errMsg
