# -*- coding: UTF-8 -*-
import cliUtil
import common
import expandconfig
from config import DiskType

lang = common.getLang(py_java_env)
logger = common.getLogger(PY_LOGGER, __file__)

#进度总剩余时间
LIMIT_TIME = 120
#进度刷新间隔
INTERVAL = 2

def execute(cli):
    '''
        扩容硬盘容量规格检查
    '''
    flag = True
    cliRetAll = ""
    errMsg = ""
    deviceList = ["2800 V3"]
    deviceType = str(common.getProductModeFromContext(py_java_env))
    expConfigObj = expandconfig.ExpandConfig(py_java_env)
    
    try:
        #进度条刷新
        common.threadUpProcess(py_java_env, LIMIT_TIME, INTERVAL, logger)
        #进度开始
        common.inProcess(py_java_env)
        logger.logInfo("process Thread started!")
        
        # 如果产品型号不是2800 V3，检查结果为不涉及
        if deviceType not in deviceList:
            return cliUtil.RESULT_NOSUPPORT, cliRetAll, errMsg
        
        # 如果新扩的盘的类型为SSD或者SAS，检查结果为不涉及。
        expDiskTypeSet = expConfigObj.getExpDiskTypeSet()
        if expDiskTypeSet.issubset(set([DiskType.SSD_SED, DiskType.SSD, DiskType.NVMe_SSD, DiskType.NVMe_SSD_SED, DiskType.SAS, DiskType.SAS_SED])):
            return cliUtil.RESULT_NOSUPPORT, cliRetAll, errMsg
        
        # 如果新扩的盘的容量小于6TB，检查结果为不涉及
        diskMaxSizeByte = 6 * 1024
        if max(expConfigObj.getExpDiskCapacitySet()) < diskMaxSizeByte:
            return cliUtil.RESULT_NOSUPPORT, cliRetAll, errMsg
        
        # 如果软件版本低于V300R003C00SPC100，检查不通过。
        ret, sysVersionList, hotpatchVersionList = common.parse_upgradePackage(cli, lang)
        cliRetAll = ret[1]
        if not ret[0]:
            return cliUtil.RESULT_NOCHECK, cliRetAll, ret[2]

        # 软件版本低于V300R003C00SPC100，检查不通过
        ret, curSysVersion, errInfo = common.getCurrentVersion(sysVersionList,lang)
        logger.logInfo("current system version:%s" % curSysVersion)
        if not ret:
            errMsg = errInfo
            return cliUtil.RESULT_NOCHECK, cliRetAll, errMsg
        sysVersion = "V300R003C00SPC100"
        if curSysVersion < sysVersion:
            logger.logNoPass("The system version [%s] is older than %s" % (curSysVersion, sysVersion))
            errMsg = common.getMsg(lang, "check.expand.sysversion.not.pass", (sysVersion, curSysVersion))
            return False, cliRetAll, errMsg

        # 如果软件版本为V300R003C00SPC100，热补丁低于V300R003C00SPH102，检查不通过
        hotpatchVersion = "V300R003C00SPH102"
        ret, curHotpatchVersion, errInfo = common.getHotPatchVersion(hotpatchVersionList, lang)
        logger.logInfo("hotpatch_version:%s" % curHotpatchVersion)
        if not ret:
            errMsg = errInfo
            return cliUtil.RESULT_NOCHECK, cliRetAll, errMsg
        
        if curSysVersion == "V300R003C00SPC100" and curHotpatchVersion < hotpatchVersion:
            logger.logNoPass("The hotpatchVersion [%s] is older than %s" % (curHotpatchVersion, hotpatchVersion))
            errMsg = common.getMsg(lang, "check.expand.hot.patch.not.pass", (hotpatchVersion, curHotpatchVersion))
            return False, cliRetAll, errMsg
            
        return flag, cliRetAll, errMsg

    except Exception, exception:
        logger.logException(exception)
        return cliUtil.RESULT_NOCHECK, cliRetAll, common.getMsg(lang,"query.result.abnormal")
    finally:
        common.finishProcess(py_java_env)
        logger.logInfo("finish process!")