# -*- coding: UTF-8 -*-
from cbb.business.operate.fru.common.checkItem import compute_storage_common
from cbb.frame.checkitem.context_adapter import InspectContext
import common
import cliUtil
import common_utils

PY_JAVA_ENV = py_java_env
LANG = common.getLang(PY_JAVA_ENV)
LOGGER = common.getLogger(PY_LOGGER, __file__)
FAN_QUERY_URI = "/redfish/v1/chassis/enclosure/thermal"


def execute(cli):
    context = InspectContext(PY_JAVA_ENV, cli)
    inspect_context = context.get_context()
    if not common.check_holding_fcv_connection(inspect_context):
        return cliUtil.RESULT_NOSUPPORT, "", ""

    inspect_context["devNode0"] = inspect_context.get("devInfo")
    redfish_conn = compute_storage_common.get_redfish_connection(inspect_context)
    all_cli_ret = [FAN_QUERY_URI]
    record = compute_storage_common.get_info_by_redfish_rest_conn(redfish_conn, FAN_QUERY_URI)
    all_cli_ret.append(str(record))

    err_fan_list = []
    all_detected_fans = []
    for fan in record.get("Fans", [{}]):
        all_detected_fans.append(fan.get("Name"))
        if fan.get("Status", {}).get("Health") != "OK":
            err_fan_list.append(fan.get("Name"))
    err_fan_list.extend(check_enc_fan(cli, all_cli_ret))

    err_msg = ""
    if err_fan_list:
        err_msg = common_utils.get_err_msg(
            LANG, "computer.storage.fan.health.status.abnormal", ", ".join(err_fan_list)
        )
        LOGGER.logNoPass("The health status of power supply is abnormal")
    if len(all_detected_fans) < 16:
        # 判断是否存在不在位风扇
        # 每个风扇有两个前后转轮，共计16个前后转轮
        err_msg += common_utils.get_err_msg(LANG, "computer.storage.fan.detected.abnormal")
        LOGGER.logNoPass("A fan cannot be detected")
    if not err_msg:
        return True, "\n".join(all_cli_ret), ""
    return False, "\n".join(all_cli_ret), err_msg


def get_fan_info(cli, all_cli_ret):
    cmd = "show fan"
    LOGGER.logExecCmd(cmd)
    flag, ret, msg = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
    all_cli_ret.append(ret)
    common.refreshProcess(PY_JAVA_ENV, 4, LOGGER)
    return cliUtil.getHorizontalCliRet(ret)


def check_enc_fan(cli, all_cli_ret):
    fan_info_list = get_fan_info(cli, all_cli_ret)
    err_fan_list = []
    for fan_info in fan_info_list:
        fan_id = fan_info.get("ID", "")
        health_status = fan_info.get("Health Status")
        running_status = fan_info.get("Running Status")
        if health_status != common.STATUS_NORMAL or running_status != common.STATUS_RUNNING:
            err_fan_list.append(fan_id)
    return err_fan_list
