# -*- coding: UTF-8 -*-
import cliUtil
import common

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

def execute(cli):
    '''
        后端并发检查: 
                可以查询到后端并发数则正常，否则属于不正常状态。
    '''
    flag = True
    cliRet = ""
    cliRetAll = ""
    errMsg = ""

    try:
        checkRet = cliUtil.getControllerIdList(cli, LANG)
        if checkRet[0] != True:
            LOGGER.logNoPass("Cannot get information about controllers")
            # 修改备注：获取设备所有控制器ID（getControllerIdList）失败
            if not checkRet[0]:
                cliRetAll += checkRet[1]
                errMsg += checkRet[-1]
                return cliUtil.RESULT_NOCHECK, cliRetAll, errMsg
            return checkRet
            
        controllerList = checkRet[1]
        for contrlId in controllerList:
            cmd = "show controller io io_type=backEnd controller_id=%s" % contrlId
            LOGGER.logExecCmd(cmd)
            checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
            cliRetAll += checkRet[1]
            if checkRet[0] != True:
                flag = False
                if "error:" in checkRet[1].lower():
                    errMsg += common.getMsg(LANG, "cannot.get.back.end.io.info", contrlId)
                elif checkRet[2] not in errMsg:
                    errMsg += checkRet[2]
                continue
            
            cliRet = checkRet[1]
            if not "Back End IO" in cliRet:
                flag = False
                errMsg += common.getMsg(LANG, "cannot.get.back.end.io.info", contrlId)
                LOGGER.logNoPass("Cannot get information about Back End IO of Controller [%s]" % contrlId)
            
        if flag:
            LOGGER.logPass()
            
        return (flag, cliRetAll, errMsg)
    
    except Exception, exception:
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, cliRetAll, common.getMsg(LANG, "query.result.abnormal"))
