# -*- coding: UTF-8 -*-
import cliUtil
import traceback
import common
from config import risk_sn_for_meiguang
from common import UnCheckException

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
PY_JAVA_ENV = py_java_env
allCliRet = ""


def execute(cli):
    """
    @summary: 1、升级后BIOS版本会提高
            2、推荐101补丁
            3、V3R1~V3R6C10SPC100（补丁是解决其他问题）
                                背景：
            1、8G内存：业务中断（单控）（20+事故）
            2、16G：控制器反复复位
    """
    try:
        # 检查设备型号是否为问题型号      
        isBugModel, productModel, sn = checkProductModel(cli)
        if not isBugModel:
            return (True, allCliRet, "")

        # 检查系统版本
        isBugVersion = checkProductVersion(cli)
        if not isBugVersion:
            return (True, allCliRet, "")

        # 检查BIOS版本
        bugVersiones = checkBIOSVersion(cli)
        if not bugVersiones:
            return (True, allCliRet, "")

        # 检查整机条码
        errMsg = checkSn(sn)

        # 检查内存型号
        bugModeles = checkMemoryModel(cli)
        if not bugModeles:
            if not errMsg:
                return (True, allCliRet, "")

        errMsg = common.joinLines(
            common.getMsg(LANG, "contr.bois.memory.version.less", (productModel, ",".join(bugVersiones))), errMsg)
        return (cliUtil.RESULT_WARNING, allCliRet, errMsg)

    except UnCheckException, unCheckException:
        LOGGER.logException(unCheckException)
        return (cliUtil.RESULT_NOCHECK, unCheckException.cliRet, unCheckException.errorMsg)

    except Exception, exception:
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, allCliRet, common.getMsg(LANG, "query.result.abnormal"))


def checkSn(sn):
    """
    检查风险整机条码
    :param sn:
    :return:
    """
    if sn in risk_sn_for_meiguang:
        return common.getMsg(LANG, "meiguang.risk.sn.suggestion")
    return ""


def checkProductModel(cli):
    """
    @summary: 检查设备型号是否为问题型号
    @return: True 问题型号；False 非问题型号
    """

    global allCliRet
    productModel = ""
    riskSn = ""
    cmd = "show system general"
    # 获取产品型号
    flag, cliRet, errMsg = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
    allCliRet = common.joinLines(allCliRet, cliRet)
    if flag != True:
        raise UnCheckException(errMsg, allCliRet)
    # 问题型号
    bugModeles = ["2800 V3", "5300 V3", "5500 V3", "5500F V3"]
    cliRetList = cliUtil.getVerticalCliRet(cliRet)
    for cliRetDict in cliRetList:
        productModel = cliRetDict.get("Product Model", "")
        riskSn = cliRetDict.get("SN", "")
        if productModel in bugModeles:
            return (True, productModel, riskSn)

    return (False, productModel, riskSn)


def checkProductVersion(cli):
    """
    @summary: 检查系统版本是否为问题版本
    @return: True 问题版本；False 非问题版本
    """
    # 获取系统版本
    flag, cliRet, errMsg, softwareVersion, hotPatchVersion = common.getVersion(cli, LANG)
    global allCliRet
    allCliRet = common.joinLines(allCliRet, cliRet)
    if flag != True:
        raise UnCheckException(errMsg, allCliRet)

    biggestBugVersion = "V300R006C10SPC100"
    if softwareVersion < biggestBugVersion:
        return True

    solveHotPatchVersion = "V300R006C10SPH101"
    if softwareVersion == biggestBugVersion and hotPatchVersion < solveHotPatchVersion:
        return True

    return False


def checkBIOSVersion(cli):
    """
    @summary: 检查控制器BIOS是否为问题版本
    @return: True 问题版本； False 非问题版本
    """
    cmd = "show version all"
    flag, cliRet, errMsg = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
    global allCliRet
    allCliRet = common.joinLines(allCliRet, cliRet)
    if flag != True:
        raise UnCheckException(errMsg, allCliRet)

    cliRet = cliRet.split("Controller:")
    cliRet = cliRet[1] if len(cliRet) > 1 else cliRet[0]
    cliRet = cliRet.split("Expansion Module:")
    cliRet = cliRet[0]

    normalVersion = "10.01.07T36"
    bugVersiones = []

    for line in cliRet.splitlines():
        if ":" in line and "bios version" in line.lower():
            BIOSVersion = line.split(":")[1].strip()
            if BIOSVersion < normalVersion:
                bugVersiones.append(BIOSVersion)

    return list(set(bugVersiones))


def checkMemoryModel(cli):
    """
    @summary: 检查内存型号是否为问题型号
    @return: True 问题型号； False 非问题型号
    """
    cmd = "show memory"
    flag, cliRet, errMsg = cliUtil.excuteCmdInDeveloperMode(cli, cmd, True, LANG)
    global allCliRet
    allCliRet = common.joinLines(allCliRet, cliRet)
    if flag != True:
        raise UnCheckException(errMsg, allCliRet)

    memoryInfoItems = cliUtil.getHorizontalNostandardCliRet(cliRet)
    if not memoryInfoItems:
        errMsg = common.getMsg(LANG, "query.result.abnormal")
        raise UnCheckException(errMsg, allCliRet)

    bugModeles = ["18KSF1G72PDZ-1G6P", "36KSF2G72PZ-1G6P"]
    currentBugModeles = []

    for memoryInfoItem in memoryInfoItems:
        memoryModel = memoryInfoItem.get("SN")
        if memoryModel in bugModeles:
            currentBugModeles.append(memoryModel)

    return list(set(currentBugModeles))