# -*- coding: UTF-8 -*-
import cliUtil
import common

lang = common.getLang(py_java_env)
logger = common.getLogger(PY_LOGGER, __file__)

maxSingleEngDiskNum={
    "C01":
        {
            ("Dorado5000 V3", "NVME"):25,
            ("Dorado5000 V3", "SAS"):100,
            ("Dorado6000 V3", "SAS"):100,
        },
}

def execute(cli):
    '''
        扩容硬盘容量规格检查
    '''
    cliRetAll = ""
    versionList = ["V300R001C01"]
    expDiskList = common.getExpDiskListFromContextFilter(py_java_env)
    logger.logInfo("expDiskList is %s" % expDiskList)
    
    try:
        # 如果都是新建硬盘域,则不涉及
        if not expDiskList:
            return cliUtil.RESULT_NOSUPPORT, "", ""
        
        ret, sysVersionList, hotpatchVersionList = common.parse_upgradePackage(cli, lang)
        cliRet = ret[1]
        if not ret[0]:
            return cliUtil.RESULT_NOCHECK, cliRet, ret[2]

        # 非系统版本:"V300R001C01" 不涉及此检查项
        ret, sysVersion, errInfo = common.getCurrentVersion(sysVersionList,lang)
        logger.logInfo("current system version:%s" % (sysVersion))
        if not ret:
            errMsg = errInfo
            return cliUtil.RESULT_NOCHECK, cliRet, errMsg
        if sysVersion not in versionList:
            logger.logInfo("the current system version is not mentioned")
            return cliUtil.RESULT_NOSUPPORT, cliRet, ""

        cliRetAll += cliRet
        # 获取硬盘域信息
        flag, cliRet, errMsg, diskDomainList = common.getDiskDomainInfo(cli, lang)
        cliRetAll += cliRet
        if not flag:
            logger.logSysAbnormal()
            return cliUtil.RESULT_NOCHECK, cliRetAll, errMsg

        # 硬盘域不存在返回不涉及
        if flag and not diskDomainList:
            logger.logInfo("the disk domain is not exist")
            return cliUtil.RESULT_NOSUPPORT, cliRetAll, ""
        logger.logInfo("diskDomainList is %s" % diskDomainList)

        # 如果为双引擎系统，两个引擎新扩容硬盘数量不一致或者两个引擎新扩容硬盘容量不一致，检查不通过
        engineDiskNumDict = {}
        engineDiskCapacityDict = {}
        for line in expDiskList:
            engineId = line.get("eng")
            diskNum = int(line.get("diskNum"))
            diskCapacity = str(line.get("diskCapacity"))
            capacityUnit = str(line.get("unit"))
            diskCapacity2GB = common.changUnit2GB(diskCapacity + capacityUnit, isLabelCap=True)
            engineDiskNumDict[engineId] = engineDiskNumDict.get(engineId, 0) + diskNum
            engineDiskCapacityDict[engineId] = engineDiskCapacityDict.get(engineId, 0) + diskCapacity2GB[1] * diskNum
        
        logger.logInfo("engineDiskNumDict is %s" % engineDiskNumDict)
        logger.logInfo("engineDiskCapacityDict is %s" % engineDiskCapacityDict)

        if len(set(engineDiskNumDict.values())) != 1:
            logger.logNoPass("the disk number of engines is inconsistent")
            errMsg = common.getMsg(lang, "expand.disk.number.not.pass")
            return False, cliRetAll, errMsg

        engineDiskCapacityListBase50GbDiff = common.getDiskCapListBaseOn50GBDiff(engineDiskCapacityDict.values())
        logger.logInfo("engineDiskCapacityListBase50GbDiff is %s" % engineDiskCapacityListBase50GbDiff)
        if len(set(engineDiskCapacityListBase50GbDiff)) != 1:
            logger.logNoPass("the disk capacity of engines is not consistent")
            errMsg = common.getMsg(lang, "expand.disk.capacity.not.pass")
            return False, cliRetAll, errMsg

        for diskDomain in diskDomainList:
            diskDomainId = diskDomain.get("ID")
            flag, cliRet, errMsg, diskInDomainList = common.getDiskDomainInfoById(cli, diskDomainId, lang)
            cliRetAll += cliRet
            if not flag:
                return cliUtil.RESULT_NOCHECK, cliRetAll, errMsg

            # 获取硬盘域中的硬盘类型
            diskTypeList = [disk.get("Type") for disk in diskInDomainList]
            logger.logInfo("diskTypeList is %s" % diskTypeList)

            # 根据硬盘域ID获取对应的新扩硬盘类型
            newExpDiskList = filter(lambda disk:disk.get("diskDomain") == diskDomainId, expDiskList)
            logger.logInfo("newExpDiskList is %s" % newExpDiskList)

            newDiskModelList = [disk.get("diskModel") for disk in newExpDiskList]
            logger.logInfo("diskModelList is %s" % newDiskModelList)

            # 新扩容硬盘类型和已有硬盘域中的SSD硬盘类型(加密:SSDSED;非加密硬盘SSD等)不一致
            if len(set(diskTypeList)) == 1 and set(diskTypeList) != set(newDiskModelList):
                flag = False
                logger.logNoPass("the disk type of the system diskdomain is not consistent with the expanding diskType")
                errMsg += common.getMsg(lang, "expand.disk.type.not.pass")
                continue

            # 获取新扩容硬盘容量
            newDiskCapacityList = []
            for line in newExpDiskList:
                diskCapacity = str(line.get("diskCapacity"))
                capacityUnit = str(line.get("unit"))
                diskCapacityGB = common.changUnit2GB(diskCapacity + capacityUnit, isLabelCap=True)
                newDiskCapacityList.append(diskCapacityGB[1])
            logger.logInfo("newDiskCapacityList is %s" % newDiskCapacityList)
            
            newDiskCapacityListBase50GbDiff = common.getDiskCapListBaseOn50GBDiff(newDiskCapacityList)
            logger.logInfo("newDiskCapacityListBase50GbDiff is %s" % newDiskCapacityListBase50GbDiff)
            # 同一批次新扩容的硬盘容量不止一种,检查不通过
            if len(set(newDiskCapacityListBase50GbDiff)) != 1:
                flag = False
                logger.logNoPass("The capacity of new expand disk is not consistent")
                errMsg += common.getMsg(lang, "expand.disk.capacity.not.pass")
                continue
            
            diskCapacityList = [] # 当前硬盘域(ID为diskDomainId)中所有硬盘的容量列表
            for disk in diskInDomainList:
                diskId = disk.get("ID") # 获取硬盘域中的硬盘ID
                isQrySucc, gbCap , errInfo= common.getDiskCapacityByDiskId(cli, diskId, lang,isHasLog=False)
                if not isQrySucc:
                    flag = False
                    errMsg += errInfo
                    continue
                diskCapacityList.append(gbCap)
            
            logger.logInfo("diskCapacityList is %s" % diskCapacityList)
            if not flag:
                return cliUtil.RESULT_NOCHECK, cliRetAll, errMsg
            
            # 如果系统硬盘域中容量加上新扩容硬盘容量不止一种，检查不通过。
            diskCapacityListBase50GbDiff = common.getDiskCapListBaseOn50GBDiff(diskCapacityList)
            logger.logInfo("diskCapacityList is %s" % diskCapacityListBase50GbDiff)
            newAndOldDiskCapList = newDiskCapacityList + diskCapacityList
            newAndOldDiskCapListBase50GB = common.getDiskCapListBaseOn50GBDiff(newAndOldDiskCapList)
            logger.logInfo("newAndOldDiskCapList is %s" % newAndOldDiskCapList)
            logger.logInfo("newAndOldDiskCapListBase50GB is %s" % newAndOldDiskCapListBase50GB)
            
            if len(set(newAndOldDiskCapListBase50GB)) != 1:
                orgDiskCapacity = diskCapacityListBase50GbDiff[0]
                newDiskCapacity = newDiskCapacityListBase50GbDiff[0]
                flag = False
                logger.logNoPass("The capacity disk is larger than new disk capacity")
                errMsg += common.getMsg(lang, "expand.disk.capacity.scale3.not.pass",
                                        (newDiskCapacity, orgDiskCapacity))
                continue
            
            isNvme = isNvmeDisk(newDiskModelList[0])
            # 检查单引擎最大规格是否满足要求
            # 获取设备型号
            devInfo = common.getCurDeviceInfo(py_java_env)
            productModel = str(devInfo.getDeviceType())
            logger.logInfo("productModel=%s" % str(productModel))
            # 引擎最大硬盘数
            maxEngDiskNum = getMaxDisknum("C01", productModel, isNvme)
            # 获取硬盘域中在每个引擎上的硬盘数
            engineDiskNumDic = getEngineDiskNumDic(diskInDomainList)
            # 引擎上新扩硬盘数字典
            newExpDiskNumDic = getNewExpDiskNumDic(newExpDiskList)
            
            for engineId in newExpDiskNumDic:
                if (engineDiskNumDic.get(engineId) + newExpDiskNumDic.get(engineId)) > maxEngDiskNum:
                    flag = False
                    logger.logNoPass("The condition of expand disk is not pass in single engine")
                    errMsg += common.getMsg(lang, "expand.disk.number.scale.not.pass", (engineId, newExpDiskNumDic.get(engineId), maxEngDiskNum))
                    return flag, cliRetAll, errMsg
                
        return flag, cliRetAll, errMsg

    except Exception, exception:
        logger.logException(exception)
        return cliUtil.RESULT_NOCHECK, cliRetAll, common.getMsg(lang,"query.result.abnormal")

def getEngineDiskNumDic(diskInDomainList):
    engineDiskNumDic = {} # {"0":50,"1":100}
    for disk in diskInDomainList:
        engineId = common.getEngineIdByDiskId(disk.get("ID"))  # 根据硬盘ID获取引擎ID
        engineDiskNumDic[engineId] = engineDiskNumDic.get(engineId, 0) + 1
    logger.logInfo("engineDiskNumDic is %s" % engineDiskNumDic)
    return engineDiskNumDic

def getNewExpDiskNumDic(newExpDiskList):
    newExpDiskNumDic = {}  # {"0":40,"1":50}
    for newExpDisk in newExpDiskList:
        engineId = newExpDisk.get("logicEng")
        diskNum = int(newExpDisk.get("diskNum"))
        newExpDiskNumDic[engineId] = newExpDiskNumDic.get(engineId, 0) + diskNum
    logger.logInfo("newExpDiskNumDic is %s" % newExpDiskNumDic)
    return newExpDiskNumDic
        
def isNvmeDisk(diskModel):
    return "NVME" in diskModel.upper()

def getMaxDisknum(cVersion, productModel, isNvme=False):
    productTypeStr = "SAS"
    if isNvme:
        productTypeStr = "NVME"
    return maxSingleEngDiskNum.get(cVersion).get((productModel, productTypeStr))