# -*- coding: UTF-8 -*-
import cliUtil
import common

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

def execute(cli):
    '''
    SAS端口检查：
        1 Health Status必须为Normal。端口Running Status为Link Down时表示正常，
                   当为Link Up时，端口（不包括下行口EXP）连接必须对称且工作速率为6000Mbps或12000Mbps时表示正常；
        2 其它情况均属于不正常状态。
    '''
    flag = True
    cliRet = ""
    errMsg = ""
    portName = "SAS"
    
    try:
        cmd = "show port general physical_type=SAS"
        LOGGER.logExecCmd(cmd)
        flag, cliRet, errMsg = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        if flag != True:
            cmd = "show enclosure"
            LOGGER.logExecCmd(cmd)
            cliRetForCheckNVMe = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
            if not cliUtil.hasCliExecPrivilege(cliRet) and "NVMe" in cliRetForCheckNVMe[1] :
                flag = cliUtil.RESULT_NOSUPPORT
                cliRet += "\n" + cliRetForCheckNVMe[1]
                return flag, cliRet, ""
            return flag, cliRet, errMsg
            
        
        if cliUtil.queryResultWithNoRecord(cliRet):
            return (True, cliRet, errMsg)
        
        cliRetLinesList = cliUtil.getHorizontalCliRet(cliRet)
        if len(cliRetLinesList) == 0:
            errMsg = common.getMsg(LANG, "cannot.get.port.info", portName)
            LOGGER.logNoPass("Cannot get information about SAS port")
            return (cliUtil.RESULT_NOCHECK, cliRet, errMsg)  # 修改备注：解析回显失败导致列表长度为0

        engineNameSet = set()
        normalEngineList = []
        normalPortsList = []
        
        getEng0IdRet = cliUtil.getEng0Id(cli, LANG)
        if getEng0IdRet[0] != True:
            errMsg += getEng0IdRet[2]
            if not getEng0IdRet[0]:
                return cliUtil.RESULT_NOCHECK, cliRet, errMsg  # 修改备注：getEng0Id中解析回显失败导致列表长度为0
            return (getEng0IdRet[0], cliRet, errMsg)
        
        engine0Id = getEng0IdRet[1]
        enclosureHeightRet = cliUtil.getEnclosureHeight(cli, engine0Id, LANG)
        if enclosureHeightRet[0] != True:
            errMsg += enclosureHeightRet[2]
            if not enclosureHeightRet[0]:
                return cliUtil.RESULT_NOCHECK, cliRet, errMsg  # 修改备注：根据框ID获取框高度(U)（getEnclosureHeight）执行失败，返回False
            return (enclosureHeightRet[0], cliRet, errMsg)
        enclosureHeight = enclosureHeightRet[1]
        
        #18000 v3 (6u) port0Items 是不一样的,因为只能插SAS大卡，所以没有IOM0/IOM1这个段位。
        #而其他设备用的是sas小卡，所以存在上下卡位之分，有IOM0/IOM1之分。
        storageTypeRet = cliUtil.getProductModel(cli, LANG)
        if storageTypeRet[0] != True:
            # 修改备注：获取产品类型（getProductModel）执行失败，返回False
            if not storageTypeRet[0]:
                return cliUtil.RESULT_NOCHECK, storageTypeRet[1], storageTypeRet[2]
            return storageTypeRet
        productType = storageTypeRet[1]
        if productType in ["18500 V3","18800 V3","18500F V3","18800F V3","18500 V5","18800 V5","18500F V5","18800F V5","6800 V5","6800F V5"]:
            port0Items = [".L5.P0",".R5.P0"]
        else:
            port0Items = [".A0.P0", ".B0.P0"]
            if enclosureHeight in ["2", "6"]:
                port0Items = [".L0.IOM0.P0", ".R0.IOM0.P0"]
        
        for line in cliRetLinesList: 
            portId = line.get("ID")
            healthStatus = line.get("Health Status") 
            runningStatus = line.get("Running Status")
            workingRate = line.get("Working Rate(Mbps)")
            engName = portId.split(".")[0]
            
            if cliUtil.isEngineId(portId):
                engineNameSet.add(engName)
                        
            if healthStatus != common.STATUS_NORMAL:
                flag = False
                errMsg += common.getMsg(LANG, "port.health.status.abnormal", (portName, portId, healthStatus))
                LOGGER.logNoPass("The Health Status of SAS port [%s] is abnormal (Health Status:%s)" % 
                 (portId, healthStatus))
                
            if runningStatus != common.STATUS_LINK_UP:
                #引擎0的P0端口必须link up
                if portId in [engine0Id + port0 for port0 in port0Items]:
                    flag = False
                    errMsg += common.getMsg(LANG, "sas.port.running.status.abnormal", (portId, runningStatus))
                    LOGGER.logNoPass("The Running Status of SAS port [%s] is abnormal (Running Status:%s)" % 
                     (portId, runningStatus))
                        
            if  healthStatus == common.STATUS_NORMAL and runningStatus == common.STATUS_LINK_UP:
                if cliUtil.isEngineId(portId):
                    normalEngineList.append(portId)
                #V3R6F系列由PRI /EXP，替换成P0/P1    
                if (".A" in portId or ".B" in portId or ".L" in portId or ".R" in portId) and (".EXP" not in portId and (".P1" not in portId and "DAE" in portId)):
                    normalPortsList.append(portId)
                    
                if workingRate not in ["6000", "12000"]:
                    flag = False
                    errMsg += common.getMsg(LANG, "port.working.rate.abnormal", (portName, portId, workingRate))
                    LOGGER.logNoPass("The working rate of %s port [%s] is abnormal (Working Rate:%sMbps)" % 
                     (portName, portId, workingRate))
        isSiglePdtModel = common.isSigleModel(cli, LANG)
        if not isSiglePdtModel:
            for normalPort in normalPortsList:
                symmetricalPort = common.getSymmetricalPort(normalPort)
                if len(symmetricalPort) == 0:
                    continue
                if symmetricalPort not in normalPortsList:
                    flag = False
                    errMsg += common.getMsg(LANG, "sas.port.link.none.symmetrical", (symmetricalPort, normalPort))
                    LOGGER.logNoPass("The SAS port [%s] is improperly connected and is not symmetrical with [%s]" % 
                     (symmetricalPort, normalPort))
        
        storageTypeRet = cliUtil.getStorageType(cli, LANG)
        if storageTypeRet[0] != True:
            errMsg += storageTypeRet[2]
            if not storageTypeRet[0]:
                return cliUtil.RESULT_NOCHECK, storageTypeRet[1], errMsg  # 修改备注：获取存储设备类型（getStorageType）执行失败
            return (storageTypeRet[0], cliRet, errMsg)
        product_series = storageTypeRet[1]
        
        if product_series == cliUtil.SERIES_18000:
            if len(engineNameSet) == 0:
                flag = False
                errMsg += common.getMsg(LANG, "engine.zero.circle.not.connected")
                LOGGER.logNoPass("Loop 0 of the engine is not connected")
            
            for engineName in engineNameSet:
                for item in port0Items:
                    engineId = engineName + item
                    if engineId not in normalEngineList:
                        flag = False
                        errMsg += common.getMsg(LANG, "engine.zero.circle.connect.abnormal", engineId)
                        LOGGER.logNoPass("Loop 0 of the engine must be connected. The SAS port [%s] is disconnected" % (engineId))
            
        if flag:
            LOGGER.logPass()
        
        return (flag, cliRet, errMsg)
                                   
    except Exception, exception:
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, cliRet, common.getMsg(LANG, "query.result.abnormal"))
