# -*- coding: UTF-8 -*-

import cliUtil
import common
import config
import expandconfig
from cbb.frame.cli import cliUtil as cbb_cliUtil

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

CHECK_VERSION = "V500R007C60SPC100"
CHECK_PRODUCTS = ["5300 V5", "5300K V5", "5310 V5", "5500 V5", "5500K V5",
                  "5510 V5", "5600K V5", "5600 V5", "5610 V5", "5800 V5",
                  "5810 V5", "5310F V5", "5510F V5", "5610F V5", "5810F V5",
                  "5800K V5"]
SOLUTED_VERSION = "V500R007C60SPH105"


def execute(cli):
    """
     智能硬盘框检查：
            V500R007C60SPC100 SPH105之前的版本存在IP 智能硬盘框存在软转风险。
    :param cli:
    :return:
    """
    try:
        system_version = str(py_java_env.get("devInfo").getProductVersion())
        patch_version = str(py_java_env.get("devInfo").getHotPatchVersion())
        product_model = str(py_java_env.get("devInfo").getDeviceType())
        if CHECK_VERSION not in system_version:
            return cliUtil.RESULT_NOSUPPORT, "", ""

        if patch_version and patch_version != "--" and \
                patch_version >= SOLUTED_VERSION:
            return cliUtil.RESULT_NOSUPPORT, "", ""

        if product_model not in CHECK_PRODUCTS:
            return cliUtil.RESULT_NOSUPPORT, "", ""

        msg_version = system_version if (not patch_version
                                         or patch_version == "--") \
            else patch_version
        exp_config = expandconfig.ExpandConfig(py_java_env)
        exp_disk_list = exp_config.getAllExpDiskList()
        for d in exp_disk_list:
            if d.getDiskType() in \
                    [config.DiskType.NVMe_SSD, config.DiskType.NVMe_SSD_SED]:
                msg = common.getMsg(LANG, "smart.enclosure.failed", msg_version)
                return False, "A smart disk enclosure may be added.", msg

        ip_enclosures, cli_ret = cbb_cliUtil. \
            get_ip_enclosures_for_dorado_v6(cli, LANG, LOGGER)
        if ip_enclosures:
            msg = common.getMsg(LANG, "smart.enclosure.failed", msg_version)
            return False, cli_ret, msg

        return True, cli_ret, ""
    except Exception as e:
        LOGGER.logError(str(e))
        return cliUtil.RESULT_NOCHECK, "",\
            common.getMsg(LANG, "query.result.abnormal")
