# -*- coding: UTF-8 -*-
import common_utils
import cliUtil
import common
import traceback
import config
import re
from common import UnCheckException
import common_cache

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
PY_JAVA_ENV = py_java_env
allCliRet = ''


def execute(cli):
    '''
    @summary:
        步骤1 以admin用户登录设备；
        步骤2 在本端通过show hyper_metro_pair general方式查看当前阵列配置的所有的双活pair，查询出“TYPE”字段为“FS”的双活“ID”。
        步骤3 在本端执行show hyper_metro_pair general pair_id=<ID>查询本地文件系统ID“Local ID”及远端文件系统ID“Remote ID”。
        步骤4 在本端执行show file_system general file_system_id=<Local ID>查询归属控制器“Owner Controller”，容量“Capacity”及块大小“Block Size”。
        步骤5 在远端执行show file_system general file_system_id=<Local ID>查询归属控制器“Owner Controller”，容量“Capacity”及块大小“Block Size”。
        步骤6 比较本端与远端获取的数值
        步骤7 继续对比其余双活的本端及远端文件系统属性

        1、若步骤2查询结果没有“TYPE”字段为“FS”的双活pair，则检查通过。
        2、若步骤2与步骤3中的“Owner Controller”，“Capacity”及“Block Size”存在任意一个值不一致，则检查结果为建议优化。
    '''
    global allCliRet
    notPassErrMsg = ''
    suggestionMsg = ""
    noCheckMsg = ""
    try:

        localDevSn = PY_JAVA_ENV.get("devInfo").getDeviceSerialNumber()
        allCliRet += "ON LOCAL DEVICE(SN:%s)" % localDevSn

        # 检查是否有双活Domain域
        domainDict = getDomainInfo(localDevSn)
        LOGGER.logInfo("isRisk domainDict: %s, " % domainDict)
        if not domainDict:
            return True, allCliRet, ''

        # 检查是否添加了远端设备
        flag, addedSnList, errMsg = common.checkAddedRemoteDevSn(PY_JAVA_ENV, LANG)
        if flag != True:
            return common_utils.get_result_bureau(PY_JAVA_ENV, allCliRet, errMsg)
        LOGGER.logInfo("checkAddedRemoteDevSn addedSnList:%s" % addedSnList)

        domainRemoteDevDict = getRemoteDeviceInfo(localDevSn, domainDict)
        LOGGER.logInfo("domainRemoteDevDict :%s" % domainRemoteDevDict)
        for domainId in domainRemoteDevDict:
            remoteDevSn = domainRemoteDevDict[domainId]
            if remoteDevSn not in addedSnList:
                noCheckMsg += common.getMsg(LANG, "not.add.remote.device.again", remoteDevSn)
                continue

            pairIdList = getHyperMetroPairIdList(localDevSn, domainId)
            if not pairIdList:
                continue

            fsIdLocalToRemote, localFsIdList, remoteFsIdList, failPairIdList = getFsIdList(localDevSn, pairIdList)
            if failPairIdList:
                noCheckMsg += common.getMsg(LANG, "poolanddomain.pairinfo.query.failure", ",".join(failPairIdList))

            fsDetailInfoDictLocal, failFsListLocal = getFsInfoList(localDevSn, localFsIdList)
            if failFsListLocal:
                noCheckMsg += common.getMsg(LANG, "hypermetro.fs.cannot.get.filesystem.info", (",".join(failFsListLocal), localDevSn))

            allCliRet += "\n\nON REMOTE DEVICE(SN:%s)" % remoteDevSn
            fsDetailInfoDictRemote, failFsListRemote = getFsInfoList(remoteDevSn, remoteFsIdList)
            if failFsListRemote:
                noCheckMsg += common.getMsg(LANG, "hypermetro.fs.cannot.get.filesystem.info", (",".join(failFsListRemote), remoteDevSn))

            suggestionMsgTmp, notPassErrMsgTmp = checkFsConsistance(fsIdLocalToRemote, fsDetailInfoDictLocal, fsDetailInfoDictRemote)
            suggestionMsg += suggestionMsgTmp
            notPassErrMsg += notPassErrMsgTmp
            
            if len(domainRemoteDevDict) > 1:
                allCliRet += "\n\nON LOCAL DEVICE(SN:%s)" % localDevSn
        
        if notPassErrMsg:
            return False, allCliRet, notPassErrMsg + suggestionMsg + noCheckMsg
        
        if suggestionMsg:
            return cliUtil.RESULT_WARNING, allCliRet, suggestionMsg + noCheckMsg + common.getMsg(LANG, "fs.diff.sugg")

        if noCheckMsg:
            return common_utils.get_result_bureau(PY_JAVA_ENV, allCliRet, noCheckMsg)

        # 检查通过
        return True, allCliRet, ''

    except UnCheckException, unCheckException:
        LOGGER.logError(str(traceback.format_exc()))
        LOGGER.logInfo("UnCheckException, errMsg: %s" % unCheckException.errorMsg)
        if not unCheckException.flag:
            return cliUtil.RESULT_NOCHECK, unCheckException.cliRet, unCheckException.errorMsg

        return unCheckException.flag, unCheckException.cliRet, unCheckException.errorMsg
    except Exception, e:
        LOGGER.logError(e)
        LOGGER.logError(str(traceback.format_exc()))
        return cliUtil.RESULT_NOCHECK, allCliRet, common.getMsg(LANG, "query.result.abnormal")

    finally:
        # 退出到cli模式
        ret = cliUtil.enterCliModeFromSomeModel(cli, LANG)
        LOGGER.logInfo("enter cli mode from some model ret is %s" % str(ret))

        # 退出失败后为不影响后续检查项重新连接cli
        if not ret[0]:
            common.reConnectionCli(cli, LOGGER)


def checkFsConsistance(fsIdLocalToRemote, localFsInfoDict, remoteFsInfoDict):
    errMsg = ''
    notPassErrMsg = ''
    for localFsId in fsIdLocalToRemote:
        remoteFsId = fsIdLocalToRemote.get(localFsId)
        localFs = localFsInfoDict.get(localFsId, {})
        remoteFs = remoteFsInfoDict.get(remoteFsId, {})
        if localFs.get("ownerCtrl") != remoteFs.get("ownerCtrl"):
            errMsg += common.getMsg(LANG, "hypermetro.fs.some.info.consistency", (localFsId,remoteFsId,
            {"zh": u"工作控制器", "en": "Owner Controller"}.get(LANG), localFs.get("ownerCtrl"),
            remoteFs.get("ownerCtrl")))

        if localFs.get("capacity") != remoteFs.get("capacity"):
            notPassErrMsg += common.getMsg(LANG, "hypermetro.fs.some.info.consistency", (localFsId,remoteFsId,
                {"zh": u"容量", "en": "Capacity"}.get(LANG), localFs.get("capacity"),
                remoteFs.get("capacity")))

        if localFs.get("blocakSize") != remoteFs.get("blocakSize"):
            errMsg += common.getMsg(LANG, "hypermetro.fs.some.info.consistency", (localFsId,remoteFsId,
                {"zh": u"Block Size", "en": "Block Size"}.get(LANG), localFs.get("blocakSize"),
                remoteFs.get("blocakSize")))

    return errMsg, notPassErrMsg


def getFsIdList(devSn, pair_info_list):
    """
    获取文件系统pair
    :return:
    """
    global allCliRet
    fsIdLocalToRemote = {}
    localFsIdList = []
    remoteFsIdList = []
    failPairIdList = []
    for pair_info in pair_info_list:
        pair_id = pair_info.get("ID")
        fsLocalId = pair_info.get("Local ID")
        fsRemoteId = pair_info.get("Remote ID")
        if fsLocalId is not None and fsRemoteId is not None and\
                fsLocalId != '--' and fsRemoteId != '--':
            fsIdLocalToRemote[fsLocalId] = fsRemoteId
            localFsIdList.append(fsLocalId)
            remoteFsIdList.append(fsRemoteId)
        else:
            failPairIdList.append(pair_id)

    return fsIdLocalToRemote, localFsIdList, remoteFsIdList, failPairIdList


def getFsInfoList(devSn, fsInfoDict):
    """
    获取文件系统pair
    :param devSn:
    :return:
    """
    global allCliRet
    fsDetailInfoDict = {}
    failFsList = []
    for fsId in fsInfoDict:
        cmd = "show file_system general file_system_id=%s" % fsId
        flag, cliRet, errMsg = common.getObjFromFile(py_java_env, LOGGER, devSn, cmd)
        LOGGER.logInfo("Failed to get file_system:%s. flag:%s ,cliRet:%s, errMsg:%s" % (fsId, flag, cliRet, errMsg))
        allCliRet = common.joinLines(allCliRet, cliRet)
        if flag != True:
            LOGGER.logInfo("Failed to get getAllPairInfo. errMsg:%s" % errMsg)
            raise UnCheckException(errMsg, allCliRet)

        retLinesDictList = cliUtil.getVerticalCliRet(cliRet)
        for retLinesDict in retLinesDictList:
            ownerCtrl = retLinesDict.get("Owner Controller")
            capacity = retLinesDict.get("Capacity")
            blocakSize = retLinesDict.get("Block Size")
            if ownerCtrl is not None and capacity is not None and blocakSize is not None:
                fsDetailInfoDict[fsId] = {
                    "ownerCtrl": ownerCtrl,
                    "capacity": capacity,
                    "blocakSize": blocakSize}
            else:
                failFsList.append(fsId)

    return fsDetailInfoDict, failFsList


def getDomainInfo(devSn):
    """
    获取domain信息
    :param devSn:
    :return:
    """
    global allCliRet
    domainDict = {}
    cmd = "show hyper_metro_domain general"
    flag, cliRet, errMsg = common.getObjFromFile(py_java_env, LOGGER, devSn,
                                                 cmd)
    allCliRet = common.joinLines(allCliRet, cliRet)
    if flag != True:
        LOGGER.logInfo("Failed to get information about HyperMetro domain. errMsg:%s" % errMsg)
        raise UnCheckException(
            common.getMsg(LANG, "cannot.get.info", {"zh": u"双活域", "en": "HyperMetro domain"}.get(LANG)), allCliRet)

    hyperMetroDomainList = cliUtil.getHorizontalCliRet(cliRet)
    for domainInfo in hyperMetroDomainList:
        domainId = domainInfo.get("ID", '')
        remoteDeviceId = domainInfo.get("Remote Device ID", '')
        domainDict[domainId] = remoteDeviceId

    return domainDict


def getRemoteDeviceInfo(devSn, domainDict):
    """
    获取远端设备
    :param devSn:
    :param domainDict:
    :return:
    """
    global allCliRet
    remoteDeviceDict = {}
    cmd = "show remote_device general"
    flag, cliRet, errMsg = common.getObjFromFile(py_java_env, LOGGER, devSn, cmd)
    allCliRet = common.joinLines(allCliRet, cliRet)
    if flag is not True:
        LOGGER.logInfo("Failed to get information about remote device. errMsg:%s" % errMsg)
        raise UnCheckException(common.getMsg(LANG, "cannot.get.info", {"zh": u"远端设备", "en": "remote device"}.get(LANG)),
                               allCliRet)

    remoteDeviceList = cliUtil.getHorizontalCliRet(cliRet)
    for remoteDev in remoteDeviceList:
        remoteDeviceId = remoteDev.get("ID", '')
        remoteDeviceSn = remoteDev.get("SN", '')
        for domainId in domainDict:
            if remoteDeviceId == domainDict[domainId]:
                remoteDeviceDict[domainId] = remoteDeviceSn

    return remoteDeviceDict


def getHyperMetroPairIdList(devSn, domainId):
    """
    @summary: 获取双活pair
    @return: hyperMetroPairIdList 双活pair ID列表
    """
    global allCliRet
    flag, ret, msg, pair_list = common_cache.get_nas_pair_from_cache(
        py_java_env, LOGGER, devSn, LANG)
    allCliRet = common.joinLines(allCliRet, ret)
    if flag is not True:
        LOGGER.logInfo("Failed to get information about HyperMetro Pair")
        raise UnCheckException(msg)

    pair_list = [
        pair_info
        for pair_info in pair_list
        if pair_info.get("Domain ID") == domainId
    ]
    return pair_list
