# -*- coding: UTF-8 -*-
import cliUtil
import common
import common_cache
import traceback
from common import UnCheckException
import common_utils

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
PY_JAVA_ENV = py_java_env
ALL_CLI_RET_LIST = []


def execute(cli):
    '''
        双活两端的lun配置一致性检查：
        1、    若不存在双活pair，则检查结果为通过。
        2、    若步骤4与步骤6中的“Work Controller”值不一致，则检查结果为不通过。
        3、    若步骤4与步骤6中的“Disk Location”值都为“External”且存在厂商信息不为华为存储，则检查结果为不通过，其他情况检查结果为通过。
    '''
    global ALL_CLI_RET_LIST
    flag = True
    cliRet = ""
    errMsg = ""
    errNotPass = ""
    noCheckMsg = ''
    item = "hypermetro_lun_configuration_doradov6"
    try:
        
        #本端SN
        localDevSn = PY_JAVA_ENV.get("devInfo").getDeviceSerialNumber()
        ALL_CLI_RET_LIST.append("ON LOCAL DEVICE(SN:%s):" % localDevSn)

        # 检查是否有双活Domain域
        domainDict = getDomainInfo(localDevSn)
        LOGGER.logInfo("isRisk domainDict: %s, " % domainDict)
        if not domainDict:
            return (True, "\n".join(ALL_CLI_RET_LIST), errMsg)

        pairLunIdDict = getLunInfoByPair(localDevSn)
        
        if not pairLunIdDict:
            return (True, "\n".join(ALL_CLI_RET_LIST), errMsg)

        localDevSn = PY_JAVA_ENV.get("devInfo").getDeviceSerialNumber()


        # 检查是否添加了远端设备
        # 1、框架未获取到双活远端设备；2、存在远端设备且未添加
        flag, addedSnList, errMsg = common.checkAddedRemoteDevSn(PY_JAVA_ENV, LANG)
        if flag != True:
            return common_utils.get_result_bureau(PY_JAVA_ENV, "\n".join(ALL_CLI_RET_LIST), errMsg)

        flagList = []
        domainRemoteDevDict = getRemoteDeviceInfo(localDevSn, domainDict)
        for domainId in domainRemoteDevDict:
            # 查询该domainId下是否存在双活pair
            hyperMetroPairIdList = getHyperMetroPairIdList(localDevSn, domainId)
            if not hyperMetroPairIdList:
                continue

            localPairLunInfoDict = gethyperMetroPairInfo(hyperMetroPairIdList, pairLunIdDict, "localLunId", localDevSn)

            remoteDevSn = domainRemoteDevDict.get(domainId)
            if remoteDevSn not in addedSnList:
                flagList.append(cliUtil.RESULT_NOCHECK)
                noCheckMsg += common.getMsg(LANG, "not.add.remote.device.again", remoteDevSn)
                continue

            ALL_CLI_RET_LIST.append("\n\n\nON REMOTE DEVICE(SN:%s)" %
                                    remoteDevSn)
            errNotPass = check_pair_config(errNotPass, flagList,
                                           hyperMetroPairIdList,
                                           localPairLunInfoDict, pairLunIdDict,
                                           remoteDevSn)

        cli_ret = common_cache.save_cli_ret_to_file(ALL_CLI_RET_LIST,
                                                    item,
                                                    PY_JAVA_ENV, LOGGER)
        flagList = list(set(flagList))
        if False in flagList:
            return (False, cli_ret, errNotPass + noCheckMsg)

        if cliUtil.RESULT_WARNING in flagList:
            err_msg = errNotPass + noCheckMsg
            err_msg += common.getMsg(LANG, "hypermetro.lun.configration.doradov6.diff.attr.sugg")
            return (cliUtil.RESULT_WARNING, cli_ret, err_msg)
        
        if cliUtil.RESULT_NOCHECK in flagList:
            return common_utils.get_result_bureau(PY_JAVA_ENV, cli_ret, errNotPass + noCheckMsg)

        return (True, cli_ret, "")
   
    except UnCheckException as unCheckException:
        cli_ret = common_cache.save_cli_ret_to_file(
            ALL_CLI_RET_LIST, item, PY_JAVA_ENV, LOGGER)
        LOGGER.logInfo(u"UnCheckException, errMsg: %s" % unCheckException.errorMsg)
        if not unCheckException.flag:
            return cliUtil.RESULT_NOCHECK, cli_ret, unCheckException.errorMsg

        return unCheckException.flag, cli_ret, unCheckException.errorMsg

    except Exception:
        LOGGER.logError(str(traceback.format_exc()))
        cli_ret = common_cache.save_cli_ret_to_file(
            ALL_CLI_RET_LIST, item, PY_JAVA_ENV, LOGGER)
        return (cliUtil.RESULT_NOCHECK, cli_ret,
                common.getMsg(LANG, "query.result.abnormal"))


def check_pair_config(errNotPass, flagList, hyperMetroPairIdList,
                      localPairLunInfoDict, pairLunIdDict, remoteDevSn):
    remotePairLunInfoDict = gethyperMetroPairInfo(hyperMetroPairIdList,
                                                  pairLunIdDict, "remoteLunId",
                                                  remoteDevSn)
    for pairId in hyperMetroPairIdList:
        localLunInfo = localPairLunInfoDict.get(pairId, {})
        remoteLunInfo = remotePairLunInfoDict.get(pairId, {})

        if localLunInfo.get("compressionEnabled") != remoteLunInfo.get(
                "compressionEnabled"):
            flagList.append(cliUtil.RESULT_WARNING)
            errNotPass += common.getMsg(LANG,
                                        "pair.inconsistent.compressionEnabled",
                                        pairId)

        if localLunInfo.get("dedupEnabled") != remoteLunInfo.get(
                "dedupEnabled"):
            flagList.append(cliUtil.RESULT_WARNING)
            errNotPass += common.getMsg(LANG, "pair.inconsistent.dedupEnabled",
                                        pairId)

        if localLunInfo.get("diskLocl") == "External" or remoteLunInfo.get(
                "diskLocl") == "External":
            flagList.append(False)
            errNotPass += common.getMsg(LANG, "exist.external.array", pairId)
    return errNotPass


def getLunInfoByPair(locaDevSn):
    """
    @summary: 获取双活Pair与对应LUN的关系字典
    """
    global ALL_CLI_RET_LIST
    pairLunIdDict = {}
    flag, ret, msg, pair_list = common_cache.get_san_pair_from_cache(
        py_java_env, LOGGER, locaDevSn, LANG)
    ALL_CLI_RET_LIST.append(ret)
    if flag is not True:
        raise UnCheckException(msg, ret)
    for hyperMetroPairDict in pair_list:
        pairId = hyperMetroPairDict.get("ID", "")
        localID = hyperMetroPairDict.get("Local ID", "")
        remoteId = hyperMetroPairDict.get("Remote ID", "")

        pairLunIdDict[pairId] = {"localLunId": localID, "remoteLunId": remoteId}

    return pairLunIdDict


def getDomainInfo(devSn):
    """
    获取domain信息
    :param devSn:
    :return:
    """
    global ALL_CLI_RET_LIST
    domainDict = {}
    cmd = "show hyper_metro_domain general"
    flag, cliRet, errMsg = common.getObjFromFile(py_java_env, LOGGER, devSn,
                                                 cmd, LANG)
    ALL_CLI_RET_LIST.append(cliRet)
    if flag is not True:
        LOGGER.logInfo("Failed to get information about HyperMetro domain. errMsg:%s" % errMsg)
        raise UnCheckException(errMsg, cliRet)

    hyperMetroDomainList = cliUtil.getHorizontalCliRet(cliRet)
    for domainInfo in hyperMetroDomainList:
        domainId = domainInfo.get("ID", '')
        remoteDeviceId = domainInfo.get("Remote Device ID", '')
        domainDict[domainId] = remoteDeviceId

    return domainDict

def getHyperMetroPairIdList(devSn, domainId):
    """
    @summary: 获取双活pair
    @return: hyperMetroPairIdList 双活pair ID列表
    """
    global ALL_CLI_RET_LIST
    flag, ret, msg, pair_list = common_cache.get_san_pair_from_cache(
        py_java_env, LOGGER, devSn, LANG)
    ALL_CLI_RET_LIST.append(ret)
    if flag is not True:
        LOGGER.logInfo("Failed to get information about HyperMetro Pair")
        raise UnCheckException(msg)

    pair_list = [
        pair_info.get("ID")
        for pair_info in pair_list
        if pair_info.get("Domain ID") == domainId
    ]

    return pair_list


def getRemoteDeviceInfo(devSn, domainDict):
    """
    获取远端设备信息
    :param devSn:
    :param domainDict:
    :return:
    """
    global ALL_CLI_RET_LIST
    remoteDeviceDict = {}
    cmd = "show remote_device general"
    flag, cliRet, errMsg = common.getObjFromFile(py_java_env, LOGGER, devSn, cmd, LANG)
    ALL_CLI_RET_LIST.append(cliRet)
    if flag is not True:
        LOGGER.logInfo("Failed to get information about remote device. errMsg:%s" % errMsg)
        raise UnCheckException(errMsg, cliRet)

    remoteDeviceList = cliUtil.getHorizontalCliRet(cliRet)
    for remoteDev in remoteDeviceList:
        remoteDeviceId = remoteDev.get("ID", '')
        remoteDeviceSn = remoteDev.get("SN", '')
        for domainId in domainDict:
            if remoteDeviceId == domainDict[domainId]:
                remoteDeviceDict[domainId] = remoteDeviceSn

    return remoteDeviceDict


def gethyperMetroPairInfo(pairIdList, pairLunIdDict, keyParam, devSn):
    """
    :param pairIdList: 当前要检查的pairList
    :param pairLunIdDict: 全部pair的 local 和 remote lun id。
    :param keyParam: localLunId, remoteLunId
    :param devSn: 本端或远端SN
    :return:
    """
    global ALL_CLI_RET_LIST
    pairLunInfoDict = {}

    #获取双活两端LUN的工作控制器信息
    for pairId in pairIdList:
        lunId = pairLunIdDict[pairId].get(keyParam, "")
        cmd = "show lun general lun_id=%s" % lunId
        flag, cliRet, errMsg = common.getObjFromFile(py_java_env, LOGGER, devSn, cmd, LANG)
        ALL_CLI_RET_LIST.append(cliRet)
        if flag != True: 
            return (cliUtil.RESULT_NOCHECK, cliRet, errMsg)
        
        lunInfoDictList = cliUtil.getVerticalCliRet(cliRet)
        for lunInfo in lunInfoDictList:
            diskLocl = lunInfo.get("Disk Location", "")
            compressionEnabled = lunInfo.get("Compression Enabled", "")
            dedupEnabled = lunInfo.get("Dedup Enabled", "")
            pairLunInfoDict[pairId] = {
                "lunId" : lunId,
                "diskLocl":diskLocl,
                "compressionEnabled": compressionEnabled,
                "dedupEnabled": dedupEnabled,
                                  }
    return pairLunInfoDict

    
    
