# coding=UTF-8
# Copyright (c) Huawei Technologies Co., Ltd. 2019-2019. All rights reserved.
"""
@time: 2020/03/14
@file: check_item_software_whetherMinGoalReservePolicyIsConfigured.py
@function:
"""
import common
from cbb.frame.cli import cliUtil
import java.lang.Exception as JException
LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
RISK_VERSION_TUPLE = (
    "6.0.0", "6.0.0.SPH1", "6.0.0.SPH2", "6.0.0.SPH3", "6.0.0.SPH4",
    "6.0.0.SPH5")


def execute(cli):
    return LowerLimitsOfQoSPoliciesCheck(cli).exec_check()


class LowerLimitsOfQoSPoliciesCheck(object):
    def __init__(self, cli):
        self._cli = cli
        dev_info = common.getCurDeviceInfo(py_java_env)
        self._dev_type = str(dev_info.getDeviceType())
        self._dev_version = str(dev_info.getProductVersion())
        self._err_msg = common.getMsg(LANG, "query.result.abnormal")
        self._cli_ret_list = list()

    def exec_check(self):
        try:
            # Step1 风险版本型号判断
            common.refreshProcess(py_java_env, 5, LOGGER)
            if not self._is_risk_type_version():
                return True, self.get_cli_ret(), ""
            common.refreshProcess(py_java_env, 10, LOGGER)
            # Step2 查询QoS策略的ID
            QoS_strategy_ids = self._query_QoS_strategy_ids()
            common.refreshProcess(py_java_env, 30, LOGGER)
            # Step3 是否有下线保障QoS策略
            has_lower = self._has_lower_limits_QoS_strategy(QoS_strategy_ids)
            return not has_lower, self.get_cli_ret(), self._err_msg
        except (Exception, JException) as exception:
            LOGGER.logException(exception)
            return cliUtil.RESULT_NOCHECK, self.get_cli_ret(), self._err_msg

    def _is_risk_type_version(self):
        """
        是否是风险型号版本
        :return:
        """
        self._cli_ret_list.append("device type: {}".format(self._dev_type))
        self._cli_ret_list.append("device version: {}".
                                  format(self._dev_version))
        if not common.isDorado(self._dev_type):
            return False
        return self._dev_version in RISK_VERSION_TUPLE

    def _query_QoS_strategy_ids(self):
        """
        获取当前所有QoS策略的ID
        :return: id的List
        """
        query_cmd = "show smartqos_policy general"
        is_success, cli_ret, self._err_msg = cliUtil.execCmdInCliMode(
            self._cli, query_cmd, True, LANG)
        self._cli_ret_list.append(cli_ret)
        if not is_success:
            raise Exception("query smartqos_policy general failed")
        if cliUtil.queryResultWithNoRecord(cli_ret):
            return list()
        QoS_strategy_lines = cliUtil.getHorizontalCliRet(cli_ret)
        LOGGER.logInfo("QoS_strategy_lines: {}".format(QoS_strategy_lines))
        QoS_strategy_ids = list()
        for QoS_strategy_line in QoS_strategy_lines:
            strategy_id = QoS_strategy_line.get("ID")
            if strategy_id is None:
                continue
            QoS_strategy_ids.append(strategy_id)
        LOGGER.logInfo("QoS_strategy_ids: {}".format(QoS_strategy_ids))
        return QoS_strategy_ids

    def _has_lower_limits_QoS_strategy(self, QoS_strategy_ids):
        """
        是否有保低Qos策略
        :param QoS_strategy_ids: Qos策略IDs
        :return: True/False
        """
        lower_limits_strategy_ids = list()
        progress = 30
        if len(QoS_strategy_ids) == 0:
            self._err_msg = ""
            return False
        one_strategy_progress = 70 / len(QoS_strategy_ids)
        for strategy_id in QoS_strategy_ids:
            if self._is_lower_limits_Qos_strategy(strategy_id):
                lower_limits_strategy_ids.append(strategy_id)
            progress += one_strategy_progress
            common.refreshProcess(py_java_env, progress, LOGGER)
        if len(lower_limits_strategy_ids) == 0:
            self._err_msg = ""
            return False
        self._err_msg = common.getMsg(LANG, "has.min.QoS.strategy.notpass",
                                      ",".join(lower_limits_strategy_ids))
        return True

    def _is_lower_limits_Qos_strategy(self, strategy_id):
        """
        是否是下线保障QoS策略
        :param strategy_id: 策略id
        :return: True/False
        """
        query_cmd = "show smartqos_policy general smartqos_policy_id=" + \
                    strategy_id
        is_success, cli_ret, self._err_msg = cliUtil.execCmdInCliMode(
            self._cli, query_cmd, True, LANG)
        self._cli_ret_list.append(cli_ret)
        if not is_success:
            raise Exception("query lower Qos strategy[Id{}] failed".
                            format(strategy_id))

        detail_strategy_lines = cliUtil.getVerticalCliRet(cli_ret)
        LOGGER.logInfo("detail_strategys: {}".format(detail_strategy_lines))

        detail_keys = ("Min Bandwidth(MBps)", "Min IOPS", "Latency(ms)")
        for detail_strategy_line in detail_strategy_lines:
            for key in detail_keys:
                detail = detail_strategy_line.get(key)
                if detail is None:
                    self._err_msg = \
                        common.getMsg(LANG, "has.min.QoS.strategy.notcheck",
                                      (strategy_id, key))
                    raise Exception("Not find QoS strategy deatail field.")
                if detail != "--":
                    LOGGER.logInfo("Strategy {} is lower".format(strategy_id))
                    return True
        LOGGER.logInfo("Strategy {} is not lower".format(strategy_id))
        return False

    def get_cli_ret(self):
        """
        拼接获取所有原始信息
        :return:
        """
        if len(self._cli_ret_list) == 0:
            return "No information."
        return "\n".join(self._cli_ret_list)
