# -*- coding: UTF-8 -*-
import cliUtil
import common
from common import AsynProgress

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
PY_JAVA_ENV = py_java_env

def execute(cli):
    '''
    LUN迁移运行状态检查：
        1 如果LUN迁移不存在表示正常；
        2 Running Status为Fault表示不正常，否则表示正常。
    '''
    flag = True
    cliRet = ""
    errMsg = ""

    myPthread = AsynProgress(PY_JAVA_ENV, LOGGER)
    myPthread.start_thread()
    try:
        cmd = "show lun_migration general"
        LOGGER.logExecCmd(cmd)
        checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        cliRet = checkRet[1]

        # 校验是否包含错误码，如果包含则不涉及
        if cliUtil.has_unknown_error(checkRet[1]):
            return cliUtil.RESULT_NOSUPPORT, cliRet, cliUtil.getMsg(LANG, "has.not.license")

        if not cliUtil.hasCliExecPrivilege(checkRet[1]):
            errMsg = cliUtil.getMsg(LANG, "has.not.cli.privilege")
            return (cliUtil.RESULT_NOSUPPORT, cliRet, "")
        
        if checkRet[0] != True: 
            LOGGER.logSysAbnormal()
            return checkRet
        
        if cliUtil.queryResultWithNoRecord(cliRet):
            return (True, cliRet, errMsg)
        
        cliRetLinesList = cliUtil.getHorizontalCliRet(cliRet)
        if len(cliRetLinesList) == 0:
            errMsg = common.getMsg(LANG, "cannot.get.lun.migration.info")
            LOGGER.logNoPass("Cannot get information about LUN migration")
            return (cliUtil.RESULT_NOCHECK, cliRet, errMsg)  # 修改备注：解析回显失败导致列表长度为0

        for line in cliRetLinesList:
            Id = line.get("Source LUN ID")
            runningStatus = line.get("Running Status")
            if runningStatus == common.STATUS_FAULT or runningStatus == common.STATUS_INTERRUPT:
                flag = False
                errMsg += common.getMsg(LANG, "lun.migration.running.status.abnormal", (Id, runningStatus))
                LOGGER.logNoPass("The Running Status of LUN migration%s] is abnormal (Running Status:%s)" 
                     % (Id, runningStatus))
        common.refreshProcess(PY_JAVA_ENV, 100, LOGGER)
        if flag:
            LOGGER.logPass()
                 
        return (flag, cliRet, errMsg)

    except Exception, exception:
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, cliRet, common.getMsg(LANG, "query.result.abnormal"))
    finally:
        myPthread.setStopFlag(True)
