# -*- coding: UTF-8 -*-
import cliUtil
import common

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

ABNORMAL_STATUS_LIST = ["registration_failed", "unavailable"]


def execute(cli):
    """
    远端LUN路径状态检查：
    """
    err_msg_list = []
    ret_list = []
    try:
        for abnormal_status in ABNORMAL_STATUS_LIST:
            res_list = get_remote_lun_patch_status(
                cli, abnormal_status, ret_list
            )
            if not res_list:
                continue

            err_msg_list.append(
                common.getMsg(
                    LANG,
                    "remote.lun.path.status.abnormal.not.pass",
                    abnormal_status,
                )
            )
        all_ret = "\n".join(ret_list)
        if err_msg_list:
            return False, all_ret, "".join(err_msg_list)
        return True, all_ret, ""
    except common.UnCheckException as e:
        return cliUtil.RESULT_NOCHECK, "\n".join(ret_list), e.errorMsg
    except Exception as exception:
        LOGGER.logException(exception)
        return (
            cliUtil.RESULT_NOCHECK,
            "\n".join(ret_list),
            common.getMsg(LANG, "query.result.abnormal"),
        )


def get_remote_lun_patch_status(cli, abnormal_status, ret_list):
    """
    获取远端LUN路径状态
    :param cli: ssh连接
    :param abnormal_status: 不正常的状态
    :param ret_list: 解析结果
    :return:
    """
    cmd = "show remote_lun path_status path_priority={}".format(
        abnormal_status
    )
    flag, ret, msg = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
    ret_list.append(ret)
    if flag is not True:
        if not cliUtil.hasCliExecPrivilege(ret):
            return []
        if "TOOLKIT_SEND_CMD_TIME_OUT" in ret:
            msg = common.getMsg(LANG, "remote.lun.path.status.timeout")
        raise common.UnCheckException(msg, ret)

    return cliUtil.getHorizontalNostandardCliRet(ret)
