# -*- coding: UTF-8 -*-
import cliUtil
import common
import config
import traceback
from common import UnCheckException

import cli_util_cache
import common_cache
from cbb.frame.cli.cli_with_cache import execute_cmd_in_cli_mode_with_cache

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
PY_JAVA_ENV = py_java_env
ALL_CLI_RET = ''
NEED_PROCESS = True
C_VERSION = "V300R006C10"
R_VERSION = "V300R006"
CHECKED_TRUE_VALUE = "1"
CHECKED_FALSE_VALUE = "2"
NO_CHECKED_VALUE = '0'


def execute(cli):
    """
    @summary: 第三方多路径的双活配置检查
    """
    not_pass_err_msg_list = []
    no_check_msg_list = []
    all_ret_list = []
    try:
        common.refreshProcess(PY_JAVA_ENV, 1, LOGGER)
        # 步骤2 执行命令：show upgrade package，获取设备的当前软件版本；
        flag, p_ver, patch, ret, msg = \
            common_cache.get_version_and_patch_cache(
                PY_JAVA_ENV, cli, LOGGER)
        common.refreshProcess(PY_JAVA_ENV, 2, LOGGER)
        all_ret_list.append(ret)
        LOGGER.logInfo("productVersion is :%s" % p_ver)
        if flag is not True:
            return flag, ret, msg
        # 步骤3 执行命令：show hyper_metro_pair general，检查是否有双活pair
        has_hyper_flag = has_hyper_metro_pair(cli, all_ret_list)
        LOGGER.logInfo("has_hyper_flag: %s" % str(has_hyper_flag))
        common.refreshProcess(PY_JAVA_ENV, 3, LOGGER)
        if not has_hyper_flag:
            return True, "\n".join(all_ret_list), ""
        all_ini_list = get_ini_info_on_array(cli, all_ret_list)
        LOGGER.logInfo("all_ini_list: %s" % str(all_ini_list))
        if not all_ini_list:
            return True, "\n".join(all_ret_list), ''
        man_check_ini_dict = check_3rd_multi_hyper_metro_config(all_ini_list, no_check_msg_list, not_pass_err_msg_list,
                                                                p_ver)
        # 开局场景，在人工检查项之前要是没有其他不通过项，则是建议优化，如果有其他项，则人工结果合并入其他检查项结果
        temp_result = cliUtil.RESULT_WARNING if common.is_opening_delivery_inspect(
            PY_JAVA_ENV) and not not_pass_err_msg_list else False
        # 人工检查结果
        tmp_err, tmp_nocheck = get_man_check_result(man_check_ini_dict, all_ini_list)
        if tmp_err:
            not_pass_err_msg_list.append(tmp_err)
        if tmp_nocheck:
            no_check_msg_list.append(tmp_nocheck)
        if not_pass_err_msg_list:
            msg = "".join(not_pass_err_msg_list) + "".join(no_check_msg_list)
            return temp_result, "\n".join(all_ret_list), msg
        if no_check_msg_list:
            result_status = cliUtil.RESULT_WARNING if common.is_opening_delivery_inspect(
                PY_JAVA_ENV) else cliUtil.RESULT_NOCHECK
            sugg_msg = common.getMsg(LANG, "3rdmutipath.hyper.metro.config.sugg.oceanstor")
            msg = "".join(no_check_msg_list) + sugg_msg
            return result_status, "\n".join(all_ret_list), msg
        # 不存在风险
        return True, "\n".join(all_ret_list), ''
    except UnCheckException as e:
        LOGGER.logError("UnCheckException, errMsg: {}".format(e.errorMsg))
        return (cliUtil.RESULT_NOCHECK, "\n".join(all_ret_list) + e.cliRet,
                e.errorMsg)
    except Exception as e:
        LOGGER.logError("catch exception: {}".format(str(e)))
        LOGGER.logError(str(traceback.format_exc()))
        return (cliUtil.RESULT_NOCHECK, "\n".join(all_ret_list),
                common.getMsg(LANG, "query.result.abnormal"))
    finally:
        common.refreshProcess(PY_JAVA_ENV, 100, LOGGER)


def check_3rd_multi_hyper_metro_config(all_ini_list, no_check_msg_list, not_pass_err_msg_list, p_ver):
    added_host_ini_dict, man_check_ini_dict = get_ini_info_on_real_host()
    LOGGER.logInfo("added host dict: %s" % str(added_host_ini_dict))
    LOGGER.logInfo("man check dict: %s" % str(man_check_ini_dict))
    # 检查操作系统是否配置这期
    tmp_err, tmp_nocheck = check_operator_sys_right(added_host_ini_dict,
                                                    all_ini_list)
    LOGGER.logInfo("tmp_err: %s, tmp_nocheck:%s" % (tmp_err,
                                                    tmp_nocheck))
    if tmp_err:
        not_pass_err_msg_list.append(tmp_err)
    if tmp_nocheck:
        no_check_msg_list.append(tmp_nocheck)
    # 获取多路径分类信息
    hw_list, other_list, ignore_list = get_path_classification(added_host_ini_dict, man_check_ini_dict)
    LOGGER.logInfo("hw_list: %s, other_list:%s, ignore_list:%s" % (
        hw_list, other_list, ignore_list))
    # 人工检查忽略的加入错误消息。
    if ignore_list:
        title_key = "third.paty.multipath.hyper.config.ignore.ini"
        no_check_ini_title = common.getMsg(LANG, title_key)
        tmp_list = get_error_msg_by_ini(ignore_list, all_ini_list)
        if tmp_list:
            no_check_msg_list.append(no_check_ini_title + "\n".join( tmp_list))
    config_error_msg = check_config_right(p_ver, hw_list, other_list, all_ini_list)
    if config_error_msg:
        not_pass_err_msg_list.append(config_error_msg)
    LOGGER.logInfo("config_error_msg: %s" % config_error_msg)
    # 获取未检查信息
    no_check_ini_on_array_err_msg = get_no_check_msg(all_ini_list, added_host_ini_dict, man_check_ini_dict)
    if no_check_ini_on_array_err_msg:
        no_check_msg_list.append(no_check_ini_on_array_err_msg)
    return man_check_ini_dict


def get_no_check_msg(all_ini_list, added_host_ini_dict, man_check_ini_dict):
    """
    获取未检查的信息
    :param all_ini_list: 所有主机
    :param added_host_ini_dict: 已添加主机信息
    :param man_check_ini_dict: 未添加的人工确认主机信息
    :return:
    """
    # 如果未在已添加和未添加的启动器中找到对应的启动器，则报未完成检查。
    # 包含IB启动器，已和维护SE对齐，现网几乎没有，如果出现可以报手动检查
    no_check_ini_on_array_err_msg = ""
    tmp_no_check_dict = {}
    for ini_info in all_ini_list:
        wwn = ini_info.get("WWN")
        if wwn not in added_host_ini_dict and \
                wwn not in man_check_ini_dict:
            host_id = ini_info.get("Host ID")
            tmp_list = tmp_no_check_dict.get(host_id, [])
            tmp_list.append(wwn)

    if tmp_no_check_dict:
        title_key = "third.paty.multipath.hyper.config.not.checked.ini"
        no_check_ini_title = common.getMsg(LANG, title_key)
        tmp_list = []
        for host_id in tmp_list:
            tmp_list.append("%s: %s" % (
                host_id, ",".join(tmp_no_check_dict.get(host_id))))

        no_check_ini_on_array_err_msg = no_check_ini_title + "\n".join(
            tmp_list)
    return no_check_ini_on_array_err_msg


def get_path_classification(added_host_ini_dict, man_check_ini_dict):
    """
    提取出自研、自带、未确认多路径信息
    :param added_host_ini_dict: 已添加主机信息
    :param man_check_ini_dict: 未添加的人工确认主机信息
    :return:
    """
    # 分别记录自研多路径启动器信息
    hw_list = []
    # 自带的多路径启动器信息
    other_list = []
    # 未确认的多路径启动器信息
    ignore_list = []
    if added_host_ini_dict:
        a_list, b_list, c_list = get_multi_path_type_on_host(
            added_host_ini_dict)
        hw_list.extend(a_list)
        other_list.extend(b_list)
        ignore_list.extend(c_list)

    if man_check_ini_dict:
        a_list, b_list, c_list = get_multi_path_type_on_host(
            man_check_ini_dict)
        hw_list.extend(a_list)
        other_list.extend(b_list)
        ignore_list.extend(c_list)

    LOGGER.logInfo("hw_list: %s, other_list:%s, ignore_list:%s" % (
        hw_list, other_list, ignore_list))

    return hw_list, other_list, ignore_list


def get_multi_path_type_on_host(ini_dict):
    """
    区分使用了第三方多路径、自研多路径、未确认的。
    :param ini_dict:
    :return:
    """
    utral_path_ini_list = []
    third_party_ini_list = []
    manual_ignore_ini_list = []
    for ini in ini_dict:
        tmp_dict = ini_dict.get(ini, {})
        use_utral_path_value = str(tmp_dict.get("isUseUtrapath", "0"))
        if use_utral_path_value == CHECKED_TRUE_VALUE:
            utral_path_ini_list.append(ini)
        elif use_utral_path_value == CHECKED_FALSE_VALUE:
            third_party_ini_list.append(ini)
        else:
            manual_ignore_ini_list.append(ini)

    return utral_path_ini_list, third_party_ini_list, manual_ignore_ini_list


def check_version_support_third_part(p_version, other_ini_list, all_ini_list):
    """
    检查是否在不支持第三方多路径做双活的阵列版本中。
    :param p_version: 当前版本
    :param other_ini_list: 已确认的第三方多路径启动器信息
    :param all_ini_list: 全部启动器信息
    :return: 不支持的错误信息
    """
    no_support_err_msg = ""
    if not other_ini_list:
        return no_support_err_msg

    # 方案变更，v3r5c00/c01系列都不支持
    if p_version in config.UNSUPPORT_PRODUCT_DICT or is_c_version_support(
            p_version, config.UN_SUPPORT_C_VERSION_SPECIAL_LIST):
        title_key = "third.paty.multipath.array.not.support.3rd"
        tmp_msg = common.getMsg(LANG, title_key)
        host_id_list = {}
        tmp_msg_list = []
        for ini in other_ini_list:
            array_ini = get_ini_info_by_wwn(ini, all_ini_list)
            # 过滤了在线的启动器
            if not array_ini:
                continue

            host_id = array_ini.get("Host ID", "")
            tmp_list = host_id_list.get(host_id, [])
            tmp_list.append(ini)
            host_id_list[host_id] = tmp_list

        for host_id in host_id_list:
            tmp_msg_list.append(
                "%s : %s" % (host_id, ",".join(host_id_list.get(host_id, []))))

        if not tmp_msg_list:
            return no_support_err_msg

        no_support_err_msg = tmp_msg + "\n".join(tmp_msg_list)
        return no_support_err_msg

    return no_support_err_msg


def check_operator_sys_right(added_ini, all_ini):
    """
    检查物理主机和阵列配置的主机类型是否一致
    由于巡检工具添加的主机只有7中类型，而DM有很多种类型，所以有一个映射表
    :param added_ini: 已添加巡检的主机
    :param all_ini: 阵列上所有双活主机的在线的启动器。
    :return: 不通过和未完成检查错误消息
    """
    not_checked_ini = {}
    err_check_ini = {}

    # 检查已添加的主机类型是否和阵列映射的一致。
    for ini in added_ini:
        real_host_type = added_ini.get(ini, {}).get("hostType")
        array_ini = get_ini_info_by_wwn(ini, all_ini)

        if not array_ini:
            # 可能是过滤在线启动器过滤没了。
            continue

        config_type = array_ini.get("hostType")
        host_id = array_ini.get("Host ID")
        if not common_cache.get_lower_obj_in_lower_list(
                config_type, config.ARRAY_HOST_MAPPED_REAL_HOST):
            # 如果阵列配置的主机类型不在映射表中，无法检查。
            tmp_ini_list = not_checked_ini.get(host_id, [])
            tmp_ini_list.append(ini)
            not_checked_ini[host_id] = tmp_ini_list
            continue

        expect_key = common_cache.get_lower_obj_in_lower_list(
            config_type, config.ARRAY_HOST_MAPPED_REAL_HOST)
        expected_type = config.ARRAY_HOST_MAPPED_REAL_HOST.get(expect_key)
        expected_list = expected_type.split(",")
        if real_host_type not in expected_list:
            tmp_list = err_check_ini.get(host_id, [])
            tmp_list.append(ini)
            err_check_ini[host_id] = tmp_list
    return get_check_result_msg(not_checked_ini, err_check_ini)


def get_man_check_result(not_added_ini, all_ini):
    """
    获取人工确认结果
    :param not_added_ini: 未添加巡检的主机
    :param all_ini: 阵列上所有双活主机的在线的启动器
    :return: 人工检查结果
    """
    not_checked_ini = {}
    err_check_ini = {}
    # 检查未添加巡检的主机人工确认结果。
    for ini in not_added_ini:
        array_ini = get_ini_info_by_wwn(ini, all_ini)
        # 过滤了在线的启动器
        if not array_ini:
            continue

        host_id = array_ini.get("Host ID")
        # 人工忽略了结果
        tmp_dict = not_added_ini.get(ini, {})
        host_type_check_ret = tmp_dict.get("hostTypeCheckRet")
        if host_type_check_ret == NO_CHECKED_VALUE:
            tmp_ini_list = not_checked_ini.get(host_id, [])
            tmp_ini_list.append(ini)
            not_checked_ini[host_id] = tmp_ini_list
            continue

        if host_type_check_ret == CHECKED_FALSE_VALUE:
            tmp_list = err_check_ini.get(host_id, [])
            tmp_list.append(ini)
            err_check_ini[host_id] = tmp_list
    return get_check_result_msg(not_checked_ini, err_check_ini)


def get_check_result_msg(not_checked_ini, err_check_ini):
    """
    组装检查结果信息
    :param not_checked_ini: 未检查主机
    :param err_check_ini: 检查未通过主机
    :return: 检查结果信息
    """
    no_check_err_msg = ''
    tmp_no_check_msg = []
    for host_id in not_checked_ini:
        tmp_no_check_msg.append(
            "%s: %s" % (host_id, ",".join(not_checked_ini.get(host_id))))
    if tmp_no_check_msg:
        title_key = 'third.paty.multipath.array.host.type.error'
        no_check_title = common.getMsg(LANG, title_key)
        no_check_err_msg = no_check_title + "\n".join(tmp_no_check_msg)

    not_pass_err_msg = ''
    tmp_error_msg = []
    for host_id in err_check_ini:
        tmp_error_msg.append(
            "%s: %s" % (host_id, ",".join(err_check_ini.get(host_id))))

    if tmp_error_msg:
        err_key = "third.paty.multipath.array.host.type.man.error"
        not_pass_title = common.getMsg(LANG, err_key)
        not_pass_err_msg = not_pass_title + "\n".join(tmp_error_msg)

    return not_pass_err_msg, no_check_err_msg


def get_ini_info_by_wwn(wwn, all_ini):
    """
    工具方法
    :param wwn: 启动器wwn
    :param all_ini: 在线的所有启动器
    :return: 和wwn匹配的启动器对象
    """
    for tmp_ini in all_ini:
        if tmp_ini.get("WWN") == wwn:
            return tmp_ini

    return {}


def check_config_right(p_ver, hw_list, other_list, all_ini_list):
    """
    整体判断内容来源于已添加的主机和未添加主机的人工确认信息:
    自研多路径
    1. 判断启动器是否是default

    自带多路径
    1. 判断阵列版本是否不支持第三方多路径做双活
    2. 判断主机操作系统是否支持第三方多路径做双活，过滤掉不支持的。
    3. 支持做双活的继续判断不为default。
    :param p_ver: 阵列版本信息
    :param hw_list: 自研多路径
    :param other_list: 自带多路径
    :param all_ini_list: 双活主机的在线启动器列表
    :return: 错误信息
    """
    # 自研多路径 判断default
    err_msg_hw = check_hw_config(hw_list, all_ini_list)

    # 5. 如果主机使用了第三方多路径，且软件版本在不支持第三方多路
    # 径做双活的列表中，则检查不通过，否则继续检查；
    no_support_oper_error_msg = check_version_support_third_part(p_ver,
                                                                 other_list,
                                                                 all_ini_list)

    # 如果阵列版本不支持第三方多路径双活则检查不通过
    if no_support_oper_error_msg:
        return err_msg_hw + no_support_oper_error_msg

    # 自带多路径
    # 1. 已确认的自带多路径，判断操作系统是否支持。
    no_support_list, support_list = check_host_type_support_third_party(
        p_ver, other_list, all_ini_list)
    no_support_error_msg = ''
    if no_support_list:
        msg_list = get_error_msg_by_ini(no_support_list, all_ini_list)
        t_key = "third.paty.multipath.array.no.support.3rd.host.oper"
        title_str = common.getMsg(LANG, t_key)
        no_support_error_msg = title_str + "\n".join(msg_list)

    # 判断不为default，只判断支持第三方多路径做双活的配置是否正确
    err_msg_third = check_third_config(support_list, all_ini_list)

    LOGGER.logInfo("err_msg_hw:%s" % err_msg_hw)
    LOGGER.logInfo("no_support_list:%s" % no_support_list)
    LOGGER.logInfo("support_list:%s" % support_list)
    LOGGER.logInfo("err_msg_third:%s" % err_msg_third)

    return err_msg_hw + no_support_error_msg + err_msg_third


def check_hw_config(hw_ini, all_ini_list):
    """
    自研多路径
    判断启动器是否是default
    :param hw_ini:
    :param all_ini_list:
    :return:
    """
    error_msg = ""
    err_host_dict = {}
    for ini in hw_ini:
        tmp_ini = get_ini_info_by_wwn(ini, all_ini_list)
        # 启动器不在线过滤掉。
        if not tmp_ini:
            continue

        multi_path_type = tmp_ini.get("Multipath Type", '')
        host_id = tmp_ini.get("Host ID", '')

        if multi_path_type != "Default":
            ini_list = err_host_dict.get(host_id, [])
            ini_list.append(ini)
            err_host_dict[host_id] = ini_list

    tmp_msg_list = []
    for host_id in err_host_dict:
        tmp_msg_list.append(
            "%s: %s" % (host_id, ",".join(err_host_dict.get(host_id, []))))

    if tmp_msg_list:
        err_key = "third.paty.multipath.array.hw.cfg.error"
        err_msg = common.getMsg(LANG, err_key)
        error_msg = err_msg + "\n".join(tmp_msg_list)

    return error_msg


def check_third_config(other_ini, all_ini_list):
    error_msg = ""
    err_host_dict = {}
    for ini in other_ini:
        tmp_ini = get_ini_info_by_wwn(ini, all_ini_list)
        # 启动器不在线过滤掉。
        if not tmp_ini:
            continue

        multi_path_type = tmp_ini.get("Multipath Type", '')
        host_id = tmp_ini.get("Host ID", '')

        if multi_path_type == "Default":
            ini_list = err_host_dict.get(host_id, [])
            ini_list.append(ini)
            err_host_dict[host_id] = ini_list

    tmp_msg_list = []
    for host_id in err_host_dict:
        tmp_msg_list.append(
            "%s: %s" % (host_id, ",".join(err_host_dict.get(host_id, []))))

    if tmp_msg_list:
        err_key = "third.paty.multipath.array.3rd.cfg.error"
        err_msg = common.getMsg(LANG, err_key)
        error_msg = err_msg + "\n".join(tmp_msg_list)

    return error_msg


def has_hyper_metro_pair(cli, all_ret_list):
    """
    check whether the storage has hyper_metro pair
    :param cli:连接
    :param all_ret_list: 全部CLI回文信息列表
    :return: True 带双活，False 不带双活
    """
    cmd = "show hyper_metro_pair general"
    flag, cli_ret, err_msg = execute_cmd_in_cli_mode_with_cache(
        PY_JAVA_ENV, cli, cmd, LOGGER)
    all_ret_list.append(cli_ret)

    if flag is not True:
        if cliUtil.isNoneLicense(cli_ret):
            return False
        raise UnCheckException(err_msg, cli_ret, flag)

    if cliUtil.queryResultWithNoRecord(cli_ret):
        return False

    ret_list = cliUtil.getHorizontalCliRet(cli_ret)
    if ret_list:
        return True


def get_all_hyper_host(cli, host_id_list):
    """
    获取所有主机下的LUN信息，用于检查是否带双活
    :param cli:连接
    :param host_id_list:主机ID
    :return:主机和主机下的LUN列表
    """
    host_cli_ret_list = []
    hyper_host_list = []

    total_p = 80.0
    cur_p = 4
    part_host_p = total_p / len(host_id_list)
    for host_id in host_id_list:
        cli_ret, host_lun_list = cli_util_cache.get_host_lun_cache(PY_JAVA_ENV,
                                                                   cli,
                                                                   LOGGER,
                                                                   host_id)
        host_cli_ret_list.append(cli_ret)

        has_hyper = False
        if not host_lun_list:
            cur_p += part_host_p
            common.refreshProcess(PY_JAVA_ENV, cur_p, LOGGER)
            continue

        for lun_info in host_lun_list:
            lun_id = lun_info.get("LUN ID")
            ret_dict_list, cli_ret = cli_util_cache.get_lun_detail_cache(
                PY_JAVA_ENV, cli, LOGGER, lun_id)
            host_cli_ret_list.append(cli_ret)
            common.refreshProcess(PY_JAVA_ENV, cur_p, LOGGER)
            for lun_info in ret_dict_list:
                hyper_str = lun_info.get("HyperMetro ID(s)", "--")
                if hyper_str != "--" and hyper_str != "" and hyper_str != "[]":
                    has_hyper = True
                    break

            # 如果任一一个LUN带双活，则判断为双活主机
            if has_hyper:
                hyper_host_list.append(host_id)
                break

        cur_p += part_host_p
        common.refreshProcess(PY_JAVA_ENV, cur_p, LOGGER)
    return hyper_host_list, host_cli_ret_list


def get_ini_info_on_real_host():
    """
    获取物理主机信息和人工确认结果
    :return:
    """
    context = PY_JAVA_ENV.get("objectForPy")
    # 已添加的主机自动确认结果
    added_host_dict = context.get("hostUseUtralPathInitiatorDict")
    LOGGER.logInfo("added host info dict:%s" % (str(added_host_dict)))
    if not added_host_dict:
        added_host_dict = {}
    # 人工确认结果
    man_check_dict = get_manual_check_result(context)
    LOGGER.logInfo("manually checked:%s" % (str(man_check_dict)))
    return added_host_dict, man_check_dict


def get_hyper_initiator_list(hyper_host_id, ini_info_list, host_list):
    """
    获取双活主机在线的启动器信息
    :param hyper_host_id:
    :param ini_info_list:
    :return: 双活主机的启动器列表
    """
    hyper_ini_list = []
    for ini in ini_info_list:
        if ini.get("Host ID", '--') not in hyper_host_id:
            continue

        if ini.get("Running Status", "").lower() != "online":
            continue

        # 更新启动器所在主机类型信息
        for host_dict in host_list:
            if ini.get("Host ID") == host_dict.get("ID"):
                ini["hostType"] = host_dict.get("Operating System")
                # 判断时只取wwn判断，ISCSI启动器的赋值一个WWN
                ini["WWN"] = ini.get("WWN", ini.get("iSCSI IQN"))
        hyper_ini_list.append(ini)

    return hyper_ini_list


def get_ini_info_on_array(cli, all_ret_list):
    """
    @summary: 获取阵列上启动器、主机类型、配置信息
    @return: 启动器信息
    """
    online_ini_list = []

    # 获取全部主机
    cli_ret, host_list = get_all_host(cli)
    common.refreshProcess(PY_JAVA_ENV, 4, LOGGER)
    all_ret_list.append(cli_ret)
    # 如果没有主机。
    if not host_list:
        return online_ini_list

    # 取出全部主机ID
    host_id_list = [host_dict.get("ID") for host_dict in host_list]

    # 获取所有主机下的lun
    hyper_host_list, host_cli_ret_list = get_all_hyper_host(cli, host_id_list)
    all_ret_list.extend(host_cli_ret_list)
    if not hyper_host_list:
        return online_ini_list

    # 获取所有IB信息
    ret_list, ib_list = cli_util_cache.get_ib_initiator_for_all_host_cache(
        PY_JAVA_ENV, cli,
        LOGGER,
        hyper_host_list)
    all_ret_list.extend(ret_list)
    common.refreshProcess(PY_JAVA_ENV, 90, LOGGER)
    # 过滤在线IB启动器
    online_ib_list = filter_online_ib_ini(ib_list, host_list)
    online_ini_list.extend(online_ib_list)

    # 获取全部fc和iscsi启动器信息
    cli_ret, fc_list, iscsi_list = cli_util_cache.get_fc_iscsi_initiator_cache(
        PY_JAVA_ENV,
        cli, LOGGER)
    all_ret_list.append(cli_ret)
    common.refreshProcess(PY_JAVA_ENV, 95, LOGGER)

    # 获取在线的双活主机FC启动器
    online_fc_list = get_hyper_initiator_list(hyper_host_list, fc_list,
                                              host_list)
    online_ini_list.extend(online_fc_list)

    # 获取在线的双活主机ISCSI启动器
    online_iscsi_list = get_hyper_initiator_list(hyper_host_list, iscsi_list,
                                                 host_list)
    online_ini_list.extend(online_iscsi_list)

    return online_ini_list


def filter_online_ib_ini(ib_list, host_list):
    """
    过滤在线的IB启动器
    :param ib_list:
    :param host_list:
    :return: 在线IB启动器列表
    """
    online_ini_list = []
    # 过滤在线启动器
    for ib_ini in ib_list:
        # 获取在线的启动器
        if ib_ini.get("Running Status", "").lower() != "online":
            continue

        # ib启动器字段不一致，配置为一致，统一判断
        ib_ini["Multipath Type"] = ib_ini.get("Multi Path Type")

        # 更新启动器所在主机类型信息
        for host_dict in host_list:
            if ib_ini.get("Host ID") == host_dict.get("ID"):
                ib_ini["hostType"] = host_dict.get("Operating System")
        online_ini_list.append(ib_ini)

    return online_ini_list


def get_manual_check_result(context):
    """
    context:存放未添加主机的人工确认项。
    :return:
        manual_check_dict 人工确认的使用utralpath的主机启动器。
    """
    man_check_dict = {}
    try:
        host_info_mem = context.get("HYPER_QUO_SERVER_AND_NOT_ADD_HOST_INFO")
        if not host_info_mem:
            return man_check_dict

        not_add_host_list = host_info_mem.get("NOT_ADD_HOST_LIST")
        if not not_add_host_list:
            return man_check_dict

        for host_info_dict in not_add_host_list:
            sn_string = host_info_dict.get("sn", "")

            # 由于是全局变量，需判断是否是当前设备的逻辑主机。由于信息有合并，判断只能包含。
            if str(PY_JAVA_ENV.get(
                    "devInfo").getDeviceSerialNumber()) not in sn_string:
                continue

            # 经过手动确认的使用华为多路径的主机启动器。
            use_utral_path = host_info_dict.get("isUseUtrapath", 0)
            host_check = host_info_dict.get("hostTypeCheckRet", 0)
            initiator_string = host_info_dict.get("initiator", "")
            initiator_list = initiator_string.split(",")
            for ini in initiator_list:
                man_check_dict[ini] = {"isUseUtrapath": str(use_utral_path),
                                       "hostTypeCheckRet": str(host_check)
                                       }
        return man_check_dict
    except Exception as e:
        LOGGER.logError(str(e))
        return man_check_dict


def is_c_version_support(p_version, target_list):
    """
    判断相同V系列版本时C版本是否支持。
    """
    c_version = p_version[0:len(C_VERSION)]
    return True if c_version in target_list else False


def check_host_type_support_third_party(current_version, third_list,
                                        all_ini_list):
    """
    @summary: 检查主机操作系统是否版本支持，返回支持的hostId和不支持hostId。
    @return: supportHostList, unsupportHostList
    """
    global ALL_CLI_RET
    not_support_ini_list = []
    support_ini_list = []

    host_type_list = []
    # 版本大于V3R6C00SPC100，全量支持
    if current_version >= config.PUBLIC_SUPPORT_3RD_PART_VERSION:
        host_type_list = config.SUPPORT_HOST_OPERATOR_DICT.get(
            config.PUBLIC_SUPPORT_3RD_PART_VERSION, [])
    # 特定只支持部分主机的版本-黑名单
    elif current_version in config.SUPPORT_HOST_OPERATOR_DICT:
        host_type_list = config.SUPPORT_HOST_OPERATOR_DICT.get(
            current_version, [])
    # 不支持第三方多路径做双活的已经排除后，余下都支持。
    else:
        host_type_list = config.SUPPORT_HOST_OPERATOR_DICT.get(
            config.PUBLIC_SUPPORT_3RD_PART_VERSION, [])

    LOGGER.logInfo("host_type_list:%s. " % host_type_list)

    for ini in third_list:
        tmp_ini = get_ini_info_by_wwn(ini, all_ini_list)
        if not tmp_ini:
            continue

        host_type = tmp_ini.get("hostType", '')
        if common_cache.get_lower_obj_in_lower_list(host_type,
                                                    host_type_list):
            support_ini_list.append(ini)
        else:
            not_support_ini_list.append(ini)

    return not_support_ini_list, support_ini_list


def get_all_host(cli):
    """
    @summary: 步骤4 执行命令：show host general查询主机信息，
    获取主机ID和操作系统名称；
    @return hostIdList
        hostIdList: 事件中host的Id
    """
    global ALL_CLI_RET, NEED_PROCESS
    cli_ret, info_dict_list = cli_util_cache.get_host_cache(PY_JAVA_ENV, cli,
                                                            LOGGER)
    return cli_ret, info_dict_list


def get_error_msg_by_ini(ini_list, all_ini_dict):
    """
    抽象的公共方法，根据ini list,组装错误消息列表
    :param ini_list: 配置错误的ini list
    :param all_ini_dict: 全量启动器信息
    :return: 错误消息列表
    """
    tmp_dict = {}
    msg_list = []
    for ini in ini_list:
        ini_info = get_ini_info_by_wwn(ini, all_ini_dict)
        if not ini_info:
            continue
        host_id = ini_info.get("Host ID")
        tmp_list = tmp_dict.get(host_id, [])
        tmp_list.append(ini)
        tmp_dict[host_id] = tmp_list

    for host_id in tmp_dict:
        msg_list.append("%s: %s" % (
            host_id, ",".join(tmp_dict.get(host_id, []))))

    return msg_list
