#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2019-2019. All rights reserved.
#

"""
@version: Toolkit V200R006C00
@time 2019/11/07
@file check_item_software_Infrastructure_check.py
@function:
@modify
"""

from com.huawei.ism.tool.obase.exception import ToolException

import cliUtil
import common
import config_1 as config
from frameone.util import common as frameCommon

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
PY_JAVA_ENV = py_java_env


RECORD = []

NO_ODX_RISK = True


@frameCommon.fakeProgress(PY_JAVA_ENV, totalSeconds=30, logger=LOGGER,
                          interval=1)
def execute(cli):
    '''
    系统资源误用检查：
        型号版本在指定范围且补丁版本定于指定版本且有ODX使用记录则认为不通过
    :param cli:连接
    :return:flag,record,err_msg
    '''
    global RECORD, NO_ODX_RISK
    try:
        product_model = str(PY_JAVA_ENV.get("devInfo").getDeviceType())

        cmd = "show system general"
        flag, ret, err_msg = cliUtil.excuteCmdInCliMode(cli, cmd, False, LANG)
        if flag is not True:
            return flag, ret, err_msg
        RECORD.append(ret)

        flag, product_version, patch_version, ret, err_msg = common. \
            getProductVersionAndHotPatchVersion(cli, LOGGER, LANG)
        RECORD.append(ret)

        if flag is not True:
            return cliUtil.RESULT_NOCHECK, '\n'.join(RECORD), err_msg

        return risk_check(cli, product_model, product_version, patch_version)
    except common.UnCheckException as uncheck:
        LOGGER.logError("Failed to check :%s" % str(uncheck.errorMsg))
        return cliUtil.RESULT_NOCHECK, "\n".join(RECORD), uncheck.errorMsg

    except (ToolException, Exception) as e:
        LOGGER.logException(e)
        return (cliUtil.RESULT_NOCHECK, '\n'.join(RECORD), common.getMsg(
            LANG, "query.result.abnormal"))
    finally:
        # 退出到cli模式
        ret = cliUtil.enterCliModeFromSomeModel(cli, LANG)
        LOGGER.logInfo("enter cli mode from some model %s" % str(ret))

        # 退出失败后为不影响后续检查项重新连接cli
        if not ret[0]:
            common.reConnectionCli(cli, LOGGER)

def risk_check(cli, product_model, product_version, patch_version):
    """
    风险版本且补丁定于指定补丁则轮训控制器查询ODX记录
    :param cli:
    :param product_model:
    :param product_version:
    :param patch_version:
    :return:
    """
    risk_dict = {}
    if common.isDorado(product_model):
        risk_dict = config.INF_RISK_VERSION_PATCH_DORADO
    else:
        risk_dict = config.INF_RISK_VERSION_PATCH

    base_patch = risk_dict.get(product_version, False)
    if base_patch and (patch_version < base_patch):
        conn = None
        try:
            flag, conn, err_msg = common.\
                createDeviceCliContFor18000(cli, PY_JAVA_ENV, LOGGER, LANG)
            if not flag:
                return cliUtil.RESULT_NOCHECK, '\n'.join(RECORD), err_msg
            check_odx_risk(conn, PY_JAVA_ENV, LOGGER, LANG, '')
            LOGGER.logInfo("has odx risk : %s" % str(NO_ODX_RISK))
            if not NO_ODX_RISK:
                err_msg = common.getMsg(LANG, "infrastructure.check.risk",
                                        (patch_version, base_patch))
            return NO_ODX_RISK, '\n'.join(RECORD), err_msg
        finally:
            if conn and conn is not cli and common.is18000(PY_JAVA_ENV, conn):
                common.closeDeviceCliContFor18000(conn, PY_JAVA_ENV,
                                                  LOGGER, LANG)
            ret = cliUtil.enterCliModeFromSomeModel(cli, LANG)
            LOGGER.logInfo(
                    "enter cli mode from some model ret is %s" % str(ret))

            if not ret[0]:
                common.reConnectionCli(cli, LOGGER)
    else:
        return True, '\n'.join(RECORD), ''


@common.checkAllEngineInClusterWarp
def check_odx_risk(cli, py_java_env, logger, lang, heart_beat_cli_ret):
    '''
    单控制器内检查项，执行odx showrec命令，
    若回文表格有记录则终止检查，否则继续检查其他控制器
    :param cli:
    :param py_java_env:
    :param logger:
    :param lang:
    :param heart_beat_cli_ret:
    :return:继续/终止
    '''
    global NO_ODX_RISK, RECORD
    RECORD.append(heart_beat_cli_ret)
    cmd = "odx showrec"
    flag, ret, err_msg = cliUtil.excuteCmdInDebugModel(cli, cmd, lang)
    RECORD.append(ret)

    if flag is not True:
        raise common.UnCheckException(err_msg, "")

    rec_list = cliUtil.getHorizontalCliRet(ret)
    if len(rec_list) == 0:
        LOGGER.logInfo(
            "Current control can not find odx record,continue check.")
        return common.CHECK_FLAG_CONTINUE
    else:
        NO_ODX_RISK = False
        LOGGER.logInfo("Current control find odx record.")
        return common.CHECK_FLAG_NOT_CONTINUE
