# -*- coding: UTF-8 -*-
import cliUtil
import common
import traceback
import config
from common import UnCheckException
from common import AsynProgress

PY_JAVA_ENV = py_java_env
LANG = common.getLang(PY_JAVA_ENV)
LOGGER = common.getLogger(PY_LOGGER, __file__)
ALL_CLI_RET = ''

# 保险箱盘槽位号
COFFER_DISK_SLOT = ["0", "1", "2"]

EIGHT_BIT_LEN = len("00 fe c0 00 00 00 00 00")

slotAndKeyMap = {
    '0': config.DISK_ARB_RESERVED_KEY_SLOT_0,
    '1': config.DISK_ARB_RESERVED_KEY_SLOT_1,
    '2': config.DISK_ARB_RESERVED_KEY_SLOT_2
}
NOT_CHECK_DISK_TYPE_LIST = ["SATA", "NVMe SSD"]
failedDiskList = []
currentContrIp = PY_JAVA_ENV.get("devInfo").getIp()

def execute(cli):
    """
硬盘仲裁预留key值检查
步骤1 以admin用户登录设备；
步骤2 执行命令show disk general |filterColumn include columnList=ID,Type,Health\sStatus,Running\sStatus,Coffer\sDisk查询保险箱前3盘用户ID；
步骤3 进入developer模式并进入debug；
步骤4 执行命令sddebug show disk查询保险箱前3盘用户ID对应的块设备BlkDev；
步骤5 进入minisystem模式；
步骤6 根据步骤3中查询到的块设备BlkDev（xxx）执行命令：disktool -f X -c 5e000000000000010800000000000000 -i 0x18 /dev/xxx查询盘上仲裁预留key值；
步骤7 心跳到其他引擎的任意一个控制器，执行步骤3至步骤6。

1.步骤2中如果查询到的盘Type为SATA盘，则检查通过，否则执行后面的检查；
2.步骤2中命令字段中Coffer Disk为Yes表示为保险箱盘，保险箱盘用户ID小数点后的数字表示槽位号，其中0,1,2表示前3槽位盘；
3.根据步骤2查询到的保险箱盘到步骤4中执行命令中匹配对应的保险箱盘前3盘块设备BlkDev；
4.步骤6根据步骤4匹配到的盘查询盘上预留key值(第二个八字节与第三个八字节)，各引擎下任意一控即可，与下面的key值匹配，如果能匹配上一个，则通过。
5.除了检查标准中key值不匹配外的任何异常，提示联系技术工程师处理。
    """
    global ALL_CLI_RET, failedDiskList
    notPassDiskList = []
    myPthread = AsynProgress(PY_JAVA_ENV, LOGGER)
    myPthread.start_thread()
    try:
        productModel = str(py_java_env.get("devInfo").getDeviceType())
        productVersion = str(py_java_env.get("devInfo").getProductVersion())
        LOGGER.logInfo("productModel is: %s, productVersion:%s" % (productModel, productVersion))
        
        # 查询硬盘信息
        diskInfoDict = getDiskInfo(cli)
        LOGGER.logInfo("diskInfoDict is: %s" % diskInfoDict)
        
        if not diskInfoDict:
            return True, ALL_CLI_RET, ''
        
        # 获取控制器IP和引擎信息
        _, _, ipListDict, engineList = getContrIpListOfEngine(cli, LANG)
        LOGGER.logInfo("ipListDict is: %s, engineList:%s" % (ipListDict, engineList))

        # 单引擎场景，不用心跳直接检查。
        if len(engineList) == 1:
            # 18000建管理网线的SSH连接
            if common.is18000(PY_JAVA_ENV, cli):
                LOGGER.logInfo("18000 start get conn by ipv4 ip.")
                flag, errMsg, connCli, connIp = common.getConnectionByContrIpWithConnIp(PY_JAVA_ENV, cli, ipListDict, engineList[0],
                                                                      LOGGER, LANG)
                LOGGER.logInfo(u"18000 start get conn by ipv4 ip errMsg:%s" % errMsg)
                if flag != True:
                    raise UnCheckException(errMsg, ALL_CLI_RET)

                LOGGER.logInfo("18000 get conn by ipv4 ip success.")
                try:
                    notPassDiskList.extend(checkCurrentEngineDiskInfo(connCli, diskInfoDict))
                except UnCheckException, unCheckException:
                    raise UnCheckException(unCheckException.errorMsg, ALL_CLI_RET)
                finally:
                    if currentContrIp != connIp:
                        common.closeSSH(connCli)
            else:
                notPassDiskList.extend(checkCurrentEngineDiskInfo(cli, diskInfoDict))

            if notPassDiskList:
                return False, ALL_CLI_RET, ",".join(notPassDiskList)

            if failedDiskList:
                return cliUtil.RESULT_NOCHECK, ALL_CLI_RET, common.getMsg(LANG,
                                                                          "software.arb.reserved.key.value.queryFailed.withDiskId",
                                                                          ",".join(failedDiskList))

            return True, ALL_CLI_RET, ''

        # 多引擎场景:
        # 不支持跨引擎心跳的场景
        if not common.isSupportEngineToEngineHeartBeat(productVersion, productModel):
            LOGGER.logInfo("Get into branch : Not support engine to engine heartbeat!")
            if common.is18000(PY_JAVA_ENV, cli):
                for engine in ipListDict:
                    flag, errMsg, connCli, connIp = common.getConnectionByContrIpWithConnIp(PY_JAVA_ENV, cli, ipListDict, engine, LOGGER,
                                                                          LANG)
                    if flag != True:
                        raise UnCheckException(errMsg, ALL_CLI_RET)
                    try:
                        notPassDiskList.extend(checkCurrentEngineDiskInfo(connCli, diskInfoDict))
                    except UnCheckException, unCheckException:
                        raise UnCheckException(unCheckException.errorMsg, ALL_CLI_RET)
                    finally:
                        if currentContrIp != connIp:
                            common.closeSSH(connCli)
                            LOGGER.logInfo("18000 close ssh conn success!")
            else:
                # 先使用当前连接检查当前引擎
                notPassDiskList.extend(checkCurrentEngineDiskInfo(cli, diskInfoDict))

                # 从ipListDict中去掉已检查的当前引擎。
                engineId = getCurrentEngine(ipListDict)
                ipListDict.pop(engineId)
                engineList.remove(engineId)
                # 其他引擎建立管理网线SSH连接。
                for engineId in engineList:
                    flag, errMsg, connCli = common.getConnectionByContrIp(PY_JAVA_ENV, cli, ipListDict, engineId,
                                                                          LOGGER,
                                                                          LANG)
                    if flag != True:
                        raise UnCheckException(errMsg, ALL_CLI_RET)
                    try:
                        notPassDiskList.extend(checkCurrentEngineDiskInfo(connCli, diskInfoDict))
                    except UnCheckException, unCheckException:
                        raise UnCheckException(unCheckException.errorMsg, ALL_CLI_RET)
                    finally:
                        common.closeSSH(connCli)
                        LOGGER.logInfo("lower product close ssh conn success!")

        else:
            LOGGER.logInfo("Get into branch : Support engine to engine heartbeat!")
            # 支持跨引擎心跳的场景
            if common.is18000(PY_JAVA_ENV, cli):
                LOGGER.logInfo("Get into branch : 18000 V3 Support engine to engine heartbeat!")
                # 18000 需要直接建立连接
                flag, errMsg, connCli, connIp = common.getConnectionByContrIpWithConnIp(PY_JAVA_ENV, cli, ipListDict, u"0", LOGGER, LANG)
                if flag != True:
                    raise UnCheckException(errMsg, ALL_CLI_RET)

                try:
                    # 先检查当前连接的引擎
                    notPassDiskList.extend(checkCurrentEngineDiskInfo(connCli, diskInfoDict))

                    # 获取当前连接的节点、节点配置
                    falg, errMsg, cliRet, currentNodeId, engineCtrlNodeMappingDict, currentEngine, nodeNum = common.getEngineCtrlNodeInfo(
                        connCli, LOGGER, LANG)
                    engineList.remove(currentEngine)
                    LOGGER.logInfo("18000 product checked engine:%s, result is: %s" % (currentEngine, str(notPassDiskList)))
                    for engineId in engineList:
                        closeHeartBeatTimes = 0
                        flag, cliRet, errMsg, jumpConnCli, closeHeartBeatTimes = common.enginesJump(connCli, engineId,
                                                                                                    currentEngine,
                                                                                                    currentNodeId,
                                                                                                    nodeNum,
                                                                                                    PY_JAVA_ENV, LOGGER,
                                                                                                    LANG,
                                                                                                    engineCtrlNodeMappingDict)


                        ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cliRet)
                        if flag != True:
                            raise UnCheckException(errMsg, ALL_CLI_RET)
                        try:
                            tmpResList = checkCurrentEngineDiskInfo(connCli, diskInfoDict)
                            LOGGER.logInfo("18000 checked engine:%s, result is: %s" % (
                                engineId, str(tmpResList)))
                            notPassDiskList.extend(tmpResList)
                        except UnCheckException, unCheckException:
                            raise UnCheckException(unCheckException.errorMsg, ALL_CLI_RET)
                        finally:
                            common.enginesBack(connCli, PY_JAVA_ENV, LOGGER, LANG, closeHeartBeatTimes)
                            LOGGER.logInfo("exit heart beat success.")
                except UnCheckException, unCheckException:
                    raise UnCheckException(unCheckException.errorMsg, ALL_CLI_RET)
                finally:
                    if currentContrIp != connIp:
                        common.closeSSH(connCli)
                        LOGGER.logInfo("18000 close ssh conn success!")

            else:
                LOGGER.logInfo("Get into branch : Lower product Support engine to engine heartbeat!")
                # 非18000 需先使用当前连接检查当前引擎。
                notPassDiskList.extend(checkCurrentEngineDiskInfo(cli, diskInfoDict))

                # 获取当前连接的节点、节点配置
                falg, errMsg, cliRet, currentNodeId, engineCtrlNodeMappingDict, currentEngine, nodeNum = common.getEngineCtrlNodeInfo(
                    cli, LOGGER, LANG)

                engineList.remove(currentEngine)
                LOGGER.logInfo("lower product checked engine:%s, result is: %s" % (currentEngine, str(notPassDiskList)))

                # 再检查其他引擎
                for engineId in engineList:
                    closeHeartBeatTimes = 0
                    flag, cliRet, errMsg, jumpConnCli, closeHeartBeatTimes = common.enginesJump(cli, engineId,
                                                                                                currentEngine,
                                                                                                currentNodeId, nodeNum,
                                                                                                PY_JAVA_ENV, LOGGER,
                                                                                                LANG,
                                                                                                engineCtrlNodeMappingDict)
                    ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cliRet)
                    ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cliRet)
                    if flag != True:
                        raise UnCheckException(errMsg, ALL_CLI_RET)

                    try:
                        tmpResList = checkCurrentEngineDiskInfo(cli, diskInfoDict)
                        LOGGER.logInfo("checked engine:%s, result is: %s" % (
                            engineId, str(tmpResList)))
                        notPassDiskList.extend(tmpResList)
                    except UnCheckException, unCheckException:
                        raise UnCheckException(unCheckException.errorMsg, ALL_CLI_RET)
                    finally:
                        common.enginesBack(cli, PY_JAVA_ENV, LOGGER, LANG, closeHeartBeatTimes)
                        LOGGER.logInfo("exit heart beat success.")

        if notPassDiskList:
            return False, ALL_CLI_RET, "\n".join(list(set(notPassDiskList)))

        if failedDiskList:
            return cliUtil.RESULT_NOCHECK, ALL_CLI_RET, common.getMsg(LANG,
                                                                      "software.arb.reserved.key.value.queryFailed.withDiskId",
                                                                      ",".join(failedDiskList))

        return True, ALL_CLI_RET, ""

    except UnCheckException, unCheckException:
        LOGGER.logInfo(u"UnCheckException, errMsg: %s" % unCheckException.errorMsg)
        return (cliUtil.RESULT_NOCHECK, unCheckException.cliRet, unCheckException.errorMsg)

    except:
        LOGGER.logInfo(str(traceback.format_exc()))
        return (cliUtil.RESULT_NOCHECK, ALL_CLI_RET, common.getMsg(LANG, "query.result.abnormal"))

    finally:
        myPthread.setStopFlag(True)
        # 退出到cli模式
        ret = cliUtil.enterCliModeFromSomeModel(cli, LANG)
        LOGGER.logInfo("enter cli mode from some model ret is %s" % str(ret))

        # 退出失败后为不影响后续检查项重新连接cli
        if not ret[0]:
            common.reConnectionCli(cli, LOGGER)


def getCurrentEngine(ipListDict):
    """
    获取当前引擎id
    :param ipListDict:
    :return:
    """
    currentContrIp = PY_JAVA_ENV.get("devInfo").getIp()
    for engine in ipListDict:
        if currentContrIp in ipListDict[engine]:
            return engine

    return '0'


def checkCurrentEngineDiskInfo(cli, diskInfoDict):
    """
    检查当前引擎磁盘key信息
    :param cli:
    :param diskInfoDict:
    :return:
    """
    blkDevDict = queryDiskInDebugMode(cli, diskInfoDict)
    LOGGER.logInfo("queryDiskInDebugMode blkDevDict %s" % str(blkDevDict))
    notPassDisk = queryDiskReservedKeyValue(cli, blkDevDict)
    return notPassDisk


def queryDiskReservedKeyValue(cli, blkDevDict):
    """

    :param cli:
    :param blkDevDict:
    :return:
    """
    global ALL_CLI_RET, failedDiskList
    notPassDisk = []
    cmdStr = "disktool -f X -c 5e000000000000010800000000000000 -i 0x108 /dev/%s"
    for blkDev in blkDevDict:
        keyList = []
        cmd = cmdStr % blkDev
        diskInfoDict = blkDevDict[blkDev]
        diskSlot = diskInfoDict.get("slot")
        diskId = diskInfoDict.get("diskId")
        isInKeyList = False
        flag, cliRet, errMsg = cliUtil.excuteCmdInMinisystemModel(cli, cmd, LANG)
        ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cliRet)
        if flag != True or "send user command failed" in cliRet:
            LOGGER.logInfo(u"queryDiskReservedKeyValue, query info except:[%s], or send user command failed" % errMsg)
            continue
        
        cliRetLines = cliRet.splitlines()

        for line in cliRetLines:
            line = line.strip()
            if line.startswith("0:"):
                reservedKey = "".join(line[-EIGHT_BIT_LEN:].split())
                keyList.append(reservedKey)
                if reservedKey in slotAndKeyMap.get(diskSlot):
                    isInKeyList = True
                    continue
            
            if line.startswith("16:"):
                line = line.replace("16:", '').strip()
                reservedKey = "".join(line[0:EIGHT_BIT_LEN].split())
                keyList.append(reservedKey)
                if reservedKey in slotAndKeyMap.get(diskSlot):
                    isInKeyList = True
                    continue
            
        LOGGER.logInfo(u"queryDiskReservedKeyValue keyList: %s, isInKeyList: %s" % (str(keyList), isInKeyList))
        if not isInKeyList:
            # 当命令执行失败时，未查到key, 检查通过。send user command failed! !
            if not keyList:
                continue
            else:
                notPassDisk.append(
                    common.getMsg(LANG, "software.arb.reserved.key.value.not.pass", (diskId, ",".join(keyList))))

    return notPassDisk


def queryDiskInDebugMode(cli, diskInfoDict):
    """
    根据步骤2查询到的保险箱盘到步骤4中执行命令中匹配对应的保险箱盘前3盘块设备BlkDev；
    :param cli:
    :param diskInfoDict:
    :return:
    """
    global ALL_CLI_RET
    blkDevDict = {}
    cmd = "sddebug show disk"
    flag, cliRet, errMsg = cliUtil.excuteCmdInDebugModel(cli, cmd, LANG)
    ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cliRet)

    isStart = False
    for line in cliRet.splitlines():
        line = line.strip()
        if "BlkDev" in line and "SDID" in line:
            isStart = True
            continue

        if not isStart:
            continue

        if line.startswith("--"):
            continue

        tmpList = line.split()
        if not len(tmpList) >= 8:
            continue

        diskId = tmpList[0].strip()
        sdID = tmpList[1].strip()
        blkDev = tmpList[-1].strip()
        if int(sdID) >= 64 and diskId in diskInfoDict:
            blkDevDict[blkDev] = {"slot": diskInfoDict[diskId],
                                  "diskId": diskId
                                  }

    return blkDevDict


def getDiskInfo(cli):
    """
    步骤2中命令字段中Coffer Disk为Yes表示为保险箱盘，保险箱盘用户ID小数点后的数字表示槽位号，
    其中0,1,2表示前3槽位盘
    :param cli:
    :return:
    """
    global ALL_CLI_RET

    diskInfoDict = {}
    cmd = "show disk general |filterColumn include columnList=ID,Type,Health\sStatus,Running\sStatus,Coffer\sDisk"
    flag, cliRet, errMsg = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
    ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cliRet)
    if flag != True:
        LOGGER.logInfo(u"Failed to get disk general:%s" % errMsg)
        raise UnCheckException(errMsg, ALL_CLI_RET)
    
    diskInfoDictList = cliUtil.getHorizontalCliRet(cliRet)
    for diskInfo in diskInfoDictList:
        diskId = diskInfo.get("ID", "")
        isCofferDisk = diskInfo.get("Coffer Disk", "")
        diskType = diskInfo.get("Type", "")
        if diskType in NOT_CHECK_DISK_TYPE_LIST:
            LOGGER.logInfo(u"disk type:%s do not check." % diskType)
            continue
        
        # 查询保险箱前3盘用户ID；保险箱盘用户ID小数点后的数字表示槽位号，其中0,1,2表示前3槽位盘；
        if isCofferDisk == "Yes" and diskId and diskId.split(".")[-1] in COFFER_DISK_SLOT:
            diskInfoDict[diskId] = diskId.split(".")[-1]

    return diskInfoDict


def getContrIpListOfEngine(cli, lang):
    """
    获取引擎对应下的控制器IP
    :param cli:
    :param lang:
    :return ipListDict: 引擎和引擎下控制器的IP。
    """
    global ALL_CLI_RET

    ipListDict = {}
    engineList = []
    cmd = "show upgrade package"
    flag, cliRet, errMsg = cliUtil.excuteCmdInCliMode(cli, cmd, True, lang)
    ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cliRet)
    if flag != True:
        return (flag, errMsg, ipListDict)

    beginIndex = cliRet.find("Software Version")
    endIndex = cliRet.find("HotPatch Version")
    infoDictList = cliUtil.getHorizontalCliRet(cliRet[beginIndex: endIndex])

    for infoDict in infoDictList:
        ip = infoDict.get("IP", "")
        contrName = infoDict.get("Name", "")
        engine = contrName[:1]
        engineList.append(engine)
        if ip != "" and ip != "--" and contrName != "":
            ipList = ipListDict.get(engine, [])
            ipList.append(ip)
            ipListDict.update({engine: ipList})

    # 控制器未配置管理IP，无法连接控制器。请参考预警公告手动检查。
    if len(ipListDict) == 0:
        errMsg = common.getMsg(LANG, "contr.not.config.ip")
        return (False, errMsg, ipListDict)

    return (True, errMsg, ipListDict, list(set(engineList)))


def getEngineCtrlNodeInfo(cli):
    """
    @summary: 获取除当前节点外的引擎其他健康节点信息，当前节点信息。
    @param cli: cli连接
    @return: (currentCtrlNodeId, currentEngineCtrlIdList)
        currentNodeId: 当前节点ID
        engineCtrlNodeMappingDict: 除当前节点外的引擎其他健康节点信息
        nodeNum
    """
    global ALL_CLI_RET
    nodeNum = 2
    cmd = 'sys showcls'
    # 当前节点
    currentCtrlNodeId = None
    currentEngine = None
    engineCtrlNodeMappingDict = {}

    flag, cliRet, errMsg = cliUtil.excuteCmdInDebugModel(cli, cmd, LANG)
    ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cliRet)
    if flag != True:
        LOGGER.logInfo("get node info Failed. errMsg: %s" % errMsg)
        raise UnCheckException(common.getMsg(LANG, "chunk.check.get.controller.node.failed"), ALL_CLI_RET)

    ctrlInfoDictList = cliUtil.getVerticalCliRet(cliRet)
    engineInfoDictList = cliUtil.getHorizontalNostandardCliRet(cliRet)

    for ctrlInfo in ctrlInfoDictList:
        if ctrlInfo.get("local node id", "") != "":
            currentCtrlNodeId = ctrlInfo.get("local node id", "")
            break

    for engineInfo in engineInfoDictList:
        engine = engineInfo.get("engine", "")
        if engine == "":
            continue

        status = engineInfo.get("status", "")
        if status == "" or status != "normal":
            continue

        ctrlNodeId = engineInfo.get("id", "")
        if ctrlNodeId == "":
            continue

        tmpList = engineCtrlNodeMappingDict.get(engine, [])
        tmpList.append(ctrlNodeId)
        engineCtrlNodeMappingDict[engine] = tmpList

        if ctrlNodeId == currentCtrlNodeId:
            currentEngine = engine

    for engineId in engineCtrlNodeMappingDict:
        nodeNum = max(len(engineCtrlNodeMappingDict.get(engineId, [])), nodeNum)

    # 当前引擎包含的控制器节点
    return (currentCtrlNodeId, engineCtrlNodeMappingDict, nodeNum)
