# -*- coding: UTF-8 -*-
import re
import traceback

import cliUtil
import common
from common_utils import get_err_msg

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
PY_JAVA_ENV = py_java_env


def execute(cli):
    """
    检查线缆是否满足特定规则
    :param cli:
    :return:
    """
    cable_check = CableCheck(cli, LANG, PY_JAVA_ENV, LOGGER)
    flag, msg = cable_check.execute_check()
    return flag, "\n".join(cable_check.all_ret_list), msg


class CableCheck:
    def __init__(self, cli, lang, env, logger):
        self.cli = cli
        self.lang = lang
        self.env = env
        self.logger = logger
        self.all_ret_list = []

    def execute_check(self):
        try:
            flag, ret, msg = cliUtil.enterDeveloperMode(self.cli, self.lang)
            self.all_ret_list.append(ret)
            if flag is not True:
                return flag, msg

            flag, ret, msg = cliUtil.enter_debug_mode_from_developer(
                self.cli, self.lang
            )
            self.all_ret_list.append(ret)
            if flag is not True:
                return flag, msg

            return self.cable_check()
        except common.UnCheckException as e:
            self.logger.logError(str(e))
            return cliUtil.RESULT_NOCHECK, e.errorMsg
        except Exception:
            self.logger.logError(str(traceback.format_exc()))
            return (
                cliUtil.RESULT_NOCHECK,
                common.getMsg(self.lang, "query.result.abnormal"),
            )
        finally:
            ret = cliUtil.enterCliModeFromSomeModel(self.cli, self.lang)
            self.logger.logInfo(
                "enter cli mode from some model ret is {}".format(str(ret))
            )
            # 退出失败后为不影响后续检查项重新连接cli
            if not ret[0]:
                common.reConnectionCli(self.cli, self.logger)

    def cable_check(self):
        """
        存在Err Link线缆连接错误，则检查结果为不通过，否则检查结果为通过
        :return:
        """
        cmd = "eam showcablecheck -devm"
        flag, ret, msg = cliUtil.excuteCmdInDebugModel(
            self.cli, cmd, self.lang
        )
        if "Can't Find The Diagnose Cmd." in ret:
            cmd = "eam cablecheck -devm"
            flag, ret, msg = cliUtil.excuteCmdInDebugModel(
                self.cli, cmd, self.lang
            )
        self.all_ret_list.append(ret)
        if flag is not True:
            raise common.UnCheckException(msg, ret)
        regx = re.compile(r"(?:Err Link|No Link|Frame Deep|--)\s+([A-Z0-9.]+)\s+")
        res_list = regx.findall(ret)
        if res_list:
            msg = get_err_msg(
                self.lang,
                "software.eam.check.cable.not.pass",
                ", ".join(res_list),
            )
            return False, msg
        return True, ""
