# -*- coding: UTF-8 -*-
import re

import cliUtil
import common
import common_cache

from cbb.frame.base import baseUtil

PY_JAVA_ENV = py_java_env
LANG = common.getLang(PY_JAVA_ENV)
LOGGER = common.getLogger(PY_LOGGER, __file__)

RISK_VERSION = {
    "V500R007C60SPC100": "V500R007C60SPH101",
    "V500R007C60SPC300": "V500R007C60SPH302",
}


def execute(cli):
    """
    漂移事件中IP地址检查
    software_failover_event_ip_error
    :param cli:
    :return:
    """
    all_cli_ret_list = []
    try:
        p_version, cli_ret = common_cache.get_product_version_from_system(
            PY_JAVA_ENV, cli, LOGGER
        )
        all_cli_ret_list.append(cli_ret)

        flag, ver, patch, ret, msg = common_cache.get_version_and_patch_cache(
            PY_JAVA_ENV, cli, LOGGER
        )
        all_cli_ret_list.append(ret)
        LOGGER.logInfo("version is:{}, ver is:{} patch is:{}".format(
            p_version, ver, patch))
        if flag is not True:
            return flag, "\n".join(all_cli_ret_list), msg

        if not check_risk_version(ver, patch):
            return True, "\n".join(all_cli_ret_list), ""

        ctrl_ids_list, cli_ret = common_cache.get_ctrl_ids_cache(
            PY_JAVA_ENV, cli, LOGGER
        )
        all_cli_ret_list.append(cli_ret)

        flag, cli_ret, e_msg = cliUtil.enterDeveloperMode(cli, LANG)
        all_cli_ret_list.append(cli_ret)
        if flag is not True:
            return cliUtil.RESULT_NOCHECK, "\n".join(all_cli_ret_list), e_msg

        pass_flag = is_all_ctrl_nfs_s_lock_zero(
            cli, ctrl_ids_list, all_cli_ret_list
        )
        if pass_flag:
            return pass_flag, "\n".join(all_cli_ret_list), ""

        pass_flag = check_all_logic_port_number(cli, all_cli_ret_list)
        if not pass_flag:
            err_msg = common.getMsg(LANG, "failover_event_ip_error_not_pass")
            return pass_flag, "\n".join(all_cli_ret_list), err_msg

        return True, "\n".join(all_cli_ret_list), ""
    except common.UnCheckException as e:
        return cliUtil.RESULT_NOCHECK, "\n".join(all_cli_ret_list), e.errorMsg
    except Exception as e:
        LOGGER.logException(e)
        err_msg = common.getMsg(LANG, "query.result.abnormal")
        return cliUtil.RESULT_NOCHECK, "\n".join(all_cli_ret_list), err_msg
    finally:
        flag, ret, err_msg = cliUtil.enterCliModeFromSomeModel(cli, LANG)
        LOGGER.logInfo("enter cli mode ret is : {}".format(ret))
        # 退出失败后为不影响后续检查项重新连接cli
        if not flag:
            common.reConnectionCli(cli, LOGGER)


def is_all_ctrl_nfs_s_lock_zero(cli, ctrl_ids_list, all_cli_ret_list):
    """
    检查所有控制器s_lock是否为都为0
    :param cli:
    :param ctrl_ids_list:
    :param all_cli_ret_list:
    :return: True: 都为0
              False: 存在不为0的
    """
    cmd = "show nfs nfsv3_nlm_stats controller={}"
    for ctrl_id in ctrl_ids_list:
        cmd_str = cmd.format(ctrl_id)
        flag, cli_ret, err_msg = cliUtil.excuteCmdInCliMode(
            cli, cmd_str, True, LANG
        )
        all_cli_ret_list.append(cli_ret)
        if flag is not True:
            raise common.UnCheckException(err_msg, cli_ret)

        reg = re.compile(r"s_lock:\s*(\d+)")
        reg_res = reg.findall(cli_ret)
        for s_lock in reg_res:
            if s_lock != "0":
                return False
    return True


def check_all_logic_port_number(cli, all_cli_ret_list):
    """
    若步骤6中逻辑端口的数量大于1个，则检查结果为不通过，否则检查通过
    :param cli:
    :param all_cli_ret_list:
    :return: True: 逻辑端口数量小于1
              False: 逻辑端口数量大于1
    """
    cmd = "show logical_port general"
    flag, cli_ret, err_msg = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
    all_cli_ret_list.append(cli_ret)
    if flag is not True:
        raise common.UnCheckException(err_msg, cli_ret)

    record_list = cliUtil.getHorizontalCliRet(cli_ret)
    return len(record_list) <= 1


def check_risk_version(p_version, p_patch):
    """
    检查是否是风险版本
    若系统软件版本为V500R007C60SPC300且安装V500R007C60SPH302,
    V500R007C60SPC100且安装V500R007C60SPH101
    或更高版本补丁，则检查通过
    :param p_version: 版本
    :param p_patch: 补丁
    :return: False: 非风险版本，True: 风险版本
    """
    if p_version in RISK_VERSION:
        if (
            RISK_VERSION.get(p_version)
            and p_patch >= RISK_VERSION.get(p_version)
            and not baseUtil.is_special_patch(p_patch)
        ):
            return False
        return True
    return False
