# -*- coding: UTF-8 -*-
import cliUtil
import common

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

def execute(cli):
    '''
    @summary: 若用户创建的文件系统类型不为Thin，其空间利用率将无法达到最佳。在局点开局时建议用户将创建的文件系统类型设置为Thin。
    '''
    cliRet = ""
    errMsg = ""
    
    try:
        cmd = "show file_system general|filterColumn include columnList=ID,Name,Type|filterRow column=Type predict=not predict2=equal_to value=Thin"
        checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        cliRet = checkRet[1]
        
        if checkRet[0] != True: 
            if not cliUtil.hasCliExecPrivilege(cliRet):
                return (cliUtil.RESULT_NOSUPPORT, cliRet, errMsg)
            LOGGER.logSysAbnormal()
            return checkRet
        
        if cliUtil.queryResultWithNoRecord(cliRet):
            return (True, cliRet, errMsg)
        
        infoDictList = cliUtil.getHorizontalNostandardCliRet(cliRet)
        
        if len(infoDictList) == 0:
            errMsg = common.getMsg(LANG, "query.result.abnormal")
            LOGGER.logNoPass("Cannot get information about file system.")
            return (cliUtil.RESULT_NOCHECK, cliRet, errMsg)
        
        notThinIdList = []
        for infoDict in infoDictList:
            id = infoDict.get("ID")
            notThinIdList.append(id)
        
        errMsg = common.getMsg(LANG, "file.system.type.not.Thin", ",".join(notThinIdList))  
        return (cliUtil.RESULT_WARNING, cliRet, errMsg)
        
    except Exception, exception:
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, cliRet, common.getMsg(LANG, "query.result.abnormal"))
