# -*- coding: UTF-8 -*-
import cliUtil
import common

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)


def execute(cli):
    '''
        强制回写状态检查：
                回显状态值为用户数据强制回写或所有数据强制回写则巡检不通过，巡检不通过的回显信息如下：
        State : user_data_force_writeback
        或
        State : all_data_force_writeback
        。
    '''
    flag = True
    cliRet = ""
    errMsg = ""
    errorState = ["user_data_force_writeback",
                  "all_data_force_writeback"]
    try:
        cmd = "show system force_write_back"
        LOGGER.logExecCmd(cmd)
        checkRet = cliUtil.excuteCmdInDeveloperMode(cli, cmd, True, LANG)
        if checkRet[0] is not True:
            LOGGER.logSysAbnormal()
            return checkRet

        cliRet = checkRet[1]
        if cliUtil.queryResultWithNoRecord(cliRet):
            return (True, cliRet, errMsg)
        cliRetLinesList = cliUtil.getVerticalCliRet(cliRet)
        if len(cliRetLinesList) == 0:
            errMsg = common.getMsg(LANG, "cannot.get.force.write.back")
            LOGGER.logNoPass("Cannot get information about alarm")
            return (cliUtil.RESULT_NOCHECK, cliRet, errMsg)
        for line in cliRetLinesList:
            currentState = line.get("State")
            LOGGER.logInfo("currentState is %s " % currentState)
            if currentState in errorState:
                flag = False
                errMsg = common.getMsg(LANG,
                                       "system.force.write.back.info",
                                       currentState)
                LOGGER.logNoPass("System force write back is On")
                return (flag, cliRet, errMsg)
        return (flag, cliRet, errMsg)
    except Exception as exception:
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, cliRet,
                common.getMsg(LANG, "query.result.abnormal"))
