# -*- coding: UTF-8 -*-
import cliUtil
import common

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

def execute(cli):
    '''
    SAN双活和NAS双活优先站点一致性检查
    '''
    cliRet = ""
    errMsg = ""
    try:
        cmd = "show hyper_metro_pair general"
        resultStatus, cliRet, errMsg = cliUtil.excuteCmdTimeOutInCliMode(cli, cmd, False, LANG, 3 * 60)
        if resultStatus != True:
            return resultStatus, cliRet, errMsg

        if len(cliRet.splitlines()) > 4 and "command executed successful" not in cliRet.lower():
            dictList = cliUtil.getHorizontalCliRet(cliRet)
            prefrdHMIds = []
            nonPrefedHMIds = []
            for lineDict in dictList:
                curRole = lineDict.get("Role", "")
                if curRole.lower() == "preferred":
                    prefrdHMIds.append(lineDict.get("ID"))
                if curRole.lower() == "non-preferred":
                    nonPrefedHMIds.append(lineDict.get("ID"))
            if len(prefrdHMIds) > 0 and len(nonPrefedHMIds) > 0:
                LOGGER.logError("found hyper_metro pair role not applicable for each other!")
                resultStatus = cliUtil.RESULT_WARNING
                errMsg = common.getMsg(LANG, "hypermetro.pair.preference.inconsistent",
                                        (",".join(prefrdHMIds), ",".join(nonPrefedHMIds)))
        
        return resultStatus, cliRet, errMsg
    
    except BaseException, exception:
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, cliRet, common.getMsg(LANG, "query.result.abnormal"))
