#如果热补丁版本匹配则通过# -*- coding: UTF-8 -*-
import re

import cliUtil
import common

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

def execute(cli):
    '''
    DNS服务器探测配置检查： 
    1 当系统版本为V300R003C20 , V300R003C20SPC100 , V300R003C20SPC200 ,V300R006C00 , V300R006C00SPC100 ,
     Dorado V3R1C00 之一，且热补丁版本为V300R003C20SPH001、V300R003C20SPH203 ,V300R006C00SPH102及更高版本时巡检通过，否则继续检查；
    2 如命令回显中关键字“IP Address List“后配置的DNS Server地址个数（以空格分隔）大于1个以上，则巡检不通过。
    '''
    errMsg = ""
    allCliRet = ""
    try:
        #步骤2，判断版本及补丁
        upgradeCliRet, softwareVersionList, hotPatchVersionList = common.parse_upgradePackage(cli, LANG)
        allCliRet += upgradeCliRet[1]
        #判断是否含异常场景
        if upgradeCliRet[0] != True:
            return (cliUtil.RESULT_NOCHECK, allCliRet, common.getMsg(LANG, "cannot.get.system.info"))

        #检查版本及补丁是否存在于白名单
        flag, errMsg = checkVersionInWhitel(softwareVersionList, hotPatchVersionList)
        if flag != False :
            return (flag, allCliRet, errMsg)

        #步骤3，获取回显中"IP Address List"的IP数量
        cmd = "show dns_server general"
        flag, cliRet, errMsg = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        allCliRet += cliRet
        #判断是否含异常场景
        if flag != True:
            LOGGER.logInfo('execute ger dns server cmd is error.')
            return (cliUtil.RESULT_NOCHECK, allCliRet, errMsg)

        #检查IP地址个数        
        flag, errMsg = checkDnsServerIp(cliRet)

        return (flag, allCliRet, errMsg)
    except Exception, exception:
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, allCliRet, common.getMsg(LANG, "query.result.abnormal"))

def checkVersionInWhitel(softwareVersionList, hotPatchVersionList):
    '''
    @summary: 获取所有磁盘信息集合
    @param cli: cli对象
    @param lang: 语言lang
    '''
    #系统版本及热补丁白名单    
    softAndHotpatchWhiteMap = {'V300R003C20':'V300R003C20SPH001',
                               'V300R003C20SPC100':'--',
                               'V300R003C20SPC200':'V300R003C20SPH203',
                               'V300R006C00':'--',
                               'V300R006C00SPC100':'V300R006C00SPH105',
                               'V300R001C00':'--'}

    #检查系统版本    
    flag, currentSoftVersion, errMsg = common.getCurrentVersion(softwareVersionList, LANG)
    if not flag:
        return (cliUtil.RESULT_NOCHECK, errMsg)
    #检查热补丁版本    
    flag, currentHotpatchVersion, errMsg = common.getCurrentVersion(hotPatchVersionList, LANG)
    if not flag:
        return (cliUtil.RESULT_NOCHECK, errMsg)

    #对版本型号及热补丁版本进行适配,如果系统版本不涉及则通过
    if currentSoftVersion.strip() not in softAndHotpatchWhiteMap:
        return (True, '')

    hotpatchVersion = softAndHotpatchWhiteMap.get(currentSoftVersion.strip())
    #如果热补丁版本匹配则通过
    if hotpatchVersion != '--' and currentHotpatchVersion.strip() >= hotpatchVersion:
        LOGGER.logInfo('currentHotpatchVersion is in whiteList.')
        return (True, '')

    #如果热补丁版本不匹配则继续步骤3
    return (False, '')

def checkDnsServerIp(cliRet):
    '''
    @summary: 提取出IP列表中地址数量
    @param cliRet: 收集到的信息回显
    @return: flag , errMsg
    '''
#    
    IPADD_LIST = 'IP Address List'
    ipAddressStr = ''

    dnsServerCliRet = cliUtil.getVerticalCliRet(cliRet)
    #查看是否回显未取到值
    if len(dnsServerCliRet) == 0:
        errMsg = common.getMsg(LANG, "cannot.get.dns.server.disposelist")
        LOGGER.logInfo("Cannot get dns server disposelist")
        return (cliUtil.RESULT_NOCHECK, errMsg)

    try:
        ipAddressStr = dnsServerCliRet[0].get(IPADD_LIST)
        #如果存在关键字
        if ipAddressStr is not None:
            ipList = ipAddressStr.split()
            if len(ipList) > 1:
                LOGGER.logInfo("ipList : %s" % len(ipList))
                errMsg = common.getMsg(LANG, "dns.server.disposelist.overstep", len(ipList))
                return (False, errMsg)
            else:
                return (True, '')
        else:
            #没有关键字的情况下，返回未检查        
            errMsg = common.getMsg(LANG, "cannot.get.dns.server.disposelist")
            LOGGER.logInfo("IP Address List is not being.")
            return (cliUtil.RESULT_NOCHECK, errMsg)
    except Exception, exception:
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, common.getMsg(LANG, "query.result.abnormal"))
