# -*- coding: UTF-8 -*-
import cliUtil
import common

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

def execute(cli):
    '''
    NFS推荐共享配置检查
    
    '''
    cliRet = ""
    errMsg = ""
    checkFinalFlag = True
    try:
        shereIdField = "Share ID"
        shereIdRe = r".*"
        lockTypeField = "Lock Type"
        lockTypeRe = r"^Mandatory$"
        
        cmd = "show share nfs|filterColumn include columnList=Share\sID,File\sSystem\sID,Lock\sType"
        keywodsDict = {shereIdField:shereIdRe, lockTypeField:lockTypeRe}
        checkFlag, cliRet, errMsg, actualValueDictList = common.checkKeywords(cli, cmd, LANG, keywodsDict)
        checkFinalFlag = checkFlag
        if not cliUtil.hasCliExecPrivilege(cliRet):
            return (cliUtil.RESULT_NOSUPPORT, cliRet, "")
        
        #存在关键字未匹配的场景,或无法获取的场景
        for keywordsDict in actualValueDictList:
            shereId = keywordsDict.get(shereIdField)
            lockType = keywordsDict.get(lockTypeField)
            #key不存在,则所有的nfs都没有这个字段
            if lockType == None:
                errMsg += common.getMsg(LANG, "cannot.get.nfs.shere.lock.type")
                break  
            #值未匹配上，结果为建议优化
            else:
                checkFinalFlag = cliUtil.RESULT_WARNING
                errMsg += common.getMsg(LANG, "nfs.share.lock.type", (shereId, lockType))

        if checkFinalFlag == cliUtil.RESULT_WARNING:
            return cliUtil.RESULT_WARNING, cliRet, errMsg + common.getMsg(LANG, "share.nfs.warning.sugg")

        return (checkFinalFlag, cliRet, errMsg)
    
    except Exception, exception:
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, cliRet, common.getMsg(LANG, "query.result.abnormal"))
