# -*- coding: UTF-8 -*-
import cliUtil
import common
from cbb.frame.base import baseUtil
from common_utils import is_flush_through_mode

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
PY_JAVA_ENV = py_java_env

def execute(cli):
    '''
    POOL状态检查: 
        1 如果POOL不存在表示正常；
        2 Health Status为Normal且Running Status为Online表示正常；
        3 其它情况均属于不正常状态。
    '''
    flag = True
    cliRet = ""
    errMsg = ""

    try:
        product_model = str(PY_JAVA_ENV.get("devInfo").getDeviceType())
        if baseUtil.is_micro_dev(product_model) and is_flush_through_mode(cli, LANG, LOGGER):
            return (cliUtil.RESULT_NOSUPPORT, "System mode: pass-through mode.", errMsg)
        cmd = "show storage_pool general"
        LOGGER.logExecCmd(cmd)
        checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        if checkRet[0] != True: 
            LOGGER.logSysAbnormal()
            return checkRet
        
        cliRet = checkRet[1]
        if cliUtil.queryResultWithNoRecord(cliRet):
            return (True, cliRet, errMsg)
        
        cliRetLinesList = cliUtil.getHorizontalCliRet(cliRet)
        if len(cliRetLinesList) == 0:
            errMsg = common.getMsg(LANG, "cannot.get.pool.info")
            LOGGER.logNoPass("Cannot get information about POOL")
            return (cliUtil.RESULT_NOCHECK, cliRet, errMsg)  # 修改备注：解析回显失败导致列表长度为0

        for line in cliRetLinesList:
            poolId = line.get("ID")
            healthStatus = line.get("Health Status")
            runningStatus = line.get("Running Status")
            
            if healthStatus != common.STATUS_NORMAL:
                flag = False
                errMsg += common.getMsg(LANG, "pool.health.status.abnormal", (poolId, healthStatus))
                LOGGER.logNoPass("The Health Status of POOL [%s] is abnormal (Health Status:%s)" % 
                    (poolId, healthStatus))
            
            if runningStatus != common.STATUS_ONLINE:
                flag = False
                errMsg += common.getMsg(LANG, "pool.running.status.abnormal", (poolId, runningStatus))
                LOGGER.logNoPass("The Running Status of POOL [%s] is abnormal (Running Status:%s)" % 
                    (poolId, runningStatus))
                
        if flag:
            LOGGER.logPass()
            
        return (flag, cliRet, errMsg)
        
    except Exception, exception:
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, cliRet, common.getMsg(LANG, "query.result.abnormal"))

