# -*- coding: UTF-8 -*-
# Copyright (c) Huawei Technologies Co., Ltd. 2019-2021. All rights reserved.

from cbb.business.checkitems.pool_balance_task_check \
    import PoolBalanceTaskCheck
from cbb.frame.checkitem.context_adapter import InspectContext
from cbb.frame.util.common import fakeProgress
import cliUtil
import common

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
PY_JAVA_ENV = py_java_env


@fakeProgress(PY_JAVA_ENV, totalSeconds=120, logger=LOGGER, interval=1)
def execute(cli):
    """
    检查硬盘域后台均衡任务BUGLIST202106090003
    :param cli:
    :return:
    """
    tool_context = InspectContext(PY_JAVA_ENV, cli)
    context_inspect = tool_context.get_context()
    context_inspect["logger"] = PY_LOGGER
    pool_balance_task_check = PoolBalanceTaskCheck(context_inspect)
    try:
        flag, msg = pool_balance_task_check.check_all_ctrl_task()
        LOGGER.logInfo("flag:{}, msg:{}".format(flag, msg))
        res_flag, ret, msg = \
            tool_context.get_result(flag, msg,
                                    pool_balance_task_check.get_origin_info())
        return res_flag, ret, msg
    except Exception as e:
        LOGGER.logError(str(e))
        return (
            cliUtil.RESULT_NOCHECK,
            pool_balance_task_check.get_origin_info(),
            common.getMsg(LANG, "query.result.abnormal"),
        )
