# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
import common
import cliUtil

PY_JAVA_ENV = py_java_env
LANG = common.getLang(PY_JAVA_ENV)
LOGGER = common.getLogger(PY_LOGGER, __file__)


def execute(cli):
    all_cli_ret = []
    switch_flag, switch_ret, switch_err_msg = \
        cliUtil.excuteCmdInDeveloperMode(cli, "show potential_fault switch", True, LANG)
    all_cli_ret.append(switch_ret)
    if switch_flag is not True:
        LOGGER.logSysAbnormal()
        return switch_flag, "\n".join(all_cli_ret), switch_err_msg
    dict_list = cliUtil.getHorizontalCliRet(switch_ret)
    for switch_status in dict_list:
        if switch_status.get("switch") == "off":
            return True, "\n".join(all_cli_ret), ""
    fault_infos_flag, fault_infos_ret, fault_infos_msg = \
        cliUtil.excuteCmdInDeveloperMode(cli, "show potential_fault data", True, LANG)
    all_cli_ret.append(fault_infos_ret)
    if fault_infos_flag is not True:
        LOGGER.logSysAbnormal()
        return fault_infos_flag, "\n".join(all_cli_ret), fault_infos_msg
    if cliUtil.queryResultWithNoRecord(fault_infos_ret):
        return True, "\n".join(all_cli_ret), ""
    return False, "\n".join(all_cli_ret), common.getMsg(LANG, "potential.fault.risk.abnormal")
