# -*- coding: UTF-8 -*-
import cliUtil
import common

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

def execute(cli):
    '''
    RAID配置检查: 
        1 配置的RAID级别为RAID5、RAID6、RAID-TP表示正常；
        2 其他配置表示不正常；
       
    '''
    flag = True
    cliRet = ""
    errMsg = ""

    try:
        cmd = "show storage_pool general"
        LOGGER.logExecCmd(cmd)
        checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        if checkRet[0] != True: 
            LOGGER.logSysAbnormal()
            return checkRet
        
        cliRet = checkRet[1]
        if cliUtil.queryResultWithNoRecord(cliRet):
            return (True, cliRet, errMsg)
        
        cliRetLinesList = cliUtil.getHorizontalCliRet(cliRet)
        if len(cliRetLinesList) == 0:
            errMsg = common.getMsg(LANG, "cannot.get.pool.info")
            LOGGER.logNoPass("Cannot get information about POOL")
            return (cliUtil.RESULT_NOCHECK, cliRet, errMsg)  # 修改备注：解析回显失败导致列表长度为0
        
        for line in cliRetLinesList:
            poolId = line.get("ID")
            cmd_tier = "show storage_pool general pool_id=%s" % poolId
            LOGGER.logExecCmd(cmd_tier)
            checkRet = cliUtil.excuteCmdInCliMode(cli, cmd_tier, True, LANG)
            cliRet += checkRet[1]
            
            if checkRet[0] != True: 
                errMsg += checkRet[2]
                LOGGER.logSysAbnormal()
                return (checkRet[0], cliRet, errMsg)
            
            cliRetpool = checkRet[1]
            tierList = cliUtil.getVerticalCliRet(cliRetpool)
            if len(tierList) == 0:
                flag = False
                errMsg += common.getMsg(LANG, "cannot.get.tier.info")
                LOGGER.logNoPass("Cannot get information about Tier")
            
            for retDict in tierList:
                poolName = retDict.get("Name")
                raidLevel = retDict.get("Raid Level")
                
                if not raidLevel in ["RAID5", "RAID6", "RAID-TP"]:
                    flag = False
                    errMsg += common.getMsg(LANG,"raid.level.improperly.config", (poolId, poolName, raidLevel))
                    LOGGER.logNoPass("The RAID level is improperly configured (RAID Level:%s) in POOL [%s]" % 
                         (raidLevel, poolId))

        if flag:
            LOGGER.logPass()
               
        return (flag, cliRet, errMsg)
        
    except Exception, exception:
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, cliRet, common.getMsg(LANG, "query.result.abnormal"))
