# -*- coding: UTF-8 -*-
import common
import cliUtil
import traceback
def execute(cli):
    '''
    SSD盘诊断开关检查
    1 若系统软件版本与热补丁版本如下则继续检查，否则检查结果为通过。
                系统软件版本为V300R003C10或V300R003C10SPC100，热补丁版本小于V300R003C10SPH106；
                系统软件版本为V300R003C20或V300R003C20SPC200，热补丁版本小于V300R003C20SPH207；
                系统软件版本为V300R005C00或V300R005C00SPC200，热补丁版本小于V300R005C00SPH302；
                系统软件版本为V300R005C01。
    2 若系统中不存在SSD盘，则检查结果为通过；否则继续检查。
    3 若系统软件版本为V300R005C01，则继续检查；否则检查结果为不通过。
    4 若SSD盘的在线诊断开关为“On”，则检查结果为不通过；否则检查结果为通过。
    '''
    allCliRet = ""
    LOGGER = common.getLogger(PY_LOGGER, __file__)
    LANG = common.getLang(py_java_env)
    try:
        #检查版本是否为风险版本
        bugVersionDict = {"V300R003C10":"",
                          "V300R003C10SPC100":"V300R003C10SPH106",
                          "V300R003C20":"",
                          "V300R003C20SPC200":"V300R003C20SPH207",
                          "V300R005C00SPC200":"",
                          "V300R005C00SPC300":"V300R005C00SPH302",
                          "V300R005C01":"",}
        
        #获取设备当前产品版本和补丁信息
        checkRet, currentVersionDictList, hotPatchVersionList = common.parse_upgradePackage(cli, LANG)
        allCliRet = checkRet[1]
        if checkRet[0] != True:
            LOGGER.logSysAbnormal()
            return (cliUtil.RESULT_NOCHECK, allCliRet, checkRet[2])
        
        result, currentVersion, errMsg = common.getCurrentVersion(currentVersionDictList, LANG)
        if not result:
            return (cliUtil.RESULT_NOCHECK, allCliRet, errMsg)
        
        #获取热补丁版本
        result, hotPatchVersion, errMsg = common.getHotPatchVersion(hotPatchVersionList, LANG)
        if not result:
            return (cliUtil.RESULT_NOCHECK, allCliRet, errMsg)
        
        LOGGER.logInfo("currentVersion = %s,hotPatchVersion = %s" %(currentVersion, hotPatchVersion))
        #判断当前设备是否为风险版本和历史版本
        if not currentVersion in bugVersionDict:
            return (True, allCliRet, errMsg)
        
        if hotPatchVersion >= bugVersionDict.get(currentVersion) and bugVersionDict.get(currentVersion):
            return (True, allCliRet, errMsg)
        
        #查询是否存在SSD盘
        cmd = "show disk general|filterRow column=Type predict=match value=SSD.*"
        flag, cliRet, errMsg = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        allCliRet = common.joinLines(allCliRet, cliRet)
        if flag != True:
            return (cliUtil.RESULT_NOCHECK, allCliRet, errMsg)
        
        if cliUtil.queryResultWithNoRecord(cliRet):
            return (True, allCliRet, errMsg)
            
        #查询SSD盘诊断开关是否开启
        cmd = "show ssd diagswitch"
        flag, cliRet, errMsg = cliUtil.excuteCmdInDeveloperMode(cli, cmd, True, LANG)
        allCliRet = common.joinLines(allCliRet, cliRet)
        if flag != True:
            errMsg = common.getMsg(LANG, "cannot.get.info", {"zh":u"SSD盘诊断开关", "en":"the SSD disk diagnosis switch"}.get(LANG))
            return (cliUtil.RESULT_NOCHECK, allCliRet, errMsg)
        
        lineDictList = cliUtil.getVerticalCliRet(cliRet)
        if len(lineDictList) == 0:
            errMsg = common.getMsg(LANG, "cannot.get.info", {"zh":u"SSD盘诊断开关", "en":"the SSD disk diagnosis switch"}.get(LANG))
            return (cliUtil.RESULT_NOCHECK, cliRet, errMsg)
        
        for lineDict in lineDictList:
            ssdDiagSwitch = lineDict.get("SSD Diag Switch","")
            if ssdDiagSwitch == "On":
                errMsg = common.getMsg(LANG, "ssd.diag.switch.disabled", (currentVersion, hotPatchVersion))
                return (False, allCliRet, errMsg)
        return (True, allCliRet, errMsg)
    
    except Exception:
        LOGGER.logException(str(traceback.format_exc()))
        return (cliUtil.RESULT_NOCHECK, allCliRet, common.getMsg(LANG, "query.result.abnormal"))
