#!/usr/bin/python
# -*- coding: UTF-8 -*-

from memory_inspect.utils.six_about import to_hex_str, to_int


# DDR4 rank address 解析至 bank_group, bank，row，column      page_mode = 'open',  page_mode 的值会对结果造成影响
def Translator2_ddr4(rankAddr, page_mode):  # 8Gb(x4)   输入的 rankAddr 为整形变量

    rankAddr_temp = bin(rankAddr)
    rankAddress = rankAddr_temp[2:].zfill(39)

    if page_mode == 'Open':
        #   bank_group:::   mcmtrReg.Bits.bank_xor_enable !=1
        bank_group = to_int('0b' + rankAddress[-7])
        bank_group |= to_int('0b' + rankAddress[-18]) << 1

        #   bank:::   mcmtrReg.Bits.bank_xor_enable !=1
        bank_temp = '0b' + rankAddress[-20:-18]
        bank = to_int(bank_temp)

        # row ::: rank_address (16,12)*bits(33,29), (11,5)*bits(27,21), (4)*bits(28), (3)*bits[20], (2,0)*bits(16,14)
        row_temp = '0b' + rankAddress[-34:-29] + rankAddress[-28:-21] + rankAddress[-29] + rankAddress[
            -21] + rankAddress[-17:-14]
        row = to_int(row_temp)

        #   col:::   bios  col -----------------------------------------------------------------------
        col = 0
        col |= to_int('0b' + rankAddress[-6:-3])
        col |= to_int('0b' + rankAddress[-14:-7]) << 3

        return ",".join(map(str, (bank_group, bank, to_hex_str(row), to_hex_str(col))))

    if page_mode == 'Closed':
        return "page_mode_fail"


def Translator1_ddr4(rankAddr, page_mode):  # 8Gb(x8)  16G内存条使用   输入的 rankAddr 为整形变量

    rankAddr_temp = bin(rankAddr)
    rankAddress = rankAddr_temp[2:].zfill(39)

    if page_mode == 'Open':
        #   bank_group:::   mcmtrReg.Bits.bank_xor_enable !=1
        bank_group = to_int('0b' + rankAddress[-7])
        bank_group |= to_int('0b' + rankAddress[-18]) << 1

        #   bank:::   mcmtrReg.Bits.bank_xor_enable !=1
        bank_temp = '0b' + rankAddress[-20:-18]
        bank = to_int(bank_temp)

        # row ::: rank_address (16,12)*bits(33,29), (11,5)*bits(27,21), (4)*bits(28), (3)*bits[20], (2,0)*bits(16,14)
        row_temp = '0b' + rankAddress[-33:-29] + rankAddress[-28:-21] + rankAddress[-29] + rankAddress[
            -21] + rankAddress[-17:-14]
        row = to_int(row_temp)

        #   col:::   bios  col -----------------------------------------------------------------------
        col = 0
        col |= to_int('0b' + rankAddress[-6:-3])
        col |= to_int('0b' + rankAddress[-14:-7]) << 3

        return ",".join(map(str, (bank_group, bank, to_hex_str(row), to_hex_str(col))))

    if page_mode == 'Closed':
        return "page_mode_fail"
