# -*- coding: UTF-8 -*-
import os
import shutil
import time
import json
import traceback
import common
import re
from frameone.util import contextUtil
from cbb.frame.util import sqlite_util
from com.huawei.oss.cn.common.anonymize import FileAnonymizeUtil
from com.huawei.ism.tool.obase.exception import ToolException
import com.huawei.ism.tool.obase.connection.SftpTransporter as SftpCls

import cliCmd
import cliUtil
from cbb.frame.cli import cliUtil as cbb_cliUtil
from cbb.frame.base import product
from cbb.frame.base import baseUtil
from frameone.util import common as frame_common
LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

PY_JAVA_ENV = py_java_env
ENCLO_MAX_DEPTH = "enclo_max_depth"
RETRY_TIME = 4
PASS_RATE = 100
COMMON_ACCURACY = 1e-5


def checkConfData(data):
    if data != None and \
        "get" in dir(data) and \
        "Expansion" == data.get("mainScene") and \
        "Expansion Evaluation" != data.get("subScene") and \
        "perInspector" == data.get("toolScene"):
        return True
    return False

def showMsg(data, lang):
    if checkConfData(data):
        if lang == "zh":
            return u"备份系统配置数据失败，请联系技术支持工程师"
        return "Failed to back up system configuration data. Please contact technical support engineers"
    return ""

def collectFile(devObj, localFileDir, collectItemList):
    #触发设备收集
    ssh = devObj.get("ssh")
    sftp = SftpCls(ssh)
    for collectItem in collectItemList:
        # 存在收集config的收集项，规避FC启动器缺陷，未安装对应补丁，且启动器数量超过80个或控制器不正常，限制收集。
        if "running_data" == collectItem:
            __, productVersion, hotPatchVersion, __, __ = common.getProductVersionAndHotPatchVersion(ssh, LOGGER, LANG)
            isRisk = isRiskVersionFcCauseRisk(ssh, productVersion, hotPatchVersion)
            if isRisk:
                LOGGER.logInfo("hot patch version is lower than requst, and fc ini is more than 80 or controller is not normal.")
                continue

            LOGGER.logInfo("collect item:%s no risk." % collectItem)

        LOGGER.logInfo("collect item:%s" % collectItem)

        cmd = "show file export_path file_type=%s" % collectItem
        ## 超时时间修改为10分钟，超大规格（4w主机）到处运行数据7-8分钟左右
        cliRet = ssh.execCmdNoLogTimout(cmd, 10*60)
        
        #下载文件
        remoteFile = cliRet.splitlines()[1].split(":")[1].strip()

        try:
            sftp.getFile(remoteFile, localFileDir, None)
        except Exception:
            LOGGER.logError("failed to download:\n trace back:{}".format(
                traceback.format_exc()))

        if "running_data" == collectItem:
            #对运行数据文件进行脱敏
            FileAnonymizeUtil.anonymizeWithEncoding(localFileDir, "utf-8")
            
        #删除设备上文件
        deleteFile(ssh, collectItem)
    if sftp:
        sftp.close()


def isRiskVersionFcCauseRisk(cli, currentSoftVersion, currentHotpatchVersion):
    '''
    @summary: 工具规避在收集日志时触发的问题
    @param softwareVersionList: 当前阵列的版本所有控制器的版本列表
    @param hotPatchVersionList: 当前阵列的版本所有控制器的补丁版本列表
    retrun：False：表示是风险版本
            True：表示不是风险版本
    '''

    # 系统版本及热补丁风险版本
    riskVersionDict = {
        'V300R006C20': 'V300R006C20SPH015',
        'V300R006C20SPC100': 'V300R006C20SPH115',
        'V500R007C10': 'V500R007C10SPH015',
        'V500R007C30SPC100': 'V500R007C30SPH105',
        'V300R001C21SPC100': 'V300R001C21SPH112',
        'V500R007C10SPC100': 'V500R007C10SPH115',
        'V300R002C10SPC100': 'V300R002C10SPH101',
        'V300R006C50SPC100': 'V300R006C50SPH105',
        'V300R001C30SPC100': 'V300R001C30SPH106'
    }

    # 对版本型号及热补丁版本进行适配,如果系统版本不涉及则通过
    if currentSoftVersion not in riskVersionDict:
        return False

    needInstallHotpatchVersion = riskVersionDict.get(currentSoftVersion)
    # 如果热补丁版本匹配则通过
    if currentHotpatchVersion != '--' and currentHotpatchVersion >= needInstallHotpatchVersion:
        return False

    # 如果热补丁版本不匹配
    # 需判断启动器数量和控制器冗余
    cmd = "show initiator initiator_type=FC"
    cliRet = cli.execCmdNoLogTimout(cmd, 10*60)
    iniDictList = cliUtil.getHorizontalCliRet(cliRet)
    normalInitiatorCount = 0
    for iniDict in iniDictList:
        if iniDict.get("Running Status", '') == "Online":
            normalInitiatorCount += 1

    isAllCtrlNormal = True
    cmd = "show controller general |filterColumn include columnList=Health\sStatus,Running\sStatus,Controller"
    cliRet = cli.execCmdNoLogTimout(cmd, 10*60)
    controllerDictList = cliUtil.getVerticalCliRet(cliRet)
    for controllerDict in controllerDictList:
        if controllerDict.get("Health Status", '') != "Normal":
            isAllCtrlNormal = False
            break

        if controllerDict.get("Running Status", '') != "Online":
            isAllCtrlNormal = False
            break

    LOGGER.logInfo("hot patch version is lower than request, normal fc Initiator Count:%s, isAllCtrlNormal:%s" % (
                  normalInitiatorCount, isAllCtrlNormal))

    if normalInitiatorCount <= 200 and isAllCtrlNormal:
        return False

    # 未安装对应补丁，且启动器数量超过80个或控制器不正常，限制收集。
    return True

def execute(devObj):
    '''
    @summary: 收集设备上config.txt文件
    '''
    try:
        msg = ""
        dbConfig = "configuration_data"
        data = py_java_env.get("sceneData")
        default_pass_list = ["CDM", "HUAWEI OceanCyber 300", "HUAWEI CyberEngine 300"]
        if str(PY_JAVA_ENV.get("devInfo").getDeviceType()) in default_pass_list:
            return ("", dict(flag=True, des=""))
        _opening_delivery_inspect_add_tag()
        #巡检场景收集项：运行数据
        collectItemList = ["running_data", "event"]
        #扩容场景收集项，运行数据、配置数据
        PY_LOGGER.info("checkConfData : %s" % str(checkConfData(data)))
        if checkConfData(data):
            collectItemList.append(dbConfig)
        
        #增加收集config文件重试机制
        x = 4
        for i in range(1, x):
            try:
                PY_LOGGER.info("start the collect %s time" % i)
                PY_LOGGER.info("executing post inspect.")
                #为每套设备创建文件存放文件夹
                tmpDataDir = devObj.get("tmpDataDir")
                devIp = py_java_env.get("devInfo").getIp()
                #IPV6替换:为.否则创建文件夹失败
                devIp = str(devIp).replace(":", ".")
                devSN = py_java_env.get("devInfo").getDeviceSerialNumber()
                localFileDir = tmpDataDir + os.path.sep + "data" + os.path.sep + "config" + os.path.sep + devIp + "_" + devSN
                if not os.path.exists(localFileDir):
                    os.makedirs(localFileDir)
                        
                #触发设备收集
                collectFile(devObj, localFileDir, collectItemList)

                # DB备份不放在报告中，需移出
                sceneResPath = py_java_env.get("sceneResPath")
                srcDBPath = localFileDir + os.path.sep + "db.dat"
                dstDBpath = sceneResPath + os.path.sep + "db.dat"
                if os.path.isfile(srcDBPath):
                    shutil.move(srcDBPath, dstDBpath)

                break
            except:
                PY_LOGGER.error("start the collect failed at %s time" % i)
                PY_LOGGER.error("Failed to collect cliCmd:" + str(traceback.format_exc()))
                msg = showMsg(data, py_java_env.get("lang"))
                time.sleep(5)
            
        
        #收集clicmd文件(忽略异常)
        try:
            cliCmdFileDir = os.path.join(tmpDataDir, "data", "Other", devIp + "_" + devSN)
            #创建文件夹
            if not os.path.exists(cliCmdFileDir):
                os.makedirs(cliCmdFileDir)
            devObj["logger"] = PY_LOGGER
            cliCmd.collectCliCmd(devObj, cliCmdFileDir)
            # 为eService收集cli命令的回显，存放到与config文件相同的路径下，A800巡检不需要收集
            is_a800_inspect = devObj.get("isA800Inspect")
            if not is_a800_inspect:
                time_out = cliCmd.collectCliCmd4eService(devObj, localFileDir)
                PY_LOGGER.info("is time out:%s" % time_out)
        except:
            PY_LOGGER.error("Failed to collect cliCmd:" + str(traceback.format_exc()))
        
        PY_LOGGER.info("getting file %s success" % collectItemList)
        if msg:
            return ("ERROR", dict(flag=False, des=msg))

        # 若是扩容评估场景，查询级联深度规格(忽略异常)
        enclo_max_depth = ""
        try:
            enclo_max_depth = query_cascaded_disk_enclosures(
                devObj.get("ssh"))
        except(ToolException, Exception):
            PY_LOGGER.error(
                "Failed to query cascaded disk enclosures:" + str(
                    traceback.format_exc()))
        devObj.put(ENCLO_MAX_DEPTH, enclo_max_depth)
        
        return ("", dict(flag=True, des=""))
    except:
        PY_LOGGER.error("Failed to collect running file, because %s" % str(traceback.format_exc()))
        #后台收集，忽略失败
        return ("", dict(flag=True, des=""))
    finally:
        ensureTlvChannelClosed(devObj)
        try:
            context = contextUtil.getContext(py_java_env)
            contextUtil.releaseRest(context)
            LOGGER.logInfo('conn close success.')
        except:
            LOGGER.logError('conn close except.')
        switch = PY_JAVA_ENV.get('switch')
        if switch is False:
            ssh = devObj.get("ssh")
            cliUtil.closeDeveloperSwitch(ssh, LANG)


def _opening_delivery_inspect_add_tag():
    # 开局质检场景
    try:
        if common.is_opening_delivery_inspect(py_java_env) and \
                abs(float(PY_JAVA_ENV.get("passRateMap", {}).get("PassRate", 0)) - PASS_RATE) < COMMON_ACCURACY:
            _opening_delivery_inspect_post_request()
    except(ToolException, Exception):
        PY_LOGGER.error("quality check request is false" + str(traceback.format_exc()))


@frame_common.wrapAllExceptionLogged(logger=PY_LOGGER)
def _opening_delivery_inspect_post_request():
    for retry_time in range(1, RETRY_TIME):
        context = contextUtil.getContext(py_java_env)
        rest = contextUtil.getRest(context)
        rest_con = rest.getRest()
        dev_ip = py_java_env.get("devInfo").getIp()
        url = "{}/api/v2/task/quality_inspect/finish".format(rest_con.getHttpsPrefixWithAddress())
        record = json.loads(rest_con.execPost(url, None).getContent())
        LOGGER.logInfo("The POST request is attempted for the {} time.".format(retry_time))
        if record.get("result", {}).get("code", 1) == 0:
            return


def query_cascaded_disk_enclosures(cli):
    enclo_max_depth = ""
    # 查询场景，若不是扩容评估场景(扩容硬盘框或者扩控)，不涉及
    if not common.is_expansion_disk_or_ctrl_scene(PY_JAVA_ENV):
        return enclo_max_depth

    product_model = str(PY_JAVA_ENV.get("devInfo").getDeviceType())
    product_version = str(PY_JAVA_ENV.get("devInfo").getProductVersion())
    # 只在高端设备需要，不是高端退出
    if not baseUtil.isHighEndDev(product_model):
        return enclo_max_depth
    # 只在融合的V3和V5老硬件需要查询，Dorado和融合的ARM 1620 kunpeng新硬件不用
    if common.isDorado(product_model) or product.isKunpeng(product_version):
        return enclo_max_depth
    # V300R003C20SPC200d1SPH203及之后的补丁，使用dbug命令
    # V3R6C00SPC100之后的使用CLI命令(可以在SVP上执行)，使用cbb公共方法
    # 其他版本没有，直接退出
    enclo_max_depth = ""
    if product_version >= 'V300R006C00SPC100':
        enclo_max_depth = str(cbb_cliUtil.get_enclo_max_depth(cli, LANG))
    elif product_version == "V300R003C20SPC200":
        cliRet, __, hotPatchVer = common.getHotPatchVersionAndCurrentVersion(
            cli, LANG)
        if hotPatchVer >= "V300R003C20SPH203":
            enclo_max_depth = get_enclo_max_depth_by_debug(cli)
    return enclo_max_depth


def get_enclo_max_depth_by_debug(cli):
    conn_cli = None
    max_exp_depth = ""
    try:
        # 如果是18000执行debug命令获取阵列链接
        flag, conn_cli, err_msg = common.createDeviceCliContFor18000(
            cli, PY_JAVA_ENV, LOGGER, LANG
        )
        if flag is not True:
            return max_exp_depth

        cmd = "eam showframecascademode"
        flag, ret, err_msg = cliUtil.excuteCmdInDebugModel(conn_cli, cmd, LANG)
        if flag is not True:
            return max_exp_depth
        regx = re.compile(r"Cascade Mode In Global Variable\s*:\s*(\d*)")
        enclo_max_depth_list = regx.findall(ret)
        if not enclo_max_depth_list:
            return max_exp_depth
        max_exp_depth = enclo_max_depth_list[0]
    except(ToolException, Exception):
        PY_LOGGER.error(
            "Failed to collect cliCmd:" + str(traceback.format_exc()))
    finally:
        if conn_cli is not cli:
            common.closeDeviceCliContFor18000(
                conn_cli, PY_JAVA_ENV, LOGGER, LANG
            )
    return max_exp_depth


def deleteFile(ssh, collectItem):
    '''
    #删除阵列端数据
    '''
    try:
        cmd4delete = "delete file filetype=%s" % collectItem
        ssh.execCmd(cmd4delete)
    except:
        PY_LOGGER.error("deleteFile failed because cli execute failed")


@frame_common.wrapAllExceptionLogged(logger=PY_LOGGER)
def ensureTlvChannelClosed(devObj):
    if not py_java_env.get('needCloseTlv'):
        PY_LOGGER.error("Need not to close tlv channel")
        return

    cli = devObj.get("ssh")
    exeResult, cliRet, _ = cliUtil.excuteCmdInDeveloperMode(cli, 'change system external_tlv_channel enabled=no',
                                                       True, 'en')
    if exeResult != True:
        PY_LOGGER.error("Failed to close tlv channel")
        return
    else:
        while '(y/n)' in cliRet:
            exeResult, cliRet, _ = cliUtil.excuteCmdInCliMode(cli, 'y', True, 'en')

        PY_LOGGER.info("Close tlv channel success.")
