# -*- coding: UTF-8 -*-
import time
import threading
import traceback

import common
import cliUtil
import cli_util_cache as cache_util
import common_cache
from common import UnCheckException

from cbb.frame.cli.cli_with_cache import execute_cmd_in_cli_mode
from cbb.frame.util import sqlite_util
from cbb.frame.context import sqlite_context
from cbb.frame.base import product

LANG = py_java_env.get("lang")
LOGGER = common.getLogger(PY_LOGGER, __file__)
MUTEX = threading.Lock()
MUTEX_HOST = threading.Lock()
MUTEX_MAPPED_LUN = threading.Lock()
MUTEX_PROGRESS = threading.Lock()
MUTEX_HOST_INFO_MAPPED_LUN = threading.Lock()
MUTEX_LUN_LINKED_NUM = threading.Lock()
MUTEX_QUO_SERVER_INFO = threading.Lock()
startTime = time.strftime("%Y-%m-%d %H:%M:%S", time.localtime())

devProgress = 100.0
singleProgress = 1.0
currentProgress = 1.0

mappingString = {"zh": u"查询LUN信息：", "en": "Querying LUN Infomation:"}.get(LANG)

a800MappingString = {"zh": u"查询信息：", "en": "Querying Infomation:"}.get(LANG)

hostLunString = {"zh": u"查询主机信息：", "en": "Querying Host Information:"}.get(LANG)

defaultString = mappingString
hasAddedHostInitiatorList = []

objectForPy = py_java_env.get("objectForPy")
MEM_INFO_HOST_QUO = objectForPy.get("HYPER_QUO_SERVER_AND_NOT_ADD_HOST_INFO")
QUO_SERVER_LIST = "QUO_SERVER_LIST"
NOT_ADD_HOST_LIST = "NOT_ADD_HOST_LIST"
NOT_ADD_HOST_CLASSIFY_BY_TYPE = "NOT_ADD_HOST_CLASSIFY_BY_TYPE"
HOST_TYPE_LIST = []
ARRAY_INFO_FUSION = objectForPy.get("array_product_version_info")
ARRAY_INITIATOR_INFO = objectForPy.get("array_initiator_info")
HOST_MAPPED_ARRAY_SN = objectForPy.get("host_mapped_array_sn")

def execute(checkDevNodes, inspectDevNodes, allDevNodes, progressDialog):
    """
    @summary: 用户添加完设备后点击“下一步”调用的方法。可以在此方法中预先判断执行检查前的一些事情，例如检查多台设备之间的联系等。
    @param checkDevNodes: 用户添加的所有执行巡检的属于当前业务包支持的设备的DevNode.java对象，包含了设备IP,SN,系统软件版本，设别类型等信息。
    @param inspectDevNodes: 用户添加的执行巡检的所有的设备。
    @param allDevNodes: 用户添加的所有设备（执行巡检+不巡检的设备）
    @param progressDialog: 框架刷新进度的对象。
    @return resultList: ((ip, sn, errMsg)...)：((设备IP, SN, 用户提示信息)...)
    """
    global devProgress, currentProgress, defaultString, \
        hasAddedHostInitiatorList, MEM_INFO_HOST_QUO, HOST_TYPE_LIST, \
        ARRAY_INFO_FUSION, ARRAY_INITIATOR_INFO, HOST_MAPPED_ARRAY_SN
    # 存储远端设备结果
    resultList = []

    # 主机信息结果
    hostList = []
    MEM_INFO_HOST_QUO = {}
    ARRAY_INFO_FUSION = {}
    ARRAY_INITIATOR_INFO = {}
    HOST_MAPPED_ARRAY_SN = {}

    # 线程池
    threadList = []
    LOGGER.logInfo("__file__=%s" % __file__)
    defaultString = getMappingString(checkDevNodes)

    try:
        allStrgHyprMtrLns = py_java_env.get("allStrgHyprMtrLns")
        # 获取用户添加的执行巡检的所有设备的sn(从框架获取)
        inspectDevSNList = getSNs(inspectDevNodes)
        # 获取用户添加的所有设备（执行巡检+不巡检的设备）的sn(从框架获取)
        allDevSNList = getSNs(allDevNodes)
        currentProgress = 1.0
        devLen = 0
        refreshProgress(progressDialog, currentProgress)
        LOGGER.logInfo("devProgress is :%s" % devProgress)
        HOST_TYPE_LIST = []
        hasAddedHostInitiatorList = []
        for checkDevNode in inspectDevNodes:
            devType = checkDevNode.getItDeviceType().getName()
            if devType != "Storage":
                host_type = str(checkDevNode.getDeviceName())
                HOST_TYPE_LIST.append(host_type.lower())
                host_sn = str(checkDevNode.getDeviceSerialNumber())
                ini_list = get_host_ini(checkDevNode)
                HOST_MAPPED_ARRAY_SN[host_sn] = {"ini_list": ini_list}
                hasAddedHostInitiatorList.extend(ini_list)
            else:
                devLen += 1

        LOGGER.logInfo("host type list is:%s" % str(HOST_TYPE_LIST))

        if devLen == 0:
            devLen = 1

        devProgress = 99.0 / devLen
        LOGGER.logInfo("hasAddedHostInitiatorList initiator : %s" % (hasAddedHostInitiatorList))
        # 为当前业务包下的每台设备创建一个线程，用来检查该设备的远程设备是否已经在巡检队列中
        for checkDevNode in inspectDevNodes:
            devType = checkDevNode.getItDeviceType().getName()
            LOGGER.logInfo("device is storage:%s?, devType:%s" % (checkDevNode.getIp(), devType))
            if devType != "Storage":
                continue

            snList = checkDevNode.getRemoteSNs()
            # 当前已不存在老工具箱未查询getRemoteSNs配套新子工具的场景
            if not snList:
                continue

            # 为当前业务包下的每台设备创建一个线程，用来检查该设备的远程设备是否已经在巡检队列中
            checkThread = threading.Thread(target=queryHostAndLunInfo, args=(
                checkDevNode, inspectDevSNList, allDevSNList, resultList, hostList, progressDialog, snList,
                allStrgHyprMtrLns))
            threadList.append(checkThread)

        # 启动所有线程
        for checkThread in threadList:
            checkThread.start()

        # 主线程中等待所有子线程退出
        for checkThread in threadList:
            checkThread.join()

        LOGGER.logInfo("resultList:%s" % str(tuple((tuple(resultList), tuple(hostList)))))
        objectForPy.put("HYPER_QUO_SERVER_AND_NOT_ADD_HOST_INFO", MEM_INFO_HOST_QUO)
        objectForPy.put("array_product_version_info", ARRAY_INFO_FUSION)
        objectForPy.put("array_initiator_info", ARRAY_INITIATOR_INFO)
        objectForPy.put("host_mapped_array_sn", HOST_MAPPED_ARRAY_SN)
        LOGGER.logInfo("array_initiator_info:%s" % ARRAY_INITIATOR_INFO)
        LOGGER.logInfo("host_mapped_array_sn:%s" % HOST_MAPPED_ARRAY_SN)

    except:
        LOGGER.logError(str(traceback.format_exc()))

    return tuple((tuple(resultList), tuple(hostList)))

def getMappingString(checkDevNodes):
    # A800集群巡检时，所有的zone设备型号都是OceanStor A800，不支持查询lun信息
    if checkDevNodes and len(checkDevNodes) > 0 and checkDevNodes[0].getProductModel() == "OceanStor A800":
        return a800MappingString
    return mappingString

def get_host_ini(host_dev_node):
    """
    获取主机启动器信息
    :param host_dev_node: 主机devnode 
    :return: 启动器列表
    """
    fc_wwns = host_dev_node.getHostFCLauncherWwns()
    iscsiWwns = host_dev_node.getHostISCSILauncherWwns()
    nvme_wwns = host_dev_node.getHostNvmeLauncherWwns()
    all_ini_list = list(fc_wwns) if fc_wwns else []
    iscsi_list = list(iscsiWwns) if iscsiWwns else []
    nvme_wwns_list = list(nvme_wwns) if nvme_wwns else []
    all_ini_list.extend(nvme_wwns_list)
    all_ini_list.extend(iscsi_list)
    all_ini_list = [initiator.lower() for initiator in all_ini_list]
    return all_ini_list


def queryHostAndLunInfo(checkDevNode, inspectDevSNList, allDevSNList, resultList, hostList, progressDialog, snList,
                        allStrgHyprMtrLns):
    """
    总体原则：如果当前DevNode有缓存则直接取缓存，否则建立连接查询。
    """
    global currentProgress
    name = checkDevNode.getDeviceName()
    ip = checkDevNode.getIp()
    sn = checkDevNode.getDeviceSerialNumber()
    p_version = checkDevNode.getProductVersion()
    cli = None
    try:
        if snList is None:
            cli, errCode = common.getSSHbyDevNode(checkDevNode)
            LOGGER.logInfo("Ip:%s, snList=%s" % (checkDevNode.getIp(), snList))
            flag, snList, errMsg = getRemoteDeviceSNs(checkDevNode, cli, errCode)
            if not flag:
                addResult(resultList, name, ip, sn, errMsg)
                LOGGER.logInfo(
                    "current device is (ip:%s, sn:%s), check remote device result is %s." % (ip, sn, errMsg))
                return

            try:
                if snList:
                    checkDevNode.setRemoteSNs(snList)
            except:
                LOGGER.logError(str(traceback.format_exc()))
        checkRemoreDevice(checkDevNode, inspectDevSNList, allDevSNList, resultList, snList)

        if len(snList) == 0:
            return

        sqlite_util.ini_sqlite_db_for_dev(objectForPy,
                                          sn,
                                          LOGGER)

        context = py_java_env.get("objectForPy")
        sqlite_conn = sqlite_context.get_sqlite_conn_from_context(context, sn,
                                                                  LOGGER)
        myPthread = AsynProgress(progressDialog, devProgress * 1.0 / 10.0)
        myPthread.start()
        # 建立连接查询
        cli, errCode = common.getSSHbyDevNode(checkDevNode)

        # 判断如果需要使用running data 则下载，并解析放在内存中
        if common_cache.is_use_running_data(p_version):
            # 点击下一步提示添加主机后，不需要再重新下载一次
            running_key = cache_util.RUNNING_DATA.format(sn)
            obj_py = objectForPy.get(running_key)
            if obj_py and obj_py.get(sn, {}):
                LOGGER.logInfo("Downloaded file. no need do it again.")
            elif common_cache.ana_running_data(
                    cli, sn, p_version, LANG, sqlite_conn, LOGGER, objectForPy):
                with MUTEX:
                    if not obj_py:
                        obj_py = {}
                    obj_py[sn] = {"running_data_dict": True,
                                  "p_version": p_version}
                    objectForPy.put(running_key, obj_py)
                LOGGER.logInfo("Downloaded file success.")
            else:
                LOGGER.logError("Downloaded file error! need cmd instead!")
        myPthread.setStopFlag(True)
        # 查LUN映射
        query_ret = getMappedHypermetroLun(checkDevNode,
                                           allStrgHyprMtrLns,
                                           cli,
                                           progressDialog,
                                           devProgress * 2 / 5)
        lun_dict = query_ret[0]
        echo = query_ret[1]
        pair_flag = query_ret[2]
        pair_msg = query_ret[3]

        # 如果存在fusionsphere/Linux主机，才需要获取阵列版本和补丁信息
        if "fusionsphere" in HOST_TYPE_LIST or "linux" in HOST_TYPE_LIST:
            ret = common.getProductVersionAndHotPatchVersion(cli,
                                                             LOGGER, LANG)
            version_flag = ret[0]
            product_version = ret[1]
            patch_version = ret[2]
            cli_ret_patch = ret[3]
            version_msg = ret[4]

            ARRAY_INFO_FUSION[sn] = {"product version": product_version,
                                     "hot patch version": patch_version,
                                     "patch cli ret": cli_ret_patch,
                                     "patch cli flag": version_flag,
                                     "patch cli msg": version_msg,
                                     "hyper lun cli ret": echo,
                                     "hyper lun flag": pair_flag,
                                     "hyper lun msg": pair_msg
                                     }
        LOGGER.logInfo('array_product_ 2.%s' % str(ARRAY_INFO_FUSION))
        get_quorums_erver(cli, checkDevNode)
        getHostInfo(checkDevNode, hostList, lun_dict, cli, errCode,
                    progressDialog, devProgress * 1 / 4)
        getPortInfo(cli, checkDevNode, lun_dict, progressDialog,
                    devProgress * 1 / 4)
    except:
        LOGGER.logError(str(traceback.format_exc()))
    finally:
        common.closeSSH(cli)
        LOGGER.logInfo('Close cli in requireCheck.py.')


def add_hyper_host_from_mem(not_added_host_dict_list):
    """
    从缓存中过滤掉已添加的主机，用于人工检查显示
    :return:
    """
    global MEM_INFO_HOST_QUO, hasAddedHostInitiatorList
    new_not_added_host_info_dict_list = []
    for host_info_dict in not_added_host_dict_list:
        initiator_str = host_info_dict.get("initiator", "")
        tmp_initiator_list = initiator_str.split(",")
        new_initiator_list = []
        for initiator_str in tmp_initiator_list:
            if initiator_str in hasAddedHostInitiatorList:
                continue

            new_initiator_list.append(initiator_str)

        if not new_initiator_list:
            continue

        host_info_dict["initiator"] = ",".join(new_initiator_list)
        new_not_added_host_info_dict_list.append(host_info_dict)

    MEM_INFO_HOST_QUO[NOT_ADD_HOST_LIST] = new_not_added_host_info_dict_list


def get_quorums_erver(cli, dev_node):
    global MEM_INFO_HOST_QUO
    tmp_server_dict_list = []
    sn = str(dev_node.getDeviceSerialNumber())
    cmd = "show hyper_metro_domain general"
    flag, cli_ret, err_msg = execute_cmd_in_cli_mode(objectForPy, cli, cmd,
                                                     LANG, sn, LOGGER)
    tmp_res_dict = getHorizontalCliRet(cli_ret)
    quo_server_id_list = []
    for record in tmp_res_dict:
        domain_id = record.get("ID")
        cmd = "show hyper_metro_domain general domain_id={0}".format(
            domain_id)
        flag, cli_ret, err_msg = execute_cmd_in_cli_mode(objectForPy,
                                                         cli, cmd,
                                                         LANG, sn, LOGGER)
        domain_detail_list = getVerticalCliRet(cli_ret)
        for detail_dict in domain_detail_list:
            server_id = detail_dict.get("Quorum Server ID", '')
            if server_id and server_id != "--":
                quo_server_id_list.append(server_id)
            standby_id = detail_dict.get("Standby Quorum ID", '')
            if standby_id and standby_id != "--":
                quo_server_id_list.append(standby_id)

    cmd = "show quorum_server general server_id=%s"
    for server_id in quo_server_id_list:
        cmd_str = cmd % server_id
        flag, cli_ret, err_msg = execute_cmd_in_cli_mode(objectForPy, cli,
                                                         cmd_str, LANG, sn,
                                                         LOGGER)
        tmp_dict = getVerticalCliRet(cli_ret)
        for record in tmp_dict:
            server_name = record.get("Server Name", '--')
            server_ip = record.get("Active IP", '--')
            server_running_status = record.get("Running Status", '--')
            tmp_server_dict_list.append(
                {"quoServerName": server_name,
                 "sn": sn,
                 "ip": server_ip,
                 "runningStatus": server_running_status,
                 "isThirdPartStation": 0,
                 "isUseStorage": 0})

    if tmp_server_dict_list:
        put_quo_server_num(MEM_INFO_HOST_QUO, tmp_server_dict_list)


def getPortInfo(cli, devNode, lun_dict, progressDialog, progress):
    """
    获取LUN接管端口信息
    :param cli:
    :param devNode:
    :return:
    """

    sn = devNode.getDeviceSerialNumber()
    p_version = str(devNode.getProductVersion())
    portDict = {}
    ibPortList = []
    myPthread = AsynProgress(progressDialog, progress)
    myPthread.start()
    cmd = "show ib_port general|filterRow column=Running\sStatus predict=equal_to value=Link\sUp"
    flag, cli_ret, err_msg = execute_cmd_in_cli_mode(objectForPy, cli, cmd,
                                                     LANG, sn, LOGGER)
    tmpResDict = getHorizontalCliRet(cli_ret)
    for record in tmpResDict:
        if record.get("ID", ''):
            ibPortList.append(record.get("ID", ''))
    portDict["IB"] = ibPortList

    cmd = "show bond_port"
    flag, cli_ret, err_msg = execute_cmd_in_cli_mode(objectForPy, cli, cmd,
                                                     LANG, sn, LOGGER)
    tmpResDict = getHorizontalCliRet(cli_ret)
    bondPortList = []
    for record in tmpResDict:
        if record.get("ID", ''):
            bondPortList.append(record.get("ID", ''))
    portDict["BOND_PORT"] = bondPortList

    cmd = "show port general logic_type=Host_Port running_status=link_up"
    flag, cli_ret, err_msg = execute_cmd_in_cli_mode(objectForPy, cli, cmd,
                                                     LANG, sn, LOGGER)

    portDictTemp = getAllLinkedPortId(cli_ret)
    portDict.update(portDictTemp)

    cmd = "show port initiator port_type=%s port_id=%s"
    hostIdList = []
    for portType in portDict:
        portList = portDict.get(portType, [])
        if not portList:
            continue

        for portId in portList:
            cmdStr = cmd % (portType, portId)
            flag, cli_ret, err_msg = execute_cmd_in_cli_mode(objectForPy, cli,
                                                             cmdStr,
                                                             LANG, sn, LOGGER)
            tmpResDict = getHorizontalCliRet(cli_ret)
            for record in tmpResDict:
                host_id = record.get('Host ID', '')
                if host_id and host_id != '--':
                    hostIdList.append(host_id)
    LOGGER.logInfo("query host id: %s" % str(hostIdList))

    # 如果是dorado v6,先判断是否收集config，如果有则使用config，
    # 如果config中某个对象失败，则需要单独对对象使用命令查询
    if product.is_dorado_series_version(p_version):
        mapping_flag, lun_host_dict, port_group_list, host_group_list = \
            cache_util.get_all_mapping_info_from_config_v6(lun_dict,
                                                           objectForPy,
                                                           p_version,
                                                           sn, LOGGER)
        LOGGER.logInfo("mapping_flag:{0}, lun_host_dict:{1}, "
                       "port_group_list:{2}, "
                       "host_group_list:{3}".format(str(mapping_flag),
                                                    lun_host_dict,
                                                    port_group_list,
                                                    host_group_list))

        # 如果mapping为空，则需要全部使用命令重新查询
        if not mapping_flag:
            LOGGER.logInfo("query port --use cmd query!")
            # 使用命令查询
            get_mapping_info_v6(cli, sn, lun_dict)
        else:
            # 如果没有主机组信息
            cmd_str = "show host_group host host_group_id={0}"
            get_obj_by_cmd(host_group_list, cmd_str, cli, sn)
            # 如果没有端口组
            cmd_str = "show port_group port port_group_id={0}"
            get_obj_by_cmd(port_group_list, cmd_str, cli, sn)
    else:
        # 融合存储
        view_flag, host_group_list, port_group_list, lun_group_list = \
            cache_util.get_all_view_info_from_config_ocean_stor(
                lun_dict, objectForPy, p_version, sn, LOGGER)
        # 如果view为空，则需要全部使用命令重新查询
        if not view_flag:
            get_mapping_info(cli, sn)
        else:
            # 如果没有主机组信息
            cmd_str = "show host_group host host_group_id={0}"
            get_obj_by_cmd(host_group_list, cmd_str, cli, sn)
            # 如果没有端口组
            cmd_str = "show port_group port port_group_id={0}"
            get_obj_by_cmd(port_group_list, cmd_str, cli, sn)
            # 如果没有LUN组
            cmd_str = "show lun_group lun lun_group_id={0}"
            get_obj_by_cmd(lun_group_list, cmd_str, cli, sn)

    myPthread.setStopFlag(True)


def get_obj_by_cmd(obj_list, cmd_str, cli, sn):
    for obj_id in obj_list:
        cmd = cmd_str.format(obj_id)
        flag, cli_ret, err_msg = execute_cmd_in_cli_mode(
            objectForPy,
            cli,
            cmd,
            LANG, sn,
            LOGGER)


def get_mapping_info(cli, sn):
    mappingViewList = []
    cmd = "show mapping_view general"
    flag, cli_ret, err_msg = execute_cmd_in_cli_mode(objectForPy, cli, cmd,
                                                     LANG, sn, LOGGER)
    tmpResDict = getHorizontalCliRet(cli_ret)
    for tmpDict in tmpResDict:
        mappId = tmpDict.get("Mapping View ID", '')
        if mappId:
            mappingViewList.append(mappId)

    cmdStr = "show mapping_view general mapping_view_id=%s"
    for mappId in mappingViewList:
        cmd = cmdStr % mappId
        flag, cli_ret, err_msg = execute_cmd_in_cli_mode(objectForPy, cli,
                                                         cmd,
                                                         LANG, sn, LOGGER)
        tmpDict = getVerticalCliRet(cli_ret)
        for record in tmpDict:
            lunGroupId = record.get("LUN Group ID")
            hostGroupId = record.get("Host Group ID")
            portGroupId = record.get("Port Group ID")

            cmdStr2 = "show host_group host host_group_id=%s"
            cmd = cmdStr2 % hostGroupId
            flag, cli_ret, err_msg = execute_cmd_in_cli_mode(objectForPy,
                                                             cli,
                                                             cmd,
                                                             LANG, sn,
                                                             LOGGER)
            cmdStr3 = "show lun_group lun lun_group_id=%s"
            cmd = cmdStr3 % lunGroupId
            flag, cli_ret, err_msg = execute_cmd_in_cli_mode(objectForPy,
                                                             cli, cmd,
                                                             LANG, sn,
                                                             LOGGER)

            if portGroupId == "--" or portGroupId == "":
                continue

            cmdStr4 = "show port_group port port_group_id=%s"
            cmd = cmdStr4 % portGroupId
            flag, cli_ret, err_msg = execute_cmd_in_cli_mode(objectForPy,
                                                             cli,
                                                             cmd,
                                                             LANG, sn,
                                                             LOGGER)


def get_mapping_info_v6(cli, sn, lun_id_list):
    """
    先查mapping，如果结果中存在host_group 则继续查host group，
    否则判断是否有多个主机，记录主机就可以了。
    :param cli:
    :param sn:
    :param lun_id_list:
    :return:
    """
    cmd_str = "show mapping general lun_id=%s"
    for lun_id in lun_id_list:
        cmd = cmd_str % lun_id
        flag, cli_ret, err_msg = execute_cmd_in_cli_mode(objectForPy, cli,
                                                         cmd,
                                                         LANG, sn, LOGGER)
        tmpDict = getHorizontalCliRet(cli_ret)
        for record in tmpDict:
            host_id_list = []
            hostGroupId = record.get("Host Group ID")
            portGroupId = record.get("Port Group ID")
            host_id = record.get("Host ID")

            if host_id != "--":
                host_id_list.append(host_id)

            if hostGroupId != "--":
                cmdStr2 = "show host_group host host_group_id=%s"
                cmd = cmdStr2 % hostGroupId
                flag, cli_ret, err_msg = execute_cmd_in_cli_mode(objectForPy,
                                                                 cli,
                                                                 cmd,
                                                                 LANG, sn,
                                                                 LOGGER)
                tmpDict2 = getHorizontalCliRet(cli_ret)
                host_id_list.extend([rec.get("ID") for rec in tmpDict2])

            if portGroupId == "--" or portGroupId == "":
                continue

            cmdStr4 = "show port_group port port_group_id=%s"
            cmd = cmdStr4 % portGroupId
            flag, cli_ret, err_msg = execute_cmd_in_cli_mode(objectForPy,
                                                             cli,
                                                             cmd,
                                                             LANG, sn,
                                                             LOGGER)


def getAllLinkedPortId(cliRet):
    """
    获取所有主机端口
    :param cliRet:
    :return:
    """
    portDict = {}
    ethList = []
    fcList = []
    fcoeList = []
    ethStr = cliRet[cliRet.find("ETH port"):cliRet.find("FC port")]
    if ethStr and "Host Port:" in ethStr:
        tmpResDict = getHorizontalCliRet(ethStr[ethStr.find("Host Port:"):])
        for record in tmpResDict:
            if record.get("ID", ''):
                ethList.append(record.get("ID", ''))

    fcStr = cliRet[cliRet.find("FC port:"):cliRet.find("FCoE port:")]
    if fcStr:
        tmpResDict = getHorizontalCliRet(fcStr)
        for record in tmpResDict:
            if record.get("ID", ''):
                fcList.append(record.get("ID", ''))

    fcoeStr = cliRet[cliRet.find("FCoE port"):cliRet.find("RoCE port")]
    if fcoeStr:
        tmpResDict = getHorizontalCliRet(fcoeStr)
        for record in tmpResDict:
            if record.get("ID", ''):
                fcoeList.append(record.get("ID", ''))

    portDict["FC"] = fcList
    portDict["FCoE"] = fcoeList
    portDict["ETH"] = ethList

    LOGGER.logInfo("portDict:%s" % portDict)
    return portDict


def getHostInfo(devNode, hostList, lunIdDict, cli, errCode, progressDialog, progress):
    """"
    @summary: 查询主机信息
    """
    global defaultString, hasAddedHostInitiatorList, currentProgress
    allHostProgress = progress * 1.0 / 10.0
    detailHostProgress = progress * 8.0 / 10.0
    myPthread = AsynProgress(progressDialog, allHostProgress)
    myPthread.start()
    name = devNode.getDeviceName()
    ip = devNode.getIp()
    sn = devNode.getDeviceSerialNumber()
    p_version = devNode.getProductVersion()
    defaultString = hostLunString
    LOGGER.logInfo("get host info start.name:%s, ip:%s, sn:%s" % (name, ip, sn))
    try:
        if not cli:
            errMsg = common.getMsg(LANG, errCode)
            if not errMsg or "--" in errMsg:
                errMsg = common.getMsg(LANG, "ssh.connect.fail")
            LOGGER.logInfo("get getSSHbyDevNode errMsg:%s." % errMsg)
            myPthread.setStopFlag(True)
            return

        host_info_dict = cache_util.get_host_info_from_config(objectForPy,
                                                              p_version, sn, LOGGER)
        if host_info_dict:
            hostInfoDict = host_info_dict
        else:
            hostInfoDict = getAllHost(cli, sn)

        myPthread.setStopFlag(True)
        host_lun_info_list = cache_util.get_host_lun_info_from_config(
            objectForPy, p_version, sn, LOGGER)
        LOGGER.logInfo("host lun config:{0}".format(len(host_lun_info_list)))
        # 解析config
        if host_lun_info_list:
            common_cache.filter_hyper_host(host_lun_info_list, lunIdDict,
                                           hostInfoDict)
            refreshProgress(progressDialog, detailHostProgress)
        else:
            # 执行命令查询
            hostInfoDict = getHostLunByHostId(cli, sn, hostInfoDict,
                                              lunIdDict, progressDialog,
                                              detailHostProgress)
        LOGGER.logInfo("hy host:{0}".format(hostInfoDict))
        # 查询
        myPthread = AsynProgress(progressDialog, allHostProgress)
        myPthread.start()

        # iscsi启动器因为脱敏无法获取iqn，需使用命令查询。FC使用config
        fc_ini_dict = cache_util.get_fc_ini_from_config(objectForPy,
                                                        p_version, sn, LOGGER)
        if fc_ini_dict:
            # 融合存储没有fc wwn信息，只能通过命令查询
            common_cache.update_fc_ini(fc_ini_dict, hostInfoDict)
            for host_id in hostInfoDict:
                ini_list = hostInfoDict.get(host_id, {}).get(
                    "initiatorList", [])
                update_host_remote_array_info(ini_list, sn)
        else:
            cmd = "show initiator initiator_type=FC"
            updateInitiatorInfo(cli, sn, cmd, "WWN", hostInfoDict)

        cmd = "show nvme_over_roce_initiator general"
        updateInitiatorInfo(cli, sn, cmd, "NQN", hostInfoDict)

        cmd = "show initiator initiator_type=iSCSI"
        updateInitiatorInfo(cli, sn, cmd, "iSCSI IQN", hostInfoDict)

        myPthread.setStopFlag(True)

        if not host_info_dict:
            # 查询主机,Access\sMode,HyperMetro\sPath\sOptimized
            cli_ret, info_dict_list = cache_util.get_host_info_dorado_v6(
                objectForPy, cli, LANG, sn, LOGGER)
            if info_dict_list:
                update_host_initiator_mode_info(hostInfoDict, sn,
                                                info_dict_list, cli_ret)
        else:
            # 如果config中存在数据，则使用config中的数据。
            ret = "Get host information from config.txt."
            update_initiator_mode_info_config(hostInfoDict, sn, ret)
        # 更新未添加的主机信息
        LOGGER.logInfo("hyper hostInfoDict:{0}".format(hostInfoDict))
        update_mem_not_added_host(hostInfoDict, devNode, hostList, sn)

    except UnCheckException, unCheckException:
        LOGGER.logError(str(traceback.format_exc()))
    except:
        LOGGER.logError(str(traceback.format_exc()))


def update_mem_not_added_host(host_info_dict, dev_node, host_list, sn):
    """
    更新未添加的主机信息
    :param host_info_dict:
    :param dev_node:
    :param host_list:
    :param sn:
    :return:
    """
    global MEM_INFO_HOST_QUO
    hostInfoList = dev_node.getHostInfo()
    hostLauncherWwnList = py_java_env.get("hostLauncherWwnList")
    tmp_not_added_host_list = []
    for hostId in host_info_dict:
        iniList = host_info_dict[hostId].get("initiatorList")
        if not iniList:
            continue

        wwnStr = ",".join(host_info_dict[hostId].get("initiatorList"))
        # 存取所有设备的启动器wwn信息，将阵列测的启动器信息存放到巡检上下文中
        hostLauncherWwnList.add(wwnStr)
        name = host_info_dict[hostId].get("name")

        addHostResult(host_list, name, wwnStr, sn)

        # 是否是已添加的主机
        tmpList = []
        for iniWwn in iniList:
            if iniWwn not in hasAddedHostInitiatorList:
                tmpList.append(iniWwn)
        LOGGER.logInfo(
            "hostId:%s, tmpList:%s,AddedList:%s,sn:%s" % (
                hostId, tmpList, hasAddedHostInitiatorList, sn))
        if tmpList:
            hostInfoList.add((name, ",".join(tmpList), sn))
            host_type = host_info_dict[hostId].get("operSys", '--')
            # kunpeng 是Vmware ESX m小写，其他事VMware ESX M大写。
            host_type = host_type.replace("_", " ")
            if host_type.lower() == "vmware esx":
                host_type = "VMware ESX"
            tmp_not_added_host_list.append({
                "hostName": name,
                "hostType": host_type,
                "sn": sn,
                "initiator": ",".join(tmpList),
                # 是否使用华为多路径确认结果0 未确认，1 是， 2 否。
                "isUseUtrapath": 0,
                # 是否单边组网确认结果：0 未确认，1 是， 2 否。
                "isSingleNet": 0,
                # 主机类型确认结果：0 未确认，1 正确， 2 错误。
                "hostTypeCheckRet": 0
            })
    LOGGER.logInfo("not added host SN{0}:{1}".format(
        sn, str(tmp_not_added_host_list)))
    if tmp_not_added_host_list:
        put_not_added_host(MEM_INFO_HOST_QUO, tmp_not_added_host_list)


def update_host_initiator_mode_info(host_dict, array_sn, mode_info_list,
                                    cli_ret):
    """更新主机启动器的access mode和hyper path 信息
    :param host_dict: 当前阵列双活主机信息
    :param array_sn: 阵列SN
    :param mode_info_list: 当前阵列上的主机mode信息
    :param cli_ret: 回文
    :return: 无
    """
    global ARRAY_INITIATOR_INFO
    with MUTEX_QUO_SERVER_INFO:
        array_dict = ARRAY_INITIATOR_INFO.get(array_sn, {})
        ini_info_dict = array_dict.get("initiator_info", {})
        for host_mode_info in mode_info_list:
            host_id = host_mode_info.get("ID")
            access_mode = host_mode_info.get("Access Mode")
            opti = host_mode_info.get("HyperMetro Path Optimized")
            tmp_host_info = host_dict.get(host_id, {})
            initiator_list = tmp_host_info.get("initiatorList", [])
            for ini in initiator_list:
                # 找到启动器对应的主机SN
                tmp_array_dict = ini_info_dict.get(ini, {})
                tmp_array_dict["access_mode"] = access_mode
                tmp_array_dict["hyper_path_opt"] = opti
                ini_info_dict[ini] = tmp_array_dict
        array_dict["cli_ret"] = cli_ret
        array_dict["initiator_info"] = ini_info_dict
        ARRAY_INITIATOR_INFO[array_sn] = array_dict


def update_initiator_mode_info_config(host_dict, array_sn, cli_ret):
    """从config中获取信息，更新主机启动器的access mode和hyper path 信息
    :param host_dict: 当前阵列双活主机信息
    :param array_sn: 阵列SN
    :param cli_ret: 回文
    :return: 无
    """
    global ARRAY_INITIATOR_INFO
    with MUTEX_QUO_SERVER_INFO:
        array_dict = ARRAY_INITIATOR_INFO.get(array_sn, {})
        ini_info_dict = array_dict.get("initiator_info", {})
        for host_id in host_dict:
            tmp_host_info = host_dict.get(host_id, {})
            access_mode = tmp_host_info.get("Access Mode")
            opti = tmp_host_info.get("HyperMetro Path Optimized")
            initiator_list = tmp_host_info.get("initiatorList", [])
            for ini in initiator_list:
                # 找到启动器对应的主机SN
                tmp_array_dict = ini_info_dict.get(ini, {})
                tmp_array_dict["access_mode"] = access_mode
                tmp_array_dict["hyper_path_opt"] = opti
                ini_info_dict[ini] = tmp_array_dict
        array_dict["cli_ret"] = cli_ret
        array_dict["initiator_info"] = ini_info_dict
        ARRAY_INITIATOR_INFO[array_sn] = array_dict


def getAllHost(cli, sn):
    """
    查询全部主机信息
    :param cli:
    :return:
    """
    hostDict = {}
    cmd = "show host general"
    flag, cli_ret, err_msg = execute_cmd_in_cli_mode(objectForPy,
                                                     cli, cmd,
                                                     LANG, sn,
                                                     LOGGER)
    if flag is not True:
        LOGGER.logInfo("Failed to get host_group host:%s" % err_msg)
        raise UnCheckException(common.getMsg(LANG, "cannot.get.info", {"zh": u"主机", "en": "host"}.get(LANG)),
                               "")

    hostDictList = cliUtil.getHorizontalNostandardCliRet(cli_ret)

    for tmpHostDict in hostDictList:
        hostInfoDict = {}
        name = tmpHostDict.get("Name", '')
        hostId = tmpHostDict.get("ID", '')
        operSys = tmpHostDict.get("Operating System", '')
        ipAddr = tmpHostDict.get("IP Address", '')

        if not name or not hostId:
            continue

        hostInfoDict["name"] = name
        hostInfoDict["operSys"] = operSys
        hostInfoDict["ipAddr"] = ipAddr
        hostDict[hostId] = hostInfoDict

    return hostDict


def getHostLunByHostId(cli, sn, hostDict, hyperLunIdDict, progressDialog, detailHostProgress):
    hostLen = len(hostDict)
    if hostLen == 0:
        hostLen = 1
    detailHost = detailHostProgress / hostLen
    hostIdList = hostDict.keys()
    for hostId in hostIdList:
        cmd = "show host lun host_id=%s" % hostId
        flag, cli_ret, err_msg = execute_cmd_in_cli_mode(objectForPy,
                                                         cli, cmd,
                                                         LANG, sn,
                                                         LOGGER)
        refreshProgress(progressDialog, detailHost)
        if flag is not True:
            LOGGER.logInfo("Failed to get host:%s" % err_msg)
            raise UnCheckException(common.getMsg(LANG, "cannot.get.info", {"zh": u"主机", "en": "host"}.get(LANG)),
                                   "")

        hostDictList = getHorizontalCliRet(cli_ret)

        hostHyperLunList = []
        for tmpHostDict in hostDictList:
            lunId = tmpHostDict.get("LUN ID", '')
            if lunId in hyperLunIdDict:
                hostHyperLunList.append(lunId)

        if not hostHyperLunList:
            hostDict.pop(hostId)

    return hostDict


def getMappedHypermetroLun(devNode, allStrgHyprMtrLns, cli, progressDialog, progress):
    """
    @summary: 查询映射的双活LUN。
    """
    global currentProgress
    name = devNode.getDeviceName()
    ip = devNode.getIp()
    sn = devNode.getDeviceSerialNumber()
    p_version = devNode.getProductVersion()
    LOGGER.logInfo("get mapped lun start ip:%s" % ip)

    try:

        partProgress = progress / 10.0
        myPthread = AsynProgress(progressDialog, partProgress)
        myPthread.start()

        cmdHyper = "show hyper_metro_pair general |filterRow column=Type predict=equal_to value=LUN |filterColumn include columnList=Local\sID,WWN"
        flag_pair, cli_ret, pair_msg = execute_cmd_in_cli_mode(objectForPy,
                                                               cli, cmdHyper,
                                                               LANG, sn,
                                                               LOGGER)

        LOGGER.logInfo("show hyper metro pair lun: %s" % flag_pair)
        myPthread.setStopFlag(True)
        if flag_pair is not True:
            return {}, cli_ret, flag_pair, pair_msg

        wwnDict = {}
        lunIdDict = {}
        lunIdList = []
        hyperMetroLunDictList = cliUtil.getHorizontalNostandardCliRet4Martiu(
            cli_ret)
        for hyperMetroLun in hyperMetroLunDictList:
            wwn = hyperMetroLun.get("WWN", "")
            lunId = hyperMetroLun.get("Local ID", "")
            lunIdList.append(lunId)
            wwnDict[wwn] = lunId
            lunIdDict[lunId] = wwn

        totalLen = len(lunIdList)
        if totalLen == 0:
            totalLen = 1

        everyLunProgress = progress * 9.0 / 10.0 / totalLen

        # 替换伪装双活LUN的wwn为Takeover LUN WWN.
        take_over_lun = []
        query_cmd_str = "show lun_takeover general"
        try:
            take_ret, take_over_lun = cache_util.get_take_over_lun_cache(
                objectForPy, cli, LANG, sn, LOGGER)
        except UnCheckException as e:
            LOGGER.logException(e)

        # 使用缓存中的config数据
        lun_info_dict_list = cache_util.get_lun_info_from_config(
            objectForPy, LOGGER, sn)
        LOGGER.logInfo("get lun from config length:{0}".format(
            len(lun_info_dict_list)))
        # 如果存在缓存数据则使用缓存数据。
        if lun_info_dict_list:
            for lun_info in lun_info_dict_list:
                # 确认该字段在融合存储和dorado v6的config文件中无差异
                is_mapped = lun_info.get("Exposed To Initiator", "")
                wwn = lun_info.get("WWN", "")
                lunId = lun_info.get("ID", "")
                if is_mapped.lower() != "yes":
                    if lunIdDict.has_key(lunId):
                        lunIdDict.pop(lunId)
                    if wwnDict.has_key(wwn):
                        wwnDict.pop(wwn)
            refreshProgress(progressDialog, everyLunProgress * totalLen)
        else:
            # 使用命令直接查询
            for lunId in lunIdList:
                cmd = "show lun general lun_id=%s" % lunId
                flag, cli_ret_2, err_msg = execute_cmd_in_cli_mode(objectForPy,
                                                                   cli, cmd,
                                                                   LANG, sn,
                                                                   LOGGER)
                refreshProgress(progressDialog, everyLunProgress)
                lunInfoDictList = getVerticalCliRet(cli_ret_2)
                for lunInfo in lunInfoDictList:
                    isMapped = lunInfo.get("Exposed To Initiator", "")
                    wwn = lunInfo.get("WWN", "")
                    if isMapped.lower() != "yes":
                        if lunId in lunIdDict:
                            lunIdDict.pop(lunId)
                        if wwn in wwnDict:
                            wwnDict.pop(wwn)



        if wwnDict:
            # 如果异构LUN存在则替换为异构LUN接管后的WWN
            for t_lun in take_over_lun:
                local_wwn = t_lun.get("WWN", "")
                t_lun_wwn = t_lun.get("Takeover LUN WWN", "")
                if local_wwn not in wwnDict:
                    continue

                tmp_id = wwnDict.get(local_wwn, "")
                wwnDict.pop(local_wwn)
                wwnDict[t_lun_wwn] = tmp_id

            putLunMappedResult(allStrgHyprMtrLns, wwnDict, sn)

            # 放入缓存中
            mappedHyperMetroLun = devNode.getAllStrgHyprMtrLns()
            putLunMappedMem(mappedHyperMetroLun, wwnDict, sn)

        return lunIdDict, cli_ret, flag_pair, pair_msg
    except:
        LOGGER.logError(str(traceback.format_exc()))
        err_key = "query.result.abnormal"
        return {}, '', cliUtil.RESULT_NOCHECK, common.getMsg(LANG, err_key)


def checkRemoreDevice(devNode, inspectDevSNList, allDevSNList, resultList, snList):
    """
    @summary: 检查用户是否已添加当前设备的远程设备。
    @param devNode: 当前设备DevNode.java对象，包含了设备IP,SN,系统软件版本,设备类型等信息。
    @param inspectDevSNList: 用户添加的所有执行巡检的设备SN。
    @param allDevSNList: 用户添加的所有设备（执行巡检+不巡检的设备）SN。
    @param resultList: 所有设备检查结果缓存list。
    """
    name = devNode.getDeviceName()
    ip = devNode.getIp()
    sn = devNode.getDeviceSerialNumber()
    try:
        # 检查远程是否是否添加到工具中
        if not snList:
            return

        flag, errMsg = checkRemoteDevice(snList, inspectDevSNList, allDevSNList)
        if not flag:
            addResult(resultList, name, ip, sn, errMsg)
            LOGGER.logInfo("current device is (ip:%s, sn:%s), check remote device result is %s." % (ip, sn, errMsg))

    except Exception, exception:
        LOGGER.logException(exception)
        errMsg = common.getMsg(LANG, "ssh.connect.fail")
        addResult(resultList, name, ip, sn, errMsg)


def getRemoteDeviceSNs(devNode, cli, errCode):
    """
    @summary: 获取设备关联的双活远程设备的sn。目前（201803）双活业务只有一台远程设备，后续可能扩展为多台。产品设计上限64台。
    """
    # 先从框架缓存中获取设备所有的远程设别SN。（在用户已经添加有设备后再次添加设备执行“下一步”时，不用重复到阵列获取，用以提升效率。但两次添加设备之间远程设备发生变化无法感知）
    snList = common.getRemoteSNsFromDevNode(devNode)
    if snList != None:
        return (True, snList, "")

    if not cli:
        errMsg = common.getMsg(LANG, errCode)
        if not errMsg or "--" in errMsg:
            errMsg = common.getMsg(LANG, "ssh.connect.fail")
        return (False, None, errMsg)

    # 从阵列获取双活远程设备SN
    flag, _, errMsg, snList = common.getHyperMetroRemoteDeviceSn(cli, LANG)
    if flag == common.FLAG_FAIL:
        return (False, None, errMsg)

    return (True, snList, "")


def checkRemoteDevice(remoteDeviceSnList, inspectDevSNList, allDevSNList):
    """
    @summary: 检查用户是否巡检远程双活设备
    @param remoteDeviceSnList: 远程设备SN
    @param inspectDevSNList: 用户添加的所有执行巡检的设备SN。
    @param allDevSNList: 用户添加的所有设备（执行巡检+不巡检的设备）SN。
    """
    # 用户未添加的远程设备
    notAddRemoteDeviceList = []
    # 用户已添加远程设备到工具但未选择该设备执行巡检
    notInspectRemoteDeviceList = []

    for remoteSn in remoteDeviceSnList:
        if remoteSn not in allDevSNList:
            notAddRemoteDeviceList.append(remoteSn)

        if (remoteSn in allDevSNList) and (remoteSn not in inspectDevSNList):
            notInspectRemoteDeviceList.append(remoteSn)

    errMsg = ""

    if notAddRemoteDeviceList:
        errMsg += ",".join(notAddRemoteDeviceList)

    if notInspectRemoteDeviceList:
        errMsg += ",".join(notInspectRemoteDeviceList)

    if errMsg:
        return (False, errMsg)

    return (True, "")


def getSNs(devNodes):
    """
    @summary: 获取设备的SN
    """
    return [common.getSnFromDevNode(devNode) for devNode in devNodes]


def updateInitiatorInfo(cli, sn, cmd, wwnType, hostInfoDict):
    flag, cli_ret, err_msg = execute_cmd_in_cli_mode(objectForPy,
                                                     cli, cmd,
                                                     LANG, sn,
                                                     LOGGER)
    if not cliUtil.hasCliExecPrivilege(cli_ret):
        return

    if flag is not True:
        LOGGER.logInfo("Failed initiator errMsg:%s" % err_msg)
        raise UnCheckException(err_msg)

    initiatorDictList = getHorizontalCliRet(cli_ret)
    for tmpInitiatorDict in initiatorDictList:
        wwn = tmpInitiatorDict.get(wwnType, '')
        host_id = tmpInitiatorDict.get("Host ID", '')
        if host_id == "--" or host_id not in hostInfoDict:
            continue

        tmp_dict = hostInfoDict.get(host_id, {})
        initiatorList = tmp_dict.get("initiatorList", [])
        initiatorList.append(wwn)
        tmp_dict["initiatorList"] = initiatorList
        hostInfoDict[host_id] = tmp_dict
        # 更新 主机SN和阵列的关联关系。
        update_host_remote_array_info(initiatorList, sn)


def update_host_remote_array_info(ini_list, array_sn):
    global HOST_MAPPED_ARRAY_SN
    with MUTEX_QUO_SERVER_INFO:
        for host_sn in HOST_MAPPED_ARRAY_SN:
            tmp_dict = HOST_MAPPED_ARRAY_SN.get(host_sn, {})
            # 找到启动器对应的主机SN
            tmp_ini_list = tmp_dict.get("ini_list", [])
            tmp_list = [ini for ini in ini_list if ini in tmp_ini_list]
            if not tmp_list:
                continue

            sn_list = tmp_dict.get("array_sn", [])
            sn_list.append(array_sn)
            sn_list = list(set(sn_list))
            tmp_dict["array_sn"] = sn_list
            HOST_MAPPED_ARRAY_SN[host_sn] = tmp_dict


CLI_RET_END_FLAG = ":/>"


def getVerticalCliRet(cliRet):
    '''
    @summary: 按逐行字典的方式获取垂直表格形式的cli回显集合
    @param cliRet: cli回显
    @return: 将表格形式cli回显处理为以表头为key，以项值为键的字典集合,处理不正常时，返回空集合
    '''
    import re
    cliRetList = cliRet.encode("utf8").splitlines()
    dictList = []
    lineDict = {}
    for line in cliRetList:
        if CLI_RET_END_FLAG in line:
            break

        if re.search("^-+\r*\n*$", line):
            dictList.append(lineDict.copy())
            lineDict.clear()

        fields = line.split(" : ")
        if len(fields) < 2:
            continue

        key = fields[0].strip().decode("utf8")
        value = ":".join(fields[1:len(fields)]).strip().decode("utf8")

        if lineDict.has_key(key):
            key += "_" + str(str(lineDict.keys()).count(key + "_") + 1)
        lineDict.setdefault(key, value)

    if len(lineDict) > 0:
        dictList.append(lineDict.copy())

    return dictList


def getHorizontalCliRet(cliRet):
    '''
    @summary: 按逐行字典的方式获取水平表格形式的cli回显集合
    @param cliRet: cli回显
    @return: 将表格形式cli回显处理为以表头为key，以项值为键的字典集合,处理不正常时，返回空集合
    '''
    import re
    try:
        headline = ""
        i = 0
        cliRetList = cliRet.encode("utf8").splitlines()
        for line in cliRetList:
            reg_headline = re.compile("^\s*-+(\s+-+)*\s*$")
            match_headline = reg_headline.search(line)
            if match_headline:
                headline = match_headline.group()
                break
            i += 1
        if headline == "" or i == 0 or i >= len(cliRetList) - 1:
            return []

        title = cliRetList[i - 1]
        field_words = cliRetList[(i + 1):]
        reg_split = re.compile("\s*-+\s*")
        tuple_idxs = []
        start_pos = 0
        end_pos = 0

        while (start_pos <= len(headline)):
            match = reg_split.search(headline, start_pos)
            if match:
                end_pos = match.end()
                tuple_idxs.append((start_pos, end_pos))
                start_pos = end_pos
            else:
                break

        keys = []
        for item in tuple_idxs:
            key = title[item[0]:item[1]].strip()
            if keys.count(key):
                key += "_" + str(str(keys).count(key + "_") + 1)
            keys.append(key.decode("utf8"))

        requiredLineLen = tuple_idxs[-1][0]
        dictList = []
        for line in field_words:
            if CLI_RET_END_FLAG in line:
                break

            # 标题换行的场景
            if re.search("^-+(\s+-+)*\s*$", line):
                continue

            if len(line.strip()) == 0:
                continue

            if len(line) <= requiredLineLen:
                continue

            vals = []
            for item in tuple_idxs:
                vals.append(line[item[0]:item[1]].strip().decode("utf8"))
            dictList.append(dict(zip(keys, vals)))

        return dictList
    except Exception, exception:
        LOGGER.logException(exception)
        return []


def addResult(resultList, name, ip, sn, errMsg):
    """
    @summary: 线程互斥方式将结果添加到resultList中。
    """
    with MUTEX:
        if (name, ip, sn, errMsg) not in resultList:
            resultList.append((name, ip, sn, errMsg))


def addHostResult(hostList, name, wwn, sn):
    """
    @summary: 线程互斥方式将结果添加到resultList中。
    """
    with MUTEX_HOST:
        if (name, wwn, sn) not in hostList:
            hostList.append((name, wwn, sn))


def addHostResultFromMem(hostList, hostInfo):
    """
    @summary: 线程互斥方式将结果添加到resultList中, 从缓存中取值。
    """
    with MUTEX_HOST:
        if hostInfo not in hostList:
            hostList.append(hostInfo)


def putLunMappedResult(allStrgHyprMtrLns, wwnDict, sn):
    with MUTEX_MAPPED_LUN:
        for wwn in wwnDict:
            lunId = wwnDict[wwn]
            if allStrgHyprMtrLns.get(wwn):
                snStr = allStrgHyprMtrLns.get(wwn).get("deviceSn")
                if snStr and sn not in snStr and allStrgHyprMtrLns.get(wwn).get("lunId"):
                    snStr = snStr + "," + sn
                    lunIdStr = allStrgHyprMtrLns.get(wwn).get("lunId") + "," + lunId
                    allStrgHyprMtrLns.put(wwn, {"deviceSn": snStr, "hostAluaStatus": 0, "lunId": lunIdStr})
                    continue

            allStrgHyprMtrLns.put(wwn, {"deviceSn": sn, "hostAluaStatus": 0, "lunId": lunId})


def put_quo_server_num(mem_info_host_quo, tmpServerDictList):
    with MUTEX_QUO_SERVER_INFO:
        tmp_server_dict_list = mem_info_host_quo.get(QUO_SERVER_LIST, [])

        # 避免重复
        for server_dict in tmpServerDictList:
            if server_dict in tmp_server_dict_list:
                continue

            is_the_same_server = False
            # 以IP去重
            for tmp_server_dict in tmp_server_dict_list:
                if tmp_server_dict.get("ip", '--') != "--" and \
                        server_dict.get("ip", '') == tmp_server_dict.get("ip", ''):
                    is_the_same_server = True
                    if _check_is_contain_property(server_dict.get("quoServerName", ""),
                                                  tmp_server_dict.get("quoServerName", "")) and \
                            _check_is_contain_property(server_dict.get("sn", ""),
                                                       tmp_server_dict.get("sn", "")):
                        break

                    # 格式说明:server x(server y,server z)
                    if "(" not in tmp_server_dict.get("quoServerName", ""):
                        tmp_server_dict["quoServerName"] += "(" + server_dict.get("quoServerName") + ")"
                    else:
                        tmp_server_dict["quoServerName"] = tmp_server_dict.get(
                            "quoServerName",
                            "").replace(")", "") + "," + server_dict.get(
                            "quoServerName", "") + ")"

                    # 格式说明：sn1,sn2,sn3
                    tmp_sn_list = tmp_server_dict.get("sn", "").split(",")
                    tmp_sn_list.append(server_dict.get("sn", ""))
                    tmp_server_dict["sn"] = ",".join(list(set(tmp_sn_list)))

            if not is_the_same_server:
                tmp_server_dict_list.append(server_dict)

        mem_info_host_quo[QUO_SERVER_LIST] = tmp_server_dict_list


def put_not_added_host(mem_info_host_quo, tmp_host_dict_list):
    with MUTEX_QUO_SERVER_INFO:
        not_added_host_list = mem_info_host_quo.get(NOT_ADD_HOST_LIST, [])
        for host_info in tmp_host_dict_list:
            if host_info in not_added_host_list:
                continue

            is_the_same_host = False
            for tmp_host_info in not_added_host_list:
                if host_info.get("hostType", '').lower() != \
                        tmp_host_info.get("hostType", '').lower():
                    continue

                # 避免重复添加并展示。
                if check_ini_is_same(host_info, tmp_host_info) is True:
                    is_the_same_host = True
                    # 已经添加到缓存中。
                    if _check_is_contain_property(host_info.get("hostName", ""),
                                                  tmp_host_info.get("hostName", "")) and \
                            _check_is_contain_property(host_info.get("sn", ""),
                                                       tmp_host_info.get("sn", "")):
                        break

                    # 处理 host0 : abc; host1 ： abc,def 和 场景：host0 : abc,def; host1 ： abc场景。
                    tmp_list = host_info.get("initiator", "").split(",")
                    tmp_list.extend(tmp_host_info.get("initiator", "").split(","))
                    tmp_host_info["initiator"] = ",".join(list(set(tmp_list)))

                    # 格式说明:host x(host y,host z)
                    if "(" not in tmp_host_info.get("hostName", ""):
                        tmp_host_info["hostName"] += "(" + host_info.get("hostName") + ")"
                    else:
                        tmp_host_info["hostName"] = tmp_host_info.get(
                            "hostName", "").replace(")",
                                                    "") + "," + host_info.get(
                            "hostName", "") + ")"

                    # 格式说明：sn1,sn2,sn3
                    tmp_sn_list = tmp_host_info.get("sn", "").split(",")
                    tmp_sn_list.append(host_info.get("sn", ""))
                    tmp_host_info["sn"] = ",".join(list(set(tmp_sn_list)))
                    break

            if not is_the_same_host:
                not_added_host_list.append(host_info)

        mem_info_host_quo[NOT_ADD_HOST_LIST] = not_added_host_list


def check_ini_is_same(host_info, tmp_host_info):
    """
    检查启动器是否重复
    :param host_info:
    :param tmp_host_info:
    :return:
    """
    a_ini_list = host_info.get("initiator", "").split(",")
    b_ini_listr = tmp_host_info.get("initiator", "").split(",")
    for a_ini in a_ini_list:
        if a_ini not in b_ini_listr:
            return False
    return True


def _check_is_contain_property(value_a, value_b, seprator=","):
    """
    工具方法，由于比较值是否存在于某个字典中
    :param value: 比较值
    :param value_list: 待比较值
    :return: 结果 True 包含， False 不包含。
    """
    tmp_value_list = value_b.replace("(", ",").replace(")", "").split(seprator)
    return value_a in tmp_value_list


def putLunMappedMem(allStrgHyprMtrLns, wwnDict, sn):
    for wwn in wwnDict:
        lunId = wwnDict[wwn]
        if allStrgHyprMtrLns.get(wwn):
            snStr = allStrgHyprMtrLns.get(wwn).get("deviceSn")
            if snStr and sn not in snStr and allStrgHyprMtrLns.get(wwn).get("lunId"):
                snStr = snStr + "," + sn
                lunIdStr = allStrgHyprMtrLns.get(wwn).get("lunId") + "," + lunId
                allStrgHyprMtrLns.put(wwn, {"deviceSn": snStr, "hostAluaStatus": 0, "lunId": lunIdStr})
                continue

        allStrgHyprMtrLns.put(wwn, {"deviceSn": sn, "hostAluaStatus": 0, "lunId": lunId})


def refreshProgress(progressDialog, progress):
    with MUTEX_PROGRESS:
        global currentProgress
        try:
            currentProgress += progress
            if int(currentProgress) < 100:
                progressDialog.updateProgressText(defaultString + str(int(currentProgress)) + "%")
        except:
            LOGGER.logError(str(traceback.format_exc()))


class AsynProgress(threading.Thread):
    """
    异步刷新线程
    当某个命令执行需要很久时，考虑使用。刷新时间定为0.1秒能更好、更快的反应关掉线程。
    可选参数说明：
    currentProgress 当前起始进度。
    endProgress：预计结束进度。
    """

    def __init__(self, progressDialog, stepProgress=1):
        threading.Thread.__init__(self)
        self.stopFlg = False
        self.stepProgress = stepProgress
        self.currentProgress = 0
        self.progressDialog = progressDialog

    def run(self):
        tmp = 1
        while self.currentProgress <= self.stepProgress and not self.stopFlg:
            if tmp >= 1:
                refreshProgress(self.progressDialog, int(tmp))
                tmp = 0
            self.currentProgress += 0.1
            tmp += 0.1
            time.sleep(0.5)

    def setStopFlag(self, stopFlag):
        if self.currentProgress < self.stepProgress:
            refreshProgress(self.progressDialog, int(self.stepProgress - self.currentProgress))
        self.stopFlg = stopFlag
