# -*- coding: UTF-8 -*-
import cliUtil
import common
import config

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

def execute(cli):
    '''
        紧急级别告警检查： 
                如果不存在Level为Critical的告警属于正常，否则属于不正常状态。
    '''
    flag = True
    cliRet = ""
    errMsg = ""

    try:
        cmd = "show alarm level=critical number=10"
        if common.isExpansionCapacityScenePreInspect(py_java_env):
            excludeAlarms = "\|".join(config.EXPANSION_EXCLUDE_ALARM)
            cmd = "show alarm level=critical |filterRow column=ID predict=not predict2=match value=(%s)" % excludeAlarms
        LOGGER.logExecCmd(cmd)
        checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        if checkRet[0] != True and "----" not in checkRet[1]:
            LOGGER.logSysAbnormal()
            return checkRet
        
        cliRet = checkRet[1]
        if cliUtil.queryResultWithNoRecord(cliRet):
            return (True, cliRet, errMsg)
        
        cliRetLinesList = cliUtil.getHorizontalCliRet(cliRet)
        
        flag = False
        if len(cliRetLinesList) == 0:
            errMsg = common.getMsg(LANG, "cannot.get.alarm.info")
            LOGGER.logNoPass("Cannot get information about alarm")
        else:
            errMsg = common.getMsg(LANG, "system.exists.critical.alarm")
            LOGGER.logNoPass("System exists critical alarm")
            
        return (flag, cliRet, errMsg)
        
    except Exception, exception:
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, cliRet, common.getMsg(LANG, "query.result.abnormal"))
