# -*- coding:utf-8 -*-
import traceback

from com.huawei.ism.exception import IsmException
from com.huawei.ism.tlv.lang import UnsignedInt32
from com.huawei.ism.tool.protocol.tlv.exception import TLVException

import cliUtil
import common
from frameone.util import contextUtil
from frameone.rest import restData
from frameone.rest.restUtil import Tlv2Rest
from config import DORADO_DEVS_V3

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
CMDNOTEXIST_ERRORCODE = 1077949002
TIMEOUT_ERRORCODE = 1077949001
ALL_CLI = ''
PY_JAVA_ENV = py_java_env


def execute(cli):
    global ALL_CLI
    # noinspection PyBroadException
    try:
        context = contextUtil.getContext(PY_JAVA_ENV)
        checker = IsUserDelUrgAlarm(context, cli)
        return checker.execute()
    except Exception:
        LOGGER.logError(traceback.format_exc())
        return cliUtil.RESULT_NOCHECK, ALL_CLI, common.getMsg(LANG, 'query.result.abnormal')


class IsUserDelUrgAlarm():
    def __init__(self, context, cli):
        self.cli = cli
        self.context = context
        self.type = contextUtil.getDevType(context)
        self.originInfos = ""
        self.errMsg = ""

    def execute(self):
        try:
            if str(self.type) in DORADO_DEVS_V3:
                flag, ret, msg = self.check_dorado_v3()
            else:
                flag, ret, msg = self.check_v300()
            if flag is not True:
                return cliUtil.RESULT_WARNING if common.is_opening_delivery_inspect(PY_JAVA_ENV) else flag, ret, msg
            return True, ret, msg
        except Exception:
            LOGGER.logInfo("[ISUserDelUrgAlarm] excute exception:[%s]" % traceback.format_exc())
            self.errMsg = common.getMsg(LANG, 'query.result.abnormal')
            return cliUtil.RESULT_NOCHECK, self.originInfos, self.errMsg

    def check_v300(self):
        global ALL_CLI
        cmd_querydelalarm = "show event status=cleared |filterRow column=Level predict=match value=Major " \
                            "logicOp=or column=Level predict=match value=Critical"
        status, cliRet, errMsg = cliUtil.excuteCmdInCliMode(self.cli, cmd_querydelalarm, True, LANG)
        ALL_CLI = common.joinLines(ALL_CLI, cliRet)
        self.originInfos += cliRet
        if cliUtil.queryResultWithNoRecord(cliRet):
            return True, self.originInfos, ''
        if "----" in cliRet:
            cliRetLinesList = cliUtil.getHorizontalCliRet(cliRet)
            if len(cliRetLinesList) > 0:
                # 开局巡检，存在手动删除告警，检查结果为建议优化，日常巡检为不通过
                result_status = cliUtil.RESULT_WARNING if common.is_opening_delivery_inspect(
                    PY_JAVA_ENV) else False
                self.errMsg = common.getMsg(
                    LANG, "check.ISUserDelUrgAlarm.notpass"
                )
                return result_status, self.originInfos, self.errMsg
            else:
                return True, self.originInfos, ''
        if status is not True:
            return status, self.originInfos, errMsg
        return False, self.originInfos, common.getMsg(LANG, "check.ISUserDelUrgAlarm.notpass")

    def check_dorado_v3(self):
        """
        通过rest接口实现
        """
        conn = contextUtil.getRest(self.context)
        isPass, result = self.executeAlarmCheckTLVCmd(conn)
        try:
            if conn:
                conn.close()
            LOGGER.logInfo("conn close success!")
        except Exception as e:
            LOGGER.logInfo("conn close except:%s" % str(e))
        LOGGER.logInfo("[ISUserDelUrgAlarm] result is %s." % result)
        if result == CMDNOTEXIST_ERRORCODE:
            LOGGER.logInfo("[ISUserDelUrgAlarm] command not exist.")
            return True, self.originInfos, ''
        evalResult = Tlv2Rest.getRecordValue(result, restData.Upgrade.UrgentAlmCleared.URGENT_ALM_RESULT)
        LOGGER.logInfo("[ISUserDelUrgAlarm] evalResult is %s." % evalResult)
        if evalResult == TIMEOUT_ERRORCODE:
            self.errMsg = common.getMsg(LANG, "check.result.timeout")
            return cliUtil.RESULT_NOCHECK, self.originInfos, self.errMsg
        elif evalResult.lower() == "true":
            self.errMsg = common.getMsg(LANG, "check.ISUserDelUrgAlarm.notpass")
            key = "wether.deleted.alarm.not.pass"
            self.originInfos = common.joinLines(
                self.originInfos, common.getMsg(LANG, key))
            # 开局巡检，存在手动删除告警，检查结果为建议优化，日常巡检为不通过
            result_status = cliUtil.RESULT_WARNING if common.is_opening_delivery_inspect(PY_JAVA_ENV) else False
            return result_status, self.originInfos, self.errMsg
        elif evalResult.lower() == "false":
            key = "wether.deleted.alarm.pass"
            self.originInfos = common.joinLines(
                self.originInfos, common.getMsg(LANG, key))
            return True, self.originInfos, ''
        else:
            self.errMsg = common.getMsg(LANG, "check.anyItem.exception.common")
            return cliUtil.RESULT_NOCHECK, self.originInfos, self.errMsg

    def executeAlarmCheckTLVCmd(self, conn):
        global ALL_CLI
        locationId = UnsignedInt32(65533)
        isSuc = False
        msgParam13 = (restData.Upgrade.UrgentAlmCleared.CMO_ALARM_LOCATION, locationId)
        params = [msgParam13]
        self.originInfos += "command Code(Rest): " + \
                            str(restData.TlvCmd.GET_IS_EXIST_URGENT_ALM_CLEARED.get("cmd")) + "\n"
        try:
            recs = Tlv2Rest.execCmd(conn, restData.TlvCmd.GET_IS_EXIST_URGENT_ALM_CLEARED, params)
            recs = recs[0]
            isSuc = True
            self.originInfos += "result: " + str(recs) + "\n"
            LOGGER.logInfo("[IsUserDelUrgAlarm]recsValue=%s,type(recsValue)=%s" % (str(recs), type(recs)))
        except (TLVException, IsmException) as msg:
            LOGGER.logInfo("[IsUserDelUrgAlarm]ErrorCode we got using Rest Con was %s." % msg.getErrorId())
            recs = msg.getErrorId()
            self.originInfos += "result: " + str(recs) + "\n"
        ALL_CLI = common.joinLines(ALL_CLI, self.originInfos)
        return isSuc, recs
