# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.

import common
import cliUtil
from common_utils import get_dpa_rest_record
import dpa_common

PY_JAVA_ENV = py_java_env
LANG = common.getLang(PY_JAVA_ENV)
LOGGER = common.getLogger(PY_LOGGER, __file__)


def execute(dpa_rest):
    record = ""
    try:
        node_query_uri = "/storageresmgm/application/volumes?count=1000&index=0"
        record = get_dpa_rest_record(dpa_rest, node_query_uri)
        volume_data = record.get("responseData", {}).get("data", [])
        err_msg = [common.getMsg(LANG, "dpa.backup.volume.status.abnormal", volume.get("name").decode("unicode_escape"))
                   for volume in volume_data
                   if volume.get("status") != 2]
        if err_msg:
            return False, record, "".join(err_msg)
        return True, record, ""
    except Exception as e:
        LOGGER.logError(str(e))
        return cliUtil.RESULT_NOCHECK, record, common.getMsg(LANG, "query.result.abnormal")
