# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.

import common
from common_utils import get_dpa_rest_record

PY_JAVA_ENV = py_java_env
LANG = common.getLang(PY_JAVA_ENV)
LOGGER = common.getLogger(PY_LOGGER, __file__)


def execute(dpa_rest):
    node_query_uri = "/backups/backup_job/instances?backupType=&count=10&index=0&is_all=1&status=1,2,4,256,512"
    record = get_dpa_rest_record(dpa_rest, node_query_uri)
    job_list = record.get("responseData", {}).get("data", [{}])
    if job_list:
        LOGGER.logNoPass("There are unfinished and unsuccessful backup tasks.")
        return False, record, common.getMsg(LANG, "dpa.base.running.job.abnormal")
    return True, record, ""

