# -*- coding: UTF-8 -*-
import cliUtil
import common

'''
双活裁剪型号进行LUN扩容会挂死系统
'''
LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

VERSION = {"V300R006C10":"V300R006C20", "V300R006C10SPC100":"V300R006C20", "V500R007C00":"V500R007C10", "V500R007C00SPC100":"V500R007C10"}
PRODUCT_MODEL = ["2200 V3","2600 V3 for Video","2800 V5"]

def execute(cli):
    cliRet = ""
    errMsg = ""

    try:
        devInfo = common.getCurDeviceInfo(py_java_env)
        productModel = str(devInfo.getDeviceType())
        LOGGER.logInfo("[check_item_exp_lun]the current device=%s"%productModel)
        if productModel not in PRODUCT_MODEL:
            return (True, "" ,"")
        
        #获取设备当前产品版本和补丁信息
        checkRet, currentVersionDictList, __ = common.parse_upgradePackage(cli, LANG)
        cliRet += checkRet[1]
        if checkRet[0] != True:
            LOGGER.logSysAbnormal()
            return (checkRet[0], cliRet ,checkRet[2])
        
        result, currentVersion, errMsg = common.getCurrentVersion(currentVersionDictList, LANG)
        if not result:
            return (False, cliRet ,errMsg)
        
        if currentVersion not in VERSION:
            return (True, cliRet, "")
        else:
            errMsg = common.getMsg(LANG, "exp.lun.sys.ver.error", currentVersion)
            return (False, cliRet, errMsg)
        
        return (True, cliRet, "")
        
    except Exception, exception:
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, cliRet, common.getMsg(LANG, "query.result.abnormal"))


    