# -*- coding: UTF-8 -*-
import cliUtil
import common
import hardware

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

def execute(cli):
    '''
    BBU状态检查：
                所有BBU均在位，Health Status为Normal且Running Status为Online、Charging或Discharging表示正常，其它情况均属于不正常状态。
    '''
    flag = True
    #是否上报告警
    warningFlag = False
    cliRet = ""
    cliRetAll = ""
    errMsg = ""

    try:
        cmd = "show bbu general"
        LOGGER.logExecCmd(cmd)
        checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        if checkRet[0] != True:
            LOGGER.logSysAbnormal()
            return checkRet
        
        cliRet = checkRet[1]
        cliRetAll = cliRet
        
        cliRetLinesList = cliUtil.getHorizontalCliRet(cliRet)
        if len(cliRetLinesList) == 0:
            errMsg = common.getMsg(LANG, "cannot.get.bbu.info")
            LOGGER.logNoPass("Cannot get information about BBU")
            return (False, cliRet, errMsg)
        
        bbuEngineIdList = []
        standardBomCode = "Unknown" #保存正常BBU的BOM编码信息,默认Unknown
        isPrintBomCodeFlag = False #是否已经打印BOM编码标记
        bbuIdList = []
        errBbuIdList = [] #保存异常BBU的ID列表
        for line in cliRetLinesList:
            bbuId = line.get("ID")
            bbuIdList.append(bbuId)
            bbuEngineIdList.append(bbuId.split(".")[0][-1])
            bbuHealthStatus = line.get("Health Status")
            bbuRunningStatus = line.get("Running Status")
            bomCode = hardware.getHardwareBomCode("BBU", cli, bbuId)[1]
            if len(bomCode) != 0:
                standardBomCode = bomCode
            if bbuHealthStatus != common.STATUS_NORMAL:
                if bbuHealthStatus == common.STATUS_LOW_BATTERY:
                    warningFlag = True
                    errMsg += common.getMsg(LANG, "bbu.health.status.lowbattery", bbuId)
                    LOGGER.logWarning("The Health Status of BBU [%s] is %s" % (bbuId, bbuHealthStatus))
                else:
                    flag = False
                    errMsg += common.getMsg(LANG, "bbu.health.status.abnormal", (bbuId, bbuHealthStatus))
                    LOGGER.logNoPass("The Health Status of BBU [%s] is abnormal (Health Status:%s)" % (bbuId, bbuHealthStatus))
            
            if bbuRunningStatus not in [common.STATUS_ONLINE, common.STATUS_CHARGING, common.STATUS_DISCHARGING]:
                flag = False
                errMsg += common.getMsg(LANG, "bbu.running.status.abnormal", (bbuId, bbuRunningStatus))
                LOGGER.logNoPass("The Running Status of BBU [%s] is abnormal (Running Status:%s)" % (bbuId, bbuRunningStatus))
            #当BBU的硬件状态不正常时保存对应BBU的ID 
            if bbuHealthStatus != common.STATUS_NORMAL or (bbuRunningStatus not in  [common.STATUS_ONLINE, common.STATUS_CHARGING, common.STATUS_DISCHARGING]):
                errBbuIdList.append(bbuId)
        
        #需要上报告警且检查结果不为不通过时上报告警
        if flag == True and warningFlag == True:
            flag = cliUtil.RESULT_WARNING
        
        #当存在异常BBU的情况下，所有异常的BBU的ID以及BBU的标准BOM编码打印		
        if len(errBbuIdList) != 0:
            isPrintBomCodeFlag = True
            errMsg += common.getMsg(LANG, "hardware.bom.info", (",".join(errBbuIdList), standardBomCode))
            LOGGER.logNoPass("The Hardware ID: [%s] BOMCode:%s" % (",".join(errBbuIdList), standardBomCode))

        #当引擎的BBU存在没有的情况时，打印出状态正常BBU的BOM编码
        if isPrintBomCodeFlag is False and flag is not True:
            errMsg += common.getMsg(LANG, "normalhardware.bom.info", (",".join(bbuIdList), standardBomCode))
            LOGGER.logNoPass("The Normal Hardware ID: [%s] BOMCode:%s" % (",".join(bbuIdList), standardBomCode))
        if flag:
            LOGGER.logPass()
            
        return (flag, cliRetAll, errMsg)
    
    except Exception, exception:
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, cliRetAll, common.getMsg(LANG, "query.result.abnormal"))
