# -*- coding: UTF-8 -*-
import cliUtil
import common

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

def execute(cli):
    '''
    BBU寿命检查: 
                剩余时间（Remaining Lifetime）小于90天，即认为快到期，应该尽快更换。未查到时间属于不正常状态。
    '''
    flag = True
    cliRet = ""
    cliRetAll = ""
    errMsg = ""

    try:
        cmd = "show bbu life"
        LOGGER.logExecCmd(cmd)
        checkRet = cliUtil.excuteCmdInDeveloperMode(cli, cmd, True, LANG)
        if checkRet[0] != True:
            LOGGER.logSysAbnormal()
            return checkRet
        
        cliRet = checkRet[1]
        cliRetAll += cliRet
        cliRetLinesList = cliUtil.getHorizontalCliRet(cliRet)
        
        if len(cliRetLinesList) == 0:
            errMsg = common.getMsg(LANG, "cannot.get.remaining.lifetime.info")
            LOGGER.logNoPass("Cannot get information about Remaining Lifetime of BBU")
            return (False, cliRetAll, errMsg)
        
        for line in cliRetLinesList:
            bbuId = line.get("ID")
            remainingLifetime = line.get("Remaining Lifetime(days)")
            if remainingLifetime.isdigit():
                if int(remainingLifetime) < common.THRESHOLD_BBU_REMAINING_LIFETIME:
                    flag = False
                    errMsg += common.getMsg(LANG, "bbu.remaining.lifetime.abnormal", 
                        (bbuId, common.THRESHOLD_BBU_REMAINING_LIFETIME, remainingLifetime))
                    LOGGER.logNoPass("The Remaining Lifetime of BBU [%s] is less than [%s] days (Remaining Lifetime:%s)" 
                         % (bbuId, common.THRESHOLD_BBU_REMAINING_LIFETIME, remainingLifetime))
            else:
                flag = False
                errMsg += common.getMsg(LANG, "cannot.get.bbu.remaining.lifetime", bbuId)
                LOGGER.logNoPass("Cannot get information about Remaining Lifetime of BBU[%s" % bbuId)
            
        if flag:
            LOGGER.logPass()
            
        return (flag, cliRetAll, errMsg)
    
    except Exception, exception:
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, cliRet, common.getMsg(LANG, "query.result.abnormal"))
