# -*- coding: UTF-8 -*-
import cliUtil
import common

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

def execute(cli):
    """
    硬盘的固件版本检查
    1  如果硬盘的检查标准满足以下条件之一，则检查结果为不通过。
     1） Model为ST2000NM0023、ST3000NM0023、ST4000NM0023其中之一，且Firmware Version为0003,0004,0005,0006,0007其中之一；
     2） Model为ST1000NM0033、ST2000NM0033、ST3000NM0033、ST4000NM0033其中之一，且Firmware Version为SN01,SN02,SN03,SN04,SN05,SN06,SNC6,SNA5其中之一；"""
    flag = True
    cliRet = ""
    errMsg = ""
    bugDiskIDList = []
    #存在问题的固件Model与对应的FW
    bugFWVersionMap = {
        "ST2000NM0023": ("0003", "0004", "0005", "0006", "0007"),
        "ST3000NM0023": ("0003", "0004", "0005", "0006", "0007"),
        "ST4000NM0023": ("0003", "0004", "0005", "0006", "0007"),
        "ST1000NM0033": ("SN01", "SN02", "SN03", "SN04", "SN05", "SN06", "SNC6", "SNA5"),
        "ST2000NM0033": ("SN01", "SN02", "SN03", "SN04", "SN05", "SN06", "SNC6", "SNA5"),
        "ST3000NM0033": ("SN01", "SN02", "SN03", "SN04", "SN05", "SN06", "SNC6", "SNA5"),
        "ST4000NM0033": ("SN01", "SN02", "SN03", "SN04", "SN05", "SN06", "SNC6", "SNA5"),
    }
    #用于版本新旧对比的固件Model与对应的阈值
    oldFWVersionMap = {
        "HUC101818CS4200": "AAG4",
        "HUC101812CS4200": "AAG4",
    }

    #存放无法获取固件版本值的硬盘
    errInfoDiskIDList = []
    try:

        cmd = "show disk general |filterColumn include " \
              "columnList=ID,Model,Firmware\\sVersion," \
              "Serial\\sNumber,Bar\\sCode"
        checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        if checkRet[0] != True:
            return checkRet
        
        cliRet = checkRet[1]
        if cliUtil.queryResultWithNoRecord(cliRet):
            return (True, cliRet, errMsg)

        cliRetLinesList = cliUtil.getHorizontalCliRet(cliRet)
        if len(cliRetLinesList) == 0:
            errMsg = common.getMsg(LANG, "cannot.get.diskinfo")
            return (cliUtil.RESULT_NOCHECK, cliRet, errMsg)  # 修改备注：解析回显失败导致列表长度为0

        for line in cliRetLinesList:
            diskID = line.get("ID", "")
            model = line.get("Model", "")
            FWVersion = line.get("Firmware Version", "")
            serial_number = line.get("Serial Number", "")
            bugVersionList = bugFWVersionMap.get(model)
            limitVersion = oldFWVersionMap.get(model)
            if FWVersion == "" or FWVersion == "--":
                errInfoDiskIDList.append(diskID)
                continue
            if (not bugVersionList) and (not limitVersion):
                continue
            if bugVersionList:
                if FWVersion.upper() in bugVersionList:
                    bugDiskIDList.append(diskID)
            if limitVersion:
                if FWVersion.upper() < limitVersion:
                    bugDiskIDList.append(diskID)

        LOGGER.logNoPass("bugDiskIDList:" + str(bugDiskIDList))
        if bugDiskIDList:
            flag = False
            errMsg = common.getMsg(LANG, "low.fmversion.disk.info", ", ".join(bugDiskIDList))

        if errInfoDiskIDList:
            flag = False
            errMsg += common.getMsg(LANG, "canot.get.fmversion.disk.info", ", ".join(errInfoDiskIDList))

        return (flag, cliRet, errMsg)

    except Exception, exception:
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, cliRet, common.getMsg(LANG, "query.result.abnormal"))
