# -*- coding: UTF-8 -*-
import re
import cliUtil
import common

lang = common.getLang(py_java_env)
logger = common.getLogger(PY_LOGGER, __file__)

def execute(cli):
    '''
        扩容硬盘数量规格检查
    '''
    flag = True
    cliRet = ""
    cliRetAll = ""
    errMsg = ""
    versionList = ["V300R001C01", "V300R001C01SPC100"]
    DISK_INTF_TYPE = "SAS"
    maxDiskNumOfEngine = {
        "Dorado6000 V3":{"SAS":110},
        "Dorado5000 V3":{"SAS":110, "NVMe":35},
    }
    deviceType = str(common.getProductModeFromContext(py_java_env))
    expDiskList = common.getExpDiskListFromContextFilter(py_java_env)
    logger.logInfo("expDiskList is %s" % expDiskList)

    try:
        # 如果都是新建硬盘域,则不涉及
        if not expDiskList:
            return cliUtil.RESULT_NOSUPPORT, "", ""
        
        ret, sysVersionList, hotpatchVersionList = common.parse_upgradePackage(cli, lang)
        cliRet = ret[1]
        cliRetAll += cliRet
        if not ret[0]:
            return cliUtil.RESULT_NOCHECK, cliRetAll, ret[2]

        # 非系统版本:"V300R001C01", "V300R001C01SPC100" 不涉及此检查项
        ret, sysVersion, errInfo = common.getCurrentVersion(sysVersionList,lang)
        logger.logInfo("current system version:%s" % sysVersion)
        if not ret:
            logger.logError("failed to get system version info")
            errMsg = errInfo
            return cliUtil.RESULT_NOCHECK, cliRet, errMsg
        if sysVersion not in versionList:
            logger.logInfo("current system version does not involve")
            return cliUtil.RESULT_NOSUPPORT, cliRetAll, ""

        # 补丁版本:"V300R001C01SPH103" 及之后版本 不涉及此检查项
        ret, hotpatchVersion, errInfo = common.getHotPatchVersion(hotpatchVersionList, lang)
        logger.logInfo("hotpatch_version:%s" % hotpatchVersion)
        if not ret:
            logger.logError("failed to get hotpatch version info")
            errMsg = errInfo
            return cliUtil.RESULT_NOCHECK, cliRet, errMsg
        if hotpatchVersion != "--" and hotpatchVersion >= "V300R001C01SPH103":
            logger.logInfo("current hotpatch version does not involve")
            return cliUtil.RESULT_NOSUPPORT, cliRetAll, ""

        # 获取硬盘域信息
        flag, cliRet, errMsg, diskDomainList = common.getDiskDomainInfo(cli, lang)
        cliRetAll += cliRet
        if not flag:
            logger.logSysAbnormal()
            return cliUtil.RESULT_NOCHECK, cliRetAll, errMsg

        # 硬盘域不存在返回不涉及
        if flag and not diskDomainList:
            logger.logInfo("the diskDomain is not exist")
            return cliUtil.RESULT_NOSUPPORT, cliRetAll, ""
        logger.logInfo("diskDomainList is %s" % diskDomainList)

        # 判断Dorado5000 V3 具体的框类型:"SAS","NVMe"
        if deviceType == "Dorado5000 V3":
            flag, cliRet, errMsg, enclosureType = common.getEnclosureType(cli, lang)
            cliRetAll += cliRet
            if not flag:
                return cliUtil.RESULT_NOCHECK, cliRetAll, errMsg
            DISK_INTF_TYPE = enclosureType
            logger.logInfo("DISK_INTF_TYPE is :%s" % DISK_INTF_TYPE)

        for diskDomain in diskDomainList:
            diskDomainId = diskDomain.get("ID")
            flag, cliRet, errMsg, diskInDomainList = common.getDiskDomainInfoById(cli, diskDomainId, lang)
            cliRetAll += cliRet
            if not flag:
                return cliUtil.RESULT_NOCHECK, cliRetAll, errMsg

            # 获取硬盘域中的硬盘类型
            diskTypeList = [disk.get("Type") for disk in diskInDomainList] # ['SSD', 'SSD_SED', 'SAS', 'SSD', 'SAS', 'SSD']
            logger.logInfo("diskTypeList is %s" % diskTypeList)

            # 根据硬盘域ID获取对应的新扩硬盘类型
            newExpDiskList = filter(lambda disk:disk.get("diskDomain") == diskDomainId, expDiskList)
            logger.logInfo("newExpDiskList is %s" % newExpDiskList)

            diskModelList = [disk.get("diskModel") for disk in newExpDiskList]
            logger.logInfo("diskModelList is %s" % diskModelList)

            # 新扩容硬盘类型和已有硬盘域中的SSD硬盘类型(加密:SSDSED;非加密硬盘SSD等)不一致
            if len(set(diskTypeList)) == 1 and set(diskTypeList) != set(diskModelList):
                flag = False
                logger.logNoPass("the disk type of diskDomain is not consistance with the expand diskType")
                errMsg += common.getMsg(lang, "expand.disk.type.not.pass")
                break

            # 获取硬盘域中在每个引擎上的硬盘数
            engineDiskNumDic = {} # {"0":50,"1":100}
            for disk in diskInDomainList:
                engineId = common.getEngineIdByDiskId(disk.get("ID"))  # 根据硬盘ID获取引擎ID
                engineDiskNumDic[engineId] = engineDiskNumDic.get(engineId, 0) + 1
            logger.logInfo("engineDiskNumDic is %s" % engineDiskNumDic)
            
            # 引擎上新扩硬盘数字典
            newExpDiskNumDic = {} # {"0":40,"1":50}
            for newExpDisk in newExpDiskList:
                engineId = newExpDisk.get("logicEng")
                diskNum = int(newExpDisk.get("diskNum"))
                newExpDiskNumDic[engineId] = newExpDiskNumDic.get(engineId, 0) + diskNum
            logger.logInfo("newExpDiskNumDic is %s" % newExpDiskNumDic)
            
            # 如果单引擎扩盘满足条件:原单引擎硬盘域硬盘数 + 2 * 新扩容硬盘数 > 单引擎最大硬盘数目（Dorado6000:110； Dorado5000 SAS: 110； Dorado5000 NVMe：35）,检查结果为“不通过”。
            maxExpDiskNum = maxDiskNumOfEngine.get(deviceType).get(DISK_INTF_TYPE, 110)
            for engineId in newExpDiskNumDic:
                if (engineDiskNumDic.get(engineId) + 2 * newExpDiskNumDic.get(engineId)) > maxExpDiskNum:
                    flag = False
                    logger.logNoPass("The condition of expand disk is not pass in single engineer")
                    maxNewExpDiskNum = int((maxExpDiskNum - engineDiskNumDic.get(engineId))/2)
                    errMsg += common.getMsg(lang, "expand.disk.number.scale.max.not.pass", (engineId, newExpDiskNumDic.get(engineId), maxNewExpDiskNum))

        return flag, cliRetAll, errMsg

    except Exception, exception:
        logger.logException(exception)
        return cliUtil.RESULT_NOCHECK, cliRetAll, common.getMsg(lang,"query.result.abnormal")