# coding: UTF-8

import cliUtil
import common
import expandconfig
import traceback
from frameone.adapter import connectionFactory
from frameone.util import common as frameCommon
from frameone.util import contextUtil
from cbb.frame.base import product, baseUtil
from common_utils import is_support_read_only_user_enter_debug

dataDict = contextUtil.getContext(py_java_env)
expConfigObj = expandconfig.ExpandConfig(py_java_env)
LANG = common.getLang(py_java_env)
logger = common.getLogger(PY_LOGGER, __file__)

##磁盘利用率的最大值和平均值的阈值定义
G_AvgDiskUsage = 60
allCliRet = []
UPD_DISKUSAGECHECK_DISABLE_VERSION = "V500R007C60"
NO_PERMISSION_ERROR_CODE = '1077949058'
DISK_TYPE_DICT = {
    "FC": 0,
    "SAS": 1,
    "SATA": 2,
    "SSD": 3,
    "NL_SAS": 4,
    "SLC_SSD": 5,
    "MLC_SSD": 6,
    "NVME_SSD": 14
}

TYPE_DISK_DICT = {
    0: "FC",
    1: "SAS",
    2: "SATA",
    3: "SSD",
    4: "NL_SAS",
    5: "SLC_SSD",
    6: "MLC_SSD",
    14: "NVME_SSD"
}


@frameCommon.wrapInspectException(lan=LANG, logger=logger,
                                  originalInfo=allCliRet)
@frameCommon.fakeProgress(py_java_env, totalSeconds=30, logger=logger,
                          interval=1)
def execute(cli):
    """
    检查产品的磁盘使用率
    1.用cli命令获取磁盘使用率
    2.设备不支持cli命令，通过upd命令获取磁盘使用率
    :param cli: cli会话连接
    :return: 检查结果, 命令回显, 错误消息
    """

    # 获取productModel和productVersion
    flag, productModel, productVersion, cliRet = \
        cliUtil.getProductModelAndVersion(cli, LANG)
    if flag is not True:
        return cliUtil.RESULT_NOCHECK, "", cliRet

    isDoradoV6 = baseUtil.isDoradoV6Dev(productModel)
    isDorado = baseUtil.isDoradoDev(productModel)
    # svp防呆 获取控制器的cli连接
    isCliBuildSucc, cliRet, errMsg, cliConToCtrl, connIp = \
        common.getConnectionByControllerIp(py_java_env, cli, logger)
    if not isCliBuildSucc:
        cliConToCtrl = cli
    hot_patch = str(py_java_env.get("devInfo").getHotPatchVersion())
    if any(
            [
                isDoradoV6,
                productVersion >= UPD_DISKUSAGECHECK_DISABLE_VERSION and
                "Kunpeng" in productVersion,
                productVersion >= "V500R007C61"
            ]
    ) or is_support_read_only_user_enter_debug(productVersion, hot_patch):
        # V5R7C60以上的ARM版本和DoradoV6 调用diagnose命令获取磁盘利用率
        flag, all_ret, err_msg = getDiskUserateByCli(cliConToCtrl, isDorado)
    else:
        # 其他版本仍然使用原来的命令检查磁盘使用率
        flag, all_ret, err_msg = getDiskUserateByRest(cli)

    # 释放控制器的cli连接
    current_conn_ip = py_java_env.get("devInfo").getIp()
    if current_conn_ip != connIp:
        common.closeSSH(cliConToCtrl)

    ret = cliUtil.enterCliModeFromSomeModel(cli, LANG)
    logger.logInfo("enter cli mode from some model ret is %s" % str(ret))

    # 退出失败后为不影响后续检查项重新连接cli
    if not ret[0]:
        common.reConnectionCli(cli, logger)

    return flag, all_ret, err_msg


def checkState(diskUsage):
    """
    根据返回消息，转化成对应key值。
    :param diskUsage:
    :return:
    """
    # 结果超时处理流程
    if diskUsage.lower() == "timeout":
        return cliUtil.RESULT_NOCHECK, None

    diskUsageStrList = diskUsage.split(",")

    # 结果异常处理流程
    if len(diskUsageStrList) == 0 or len(diskUsageStrList) > 2:
        return diskUsage
    for usage in diskUsageStrList:
        if not usage.isdigit():
            return cliUtil.RESULT_NOCHECK, None

    diskUsageList = [int(usage) for usage in diskUsageStrList]
    # 结果正常处理流程
    avgUsage = 0
    if len(diskUsageList) == 2:
        avgUsage = diskUsageList[1]

    if avgUsage <= G_AvgDiskUsage:
        return True, str(avgUsage)
    else:
        return cliUtil.RESULT_WARNING, str(avgUsage)


def getDiskUserateByCli(cli, isDorado):
    """
    调用diagnose命令 获取硬盘利用率平均值
    cli命令说明:
    ld show userate d=%s c=%s o=%s -app_data
    diskType: 4294967295(所有盘)
    cycle: 秒數
    opType: 0(平均值), 1(最大值)
    """
    disktype = "4294967295"
    cycle = "5"
    op = "0"
    cmd = "ld show userate d=%s c=%s o=%s -app_data" % (disktype, cycle, op)
    if isDorado:
        cmd = "ld show userate d=%s c=%s o=%s" % (disktype, cycle, op)
    flag, avgRet, errMsg = cliUtil.excuteCmdInDebugModel(cli, cmd, LANG)
    if is_command_not_support(avgRet):
        logger.logInfo(
            "cmd not support, use ld show userate d=diskType c=cycle"
        )
        return check_disk_other_cmd(cli)

    logger.logInfo("ld show userate, flag=%s, avg_ret=%s" % (flag,
                                                             str(avgRet)))
    cliUtil.enterCliModeFromSomeModel(cli, LANG)
    if flag is True and ("not found" not in avgRet) and (
            "Usage:" not in avgRet):
        avgList = avgRet.encode("utf8").splitlines()
        if len(avgList) >= 2:
            cmdRet = avgList[0]
            flagRet = avgList[1]
            if flagRet == "True":
                userateRet = avgList[2]
                if float(userateRet) <= float(G_AvgDiskUsage):
                    return True, str(avgRet), ''
                else:
                    errMsg = common.getMsg(LANG, "check.disk.userate.warning",
                                           userateRet)
                    return cliUtil.RESULT_WARNING, str(avgRet), errMsg
            elif flagRet == "False":
                errMsg = common.getMsg(LANG, "disk_usage_has_no_disk")
                return cliUtil.RESULT_NOCHECK, str(avgRet), errMsg
    if not cliUtil.hasCliExecPrivilege(avgRet):
        error_msg = common.getMsg(LANG, "loginUser.name.level.must.be.super.admin")
        return cliUtil.RESULT_NOCHECK, str(avgRet), error_msg
    errMsg = common.getMsg(LANG, "check.disk.userate.no.check")
    return cliUtil.RESULT_NOCHECK, str(avgRet), errMsg


def is_command_not_support(cli_ret):
    """
     cycle or diskType is out of bounds: cycle [1-60], diskType [0-6|14]
     (0:FC 1:SAS 2:SATA 3:SSD 4:NL_SAS 5:SLC_SSD 6:MLC_SSD 14:NVME_SSD).
    Usage: ld show userate d=diskType c=cycle

    :param cli_ret:
    :return:
    """
    return "Usage: ld show userate d=disktype c=cycle" in cli_ret


def check_disk_other_cmd(cli):
    """
    使用 ld show userate d=disktype c=cycle 命令查询
    :param cli:
    :return:
    """
    cliUtil.enterCliModeFromSomeModel(cli, LANG)
    cmd = "show disk general |filterColumn include columnList=Type"
    flag, ret, msg = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
    tmp_ret_list = cliUtil.getHorizontalCliRet(ret)
    disk_type_list = [
        DISK_TYPE_DICT.get(disk_type.get("Type"))
        for disk_type in list(
            filter(lambda x: x.get("Type") in DISK_TYPE_DICT, tmp_ret_list)
        )
    ]
    ret_list = []
    err_msg_list = []
    disk_type_list = list(set(disk_type_list))
    for d_type in disk_type_list:
        cmd = "ld show userate d={} c=5".format(d_type)
        flag, avg_ret, err_msg = cliUtil.excuteCmdInDebugModel(cli, cmd, LANG)
        ret_list.append(avg_ret)
        if flag is not True:
            err_msg = common.getMsg(LANG, "check.disk.userate.no.check")
            return cliUtil.RESULT_NOCHECK, "\n".join(ret_list), err_msg
        avg_ret_list = avg_ret.splitlines()
        for line in avg_ret_list:
            if "Argv Use Rate" not in line or ":" not in line:
                continue

            res = line.split(":")[1].strip()
            if float(res) <= float(G_AvgDiskUsage):
                continue
            err_msg_list.append(
                common.getMsg(
                    LANG,
                    "check.disk.userate.warning.disktype",
                    (TYPE_DISK_DICT.get(d_type), res),
                )
            )

    ret_str = "\n".join(ret_list)
    if err_msg_list:
        return cliUtil.RESULT_WARNING, ret_str, "\n".join(err_msg_list)

    return True, ret_str, ""


def getDiskUserateByRest(cli):
    """
    调用REST命令 获取硬盘利用率平均值
    :param cli:
    :return: 检查结果, 命令回显, 错误消息
    """
    orgIp = py_java_env.get("devInfo").getIp()
    ctrlChkFlags = []
    errMsg = ""
    try:
        connectionAdapter = connectionFactory.getAdapter(dataDict)
        recs = connectionAdapter.excuteDiagnoseCmd("upd diskusagecheck", 2)
        logger.logInfo("records=%s" % str(recs))
        for rec in recs:
            nodeId = connectionAdapter.getParamStrValue(rec, 0)
            result = connectionAdapter.getParamStrValue(rec, 1)

            chkResult, avgUsage = checkState(result)
            allCliRet.append((nodeId, str(avgUsage)))
            logger.logInfo("DiskDiagnoseSwitchCheck itemVal:%s" % str(
                (chkResult, avgUsage)))
            ctrlChkFlags.append(chkResult)

            if chkResult == cliUtil.RESULT_WARNING:
                errMsgArgs = (nodeId, avgUsage) if LANG == 'zh' else (
                    avgUsage, nodeId)
                errMsg += common.getMsg(LANG, "check.disk.usage.warning",
                                        errMsgArgs)

            if chkResult == cliUtil.RESULT_NOCHECK:
                errMsg += common.getMsg(LANG, "check.disk.usage.no.check",
                                        nodeId)
        logger.logInfo("errMsg=%s" % errMsg)
        allCliRet.sort(key=lambda t: t[0])
        if ctrlChkFlags.count(cliUtil.RESULT_NOCHECK) > 0:
            return cliUtil.RESULT_NOCHECK, str(allCliRet), errMsg
        elif ctrlChkFlags.count(cliUtil.RESULT_WARNING) > 0:
            return cliUtil.RESULT_WARNING, str(allCliRet), errMsg
        return True, str(allCliRet), ''
    except Exception as exception:
        logger.logError('get Disk Userate By Rest fail: {}'.format(
            traceback.format_exc()))
        return get_err_msg_by_exception(exception)
    finally:
        connectionAdapter.close()
        py_java_env.get("devInfo").setIp(orgIp)


def get_err_msg_by_exception(ex):
    """
    处理异常场景
    :param ex:
    :return:
    """
    args = ex.args
    if args and len(args) >= 2:
        if args[0] == NO_PERMISSION_ERROR_CODE:
            err_msg = common.getMsg(
                LANG, "loginUser.name.level.must.be.super.admin")
            return (cliUtil.RESULT_NOCHECK, str(allCliRet), err_msg)

    return (cliUtil.RESULT_NOCHECK, str(allCliRet),
            common.getMsg(LANG, "cannot.build.http.connections.tlv"))
