# -*- coding: UTF-8 -*-
import cliUtil
import common

lang = common.getLang(py_java_env)
logger = common.getLogger(PY_LOGGER, __file__)


def execute(cli):
    '''
        扩容配置检查
    '''
    flag = True
    cliRet = ""
    errMsg = ""
    VERSION_LIST = ["V300R002C00", "V300R002C00SPC100", "V300R002C10", "V300R002C10SPC100", "V300R002C10SPC200", "V300R003C00"]
    try:
        deviceType = str(common.getProductModeFromContext(py_java_env))
        logger.logInfo("the devicetype is %s" % deviceType)
        if deviceType != "6800 V3":
            return True, cliUtil.RESULT_NOSUPPORT, errMsg
        
        ret, sysVersionList, hotpatchVersionList = common.parse_upgradePackage(cli, lang)
        cliRet = ret[1]
        if not ret[0]:
            errMsg = ret[2]
            return cliUtil.RESULT_NOCHECK, cliRet, errMsg

        ret, sysVersion, errInfo = common.getCurrentVersion(sysVersionList,lang)
        logger.logInfo("current system version:%s" % sysVersion)
        if not ret:
            errMsg = errInfo
            return cliUtil.RESULT_NOCHECK, cliRet, errMsg
        
        if sysVersion not in VERSION_LIST:
            logger.logInfo("the current system version is not mentioned")
            return True, cliRet, ""
        
        checkRet = cliUtil.getControllerIdList(cli, lang)
        if not checkRet[0]:
            logger.logError("failed to the controller number")
            return cliUtil.RESULT_NOCHECK, checkRet[1], checkRet[2]
        
        ctrlNumBfExp = len(checkRet[1])
        logger.logInfo("the ctrlNumBfExp is %s" % ctrlNumBfExp)
        ctrlNumAfExp = common.getExpCtrlNumber(py_java_env)
        logger.logInfo("the ctrlNumAfExp is %s" % ctrlNumAfExp)
        
        if (ctrlNumBfExp, ctrlNumAfExp) == (6, 8):
            logger.logNoPass("it does not support %s controllers expand to %s controllers" % (ctrlNumBfExp, ctrlNumAfExp))
            errMsg = common.getMsg(lang, "check.expandbay.type.not.pass", (deviceType, ctrlNumBfExp, ctrlNumAfExp))
            return False, cliRet, errMsg

        return True, cliRet, errMsg

    except Exception, exception:
        logger.logException(exception)
        return cliUtil.RESULT_NOCHECK, cliRet, common.getMsg(lang,"query.result.abnormal")