# -*- coding: UTF-8 -*-
import cliUtil
import common

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

def execute(cli):
    '''
    IB port 端口误码检查：
        如果IB port不存在误码属于正常，否则属于不正常状态。
    '''
    flag = True
    cliRet =""
    errMsg = ""
    #配置需要检查的项
    checkKeys = ["Symbol Error",
                 "Link Error Recovery",
                 "Port Receive Errors",
                 "Port Remote Receive Errors",
                 "Port Receive Transmit  Errors",
                 "Not Send Pacakges",
                 "Port Receive Constraint Errors",
                 "Link Errors",
                 "Buffer Overrun Errors"]
    try:
        cmd = "show ib_port general"
        checkRet = cliUtil.excuteCmdInDeveloperMode(cli, cmd, True, LANG)
        cliRet = checkRet[1]
        
        if checkRet[0] != True:
            LOGGER.logNoPass("Cannot get information about IB port!")
            errMsg = common.getMsg(LANG, "cannot.get.port.info", "IB")
            return (checkRet[0], cliRet, errMsg)  # 修改备注：excuteCmdInDeveloperMode执行失败属于命令异常
        
        #如果Command executed successfully 直接报通过
        if cliUtil.queryResultWithNoRecord(cliRet):
            return (True, cliRet, errMsg)
        
        #能查出信息
        cliRet = checkRet[1]
        ibPortDicList = cliUtil.getHorizontalCliRet(cliRet)
        ibPortId = ""
        #首先取出所有的IB PORT ID, 然后根据ID二次查询 bit信息
        for ibPortDic in ibPortDicList:
            ibPortId = ibPortDic.get("ID")
            
            #组装根据ID查询误码信息的CMD
            queryBitMsgCmd = "show ib_port general ib_port_id=%s"%ibPortId
            queryRes = cliUtil.excuteCmdInDeveloperMode(cli, queryBitMsgCmd, True, LANG)
            if queryRes[0] != True:
                LOGGER.logNoPass("Cannot get information about IB port bit error!")
                return (queryRes[0], queryRes[1], queryRes[2])
            
            #将二级查询信息加到原始信息上。
            cliRet += queryRes[1]
            
            #检查每条记录bit error是否正常
            bitMsgDicList = queryRes[1].splitlines()
            for bitMsgDic in bitMsgDicList:
                #处理查询出来的信息，得到bit error code 和  value.
                fields = bitMsgDic.split(":")
                if len(fields) < 2:
                    continue
                key = fields[0].strip()
                value = fields[1].strip()
                
                #过滤配置的检查项
                if key in checkKeys:
                    if int(value) > 0:
                        flag = False
                        errMsg += common.getMsg(LANG, "ib.port.bit.error.health.status.abnormal", (ibPortId, key, value))
                        LOGGER.logNoPass("The IB port[%s] health status is abnormal (IB port bit error:%s,value:%s)"%(ibPortId, key, value)) 
        if flag:
            LOGGER.logPass()
            
        return (flag, cliRet, errMsg)
        
    except Exception, exception:
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, cliRet, common.getMsg(LANG, "query.result.abnormal"))
    
