# -*- coding: UTF-8 -*-
import cliUtil
import common

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

def execute(cli):
    '''
        系统盘检查：
        1 有硬盘的类型为SATA，则检查结果为不通过；2 所有硬盘的类型都不为SATA属于正常状态。
    '''
    flag = True
    cliRet = ""
    errMsg = ""

    try:
        cmd = "show disk system"
        LOGGER.logExecCmd(cmd)
        checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        if checkRet[0] != True:
            LOGGER.logSysAbnormal()
            return checkRet
        
        cliRet = checkRet[1]
        if cliUtil.queryResultWithNoRecord(cliRet):
            errMsg = common.getMsg(LANG, "cannot.get.disk.info")
            return (cliUtil.RESULT_NOCHECK, cliRet, errMsg)  # 修改备注：命令执行成功但是回显中没有详细信息应该是未检查
        
        cliRetLinesList = cliUtil.getHorizontalCliRet(cliRet)
        if len(cliRetLinesList) == 0:
            errMsg = common.getMsg(LANG, "cannot.get.disk.info")
            LOGGER.logNoPass("Cannot get information about disk status")
            return (False, cliRet, errMsg)

        for line in cliRetLinesList:
            diskID = line.get("ID")
            diskType = line.get("Type")
            if str(diskType) == common.DISK_TYPE_SATA:
                flag = False
                errMsg += common.getMsg(LANG, "system.disk.type.abnormal", (diskID))
                LOGGER.logNoPass("SATA disks exist among system disks, Disk ID is [%s],Disk Type is [%s]" % (diskID,diskType))
        if flag:
            LOGGER.logPass()
            
        return (flag, cliRet, errMsg)
    
    except Exception, exception:
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, cliRet, common.getMsg(LANG, "query.result.abnormal"))
