# -*- coding: UTF-8 -*-
import cliUtil
import common
import config
import common_cache
import common_utils

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

localDev = common.getCurDeviceInfo(py_java_env)
lineBreak = '\n'
#以下双活pair Id对应双活信息查询失败 
pairInfoQueryFailre = []
#以下双活pair Id对应的存储池Id查询失败
poolIdQueryFailre = []
#以下双活pair Id对应的存储池信息查询失败
poolInfoQueryFailre = []
#存储池不一致的双活pair Id对应的不一致信息
poolInConsistencyInfo = []
#record original cliRet
cliRetList = []
devCheckResultList = []
checkResultList = []
# 健康状态异常的存储池
abnormalPoolList = []

def execute(cli):
    '''
    @summary: 双活两端硬盘域及存储池的一致性检查
    '''  
    flag = True
    errMsg = ''
    try:      
        loacalDevSN = str(localDev.getDeviceSerialNumber())    
        flag, ret, msg, pair_list = common_cache.get_san_pair_from_cache(
            py_java_env, LOGGER, loacalDevSN, LANG)
        addCliRet2List(loacalDevSN, ret, cliRetList)
        if flag is not True:
            return (cliUtil.RESULT_NOCHECK, lineBreak.join(cliRetList), common.getMsg(LANG, "poolanddomain.query.pair.falure"))
        if not pair_list:
            LOGGER.logInfo('***[not hyper metro]***')
            return True, lineBreak.join(cliRetList), ''
        LOGGER.logInfo("***[pair_list= %s]***" % pair_list)
        flag, addedSnList, errMsg = common.checkAddedRemoteDevSn(py_java_env, LANG)      
        LOGGER.logInfo("***[addedSnList= %s]***" % addedSnList)
        if flag != True:
            LOGGER.logInfo("***[get addedSnList fail]***")
            return common_utils.get_result_bureau(py_java_env, lineBreak.join(cliRetList), errMsg)
        flag, remoteCliRet, errMsg, hyperRemoteSnList = common.getRemoteDevSn(py_java_env, loacalDevSN, LOGGER)
        LOGGER.logInfo("***[hyperRemoteSnList= %s]***" % hyperRemoteSnList)
        if flag != True:
            LOGGER.logInfo("***[get hyperRemoteSnList fail, remoteCliRet = %s]***" % remoteCliRet)
            return common_utils.get_result_bureau(py_java_env, lineBreak.join(cliRetList), errMsg)
        localIdAndremoteIdList = queryLocalIdAndRemoteId(pair_list)
        LOGGER.logInfo("***[localIdAndremoteIdList= %s]***" % localIdAndremoteIdList)
        flag, pair_sn_dict, errMsg = common_cache.get_pair_to_dev_sn(
            py_java_env, loacalDevSN, LOGGER, LANG)
        LOGGER.logInfo("***[pair_sn_dict= {}]***".format(pair_sn_dict))
        if not pair_sn_dict:
            return (flag, lineBreak.join(cliRetList), errMsg)
        notAddDeviceMsg = ''
        for remoteDevSN in hyperRemoteSnList:
            if not remoteDevSN in addedSnList:
                LOGGER.logInfo("***[remote device not add: %s]***" % remoteDevSN)
                flag = cliUtil.RESULT_NOCHECK
                notAddDeviceMsg += common.getMsg(LANG, "not.add.remote.device", remoteDevSN)
                continue
            for item in localIdAndremoteIdList:
                #此处item不会有越界问题
                if remoteDevSN != pair_sn_dict.get(item[-1]):
                    continue
                checkFlag = checkPool(item[0], item[1], item[-1], loacalDevSN, remoteDevSN)
                devCheckResultList.append(checkFlag)
            LOGGER.logInfo("***[pairInfoQueryFailre= %s]***" % pairInfoQueryFailre)
            if pairInfoQueryFailre:
                devCheckResultList.append(cliUtil.RESULT_NOCHECK)         
            devCheckFlag = getCheckResult(devCheckResultList)
            del devCheckResultList[:]
            checkResultList.append(devCheckFlag)
            if devCheckFlag != True:
                errMsg += handleErrorMsg(loacalDevSN, remoteDevSN)  
        errMsg = notAddDeviceMsg + errMsg
        
        if abnormalPoolList:
            abnormalPoolErrMsg = getAbnormalPoolErrMsg(abnormalPoolList)
            errMsg += abnormalPoolErrMsg
                                           
        return (getCheckResult(checkResultList), lineBreak.join(cliRetList), errMsg)
    except BaseException, exception:
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, lineBreak.join(cliRetList), common.getMsg(LANG, "query.result.abnormal"))

def getAbnormalPoolErrMsg(abnormalPoolList):
    '''
    @summary: get error message when the pool health status abnormal.
    '''
    errMsg = ""
    abnormalPoolList.sort()
    for abnormalPool in abnormalPoolList:
        errMsg += common.getMsg(LANG, "hypermetro.pool.health.status.abnorml", abnormalPool)    
    return errMsg


def addCliRet2List(devSn, excecuteCliRet, retList):
    snPrefix = '\nSN: %s\n' % devSn   
    if devSn:
        retList.append(snPrefix + excecuteCliRet)
    else:
        retList.append(excecuteCliRet)
      
def getCheckResult(checkResult):
    '''
    @summary: get check result
    '''
    if abnormalPoolList:
        return False
    if not checkResult:
        return cliUtil.RESULT_NOCHECK
    if False in checkResult:
        return cliUtil.RESULT_WARNING
    if cliUtil.RESULT_WARNING in checkResult:
        return cliUtil.RESULT_WARNING
    if cliUtil.RESULT_NOCHECK in checkResult:
        return cliUtil.RESULT_WARNING if common.is_opening_delivery_inspect(py_java_env) else cliUtil.RESULT_NOCHECK
    return True

def checkPool(loacalLunId, remoteLunId, pairId, loacalDevSN, remoteDevSN):
    '''
    @summary: execute the checking of pool. 
    '''
    loacalFlag, loacalPoolId = queryPoolId(loacalLunId, pairId, loacalDevSN)
    if not loacalFlag:
        return cliUtil.RESULT_NOCHECK
    remoteFlag, remotePoolId = queryPoolId(remoteLunId, pairId, remoteDevSN)
    if not remoteFlag:
        return cliUtil.RESULT_NOCHECK
    poolExecuteStatus, poolCompareResult = comparePoolInfo(loacalPoolId, remotePoolId, pairId, loacalDevSN, remoteDevSN)
    if not poolExecuteStatus:
        LOGGER.logInfo("***[poolExecuteStatus= %s]***" % str(poolExecuteStatus))
        return cliUtil.RESULT_NOCHECK
    return poolCompareResult

def queryLocalIdAndRemoteId(pair_info_list):
    localIdAndremoteIdList = []
    for pair_info in pair_info_list:
        pair_id = pair_info.get("ID")
        localId = pair_info.get("Local ID", '')
        remotId = pair_info.get("Remote ID", '')
        if not localId and remotId:
            pairInfoQueryFailre.append(pair_id)
            break
        localIdAndremoteIdList.append((localId, remotId, pair_id))
    return localIdAndremoteIdList

def queryPoolId(lunId, pairId, devSN):
    '''
    @summary: query pool id
    @return: (executeStatus, pool id)
    '''
    poolId = ''
    cmd = 'show lun general lun_id=%s' % lunId
    executeStatus, executeCliRet, errorMsg = common.getObjFromFile(py_java_env, LOGGER, str(devSN), cmd)
    addCliRet2List(str(devSN), executeCliRet, cliRetList)
    if executeStatus != True:
        poolIdQueryFailre.append(pairId)
        LOGGER.logError(cmd + ':' + errorMsg)
        return False, poolId
    lunGeneralInfoList = cliUtil.getVerticalCliRet(executeCliRet)
    for lunGeneralDict in lunGeneralInfoList:
        poolId = lunGeneralDict.get('Pool ID', '')
    if not poolId:
        poolIdQueryFailre.append(pairId)
        return False, poolId
    LOGGER.logInfo("***[queryPoolId: %s is: %s]***" % (cmd, poolId))
    return True, poolId
    
def comparePoolInfo(loacalPoolId, remotePoolId, pairId, localDevSN, remoteDevSN):
    '''
    @summary: compare pool information
    @return: (execute status, loacaldiskDomainId, remotediskDomainId, compare result) 
    '''
    LOGGER.logInfo("***[execute comparePoolInfo, loacalPoolId= %s, remotePoolId= %s, pairId= %s]***" % (loacalPoolId, remotePoolId, pairId))
    loacalFlag, loacalPoolInfo = queryPoolInfo(loacalPoolId, pairId, str(localDevSN))
    if loacalFlag != True:
        return False, False
    remoteFlag, remotePoolInfo = queryPoolInfo(remotePoolId, pairId, str(remoteDevSN))
    if remoteFlag != True:
        return False, False
    if not loacalPoolInfo == remotePoolInfo:
        LOGGER.logInfo("***[pairId: %s, loacalPoolId: %s, remotePoolId: %s, is inconsistency]***" % (pairId, loacalPoolId, remotePoolId))
        poolInConsistencyInfo.append(pairId)
        return True, False
    return True, True
    
def queryPoolInfo(poolId, pairId, devSn):
    '''
    @summary: query pool information
    @return: (executeStatus, pool information, disk domain id)
    '''
    LOGGER.logInfo("***[execute queryPoolInfo, poolId= %s, pairId= %s, devSn= %s]***" % (poolId, pairId, str(devSn)))
    if  str(common.getProductModeFromContext(py_java_env)) in config.DORADO_DEVS:
        cmd = 'show storage_pool general pool_id=%s' % poolId
    else:
        cmd = 'show storage_pool tier pool_id=%s' % poolId
    executeStatus, executeCliRet, errorMsg = common.getObjFromFile(py_java_env, LOGGER, str(devSn), cmd)
    addCliRet2List(devSn, executeCliRet, cliRetList)
    LOGGER.logInfo("***[execute queryPoolInfo, executeStatus= %s]***" % str(executeStatus))
    if executeStatus != True:
        poolInfoQueryFailre.append(pairId)
        LOGGER.logError(cmd + ':' + errorMsg)
        return False, None
    poolInfo = getPoolInfo(executeCliRet, poolId, devSn)
    LOGGER.logInfo('devSn= %s, poolInfo= %s' % (str(devSn), str(poolInfo)))
    if poolInfo:
        return True, poolInfo
    poolInfoQueryFailre.append(pairId)
    return False, poolInfo
    
    
def getPoolInfo(executeCliRet, poolId, devSn):
    '''
    @summary: get pool comparison information.
    '''
    if str(common.getProductModeFromContext(py_java_env)) in config.DORADO_DEVS:
        return getPoolInfo4Dorado(executeCliRet, poolId, devSn)
    else:
        return getPoolInfo4V3(executeCliRet, poolId, devSn)


def getPoolInfo4Dorado(executeCliRet, poolId, devSn):
    '''
    @summary: get Dorado version of pool comparison information.
    '''
    poolFieldValueList = []
    
    poolFieldDictList = cliUtil.getVerticalCliRet(executeCliRet)
    for item in poolFieldDictList:
        poolFieldValueList.append(item.get('Raid Level', ''))
        healthStatus = item.get('Health Status', '')
        if healthStatus and healthStatus != "Normal":
            if (devSn, poolId) not in abnormalPoolList:
                abnormalPoolList.append((devSn, poolId))
        
    return poolFieldValueList


def getPoolInfo4V3(executeCliRet, poolId, devSn):
    '''
    @summary: get V3 version of pool comparison information.
    '''
    poolFieldValueList = []
    
    poolFieldDictList = cliUtil.getVerticalCliRet(executeCliRet)
    for item in poolFieldDictList:
        name = item.get('Name', '')
        raidLevel = item.get('RAID Level', '')
        poolFieldValueList.append((name, raidLevel))
        healthStatus = item.get('Health Status', '')
        if healthStatus and healthStatus != "Normal":
            if (devSn, poolId) not in abnormalPoolList:
                abnormalPoolList.append((devSn, poolId))
        
    return poolFieldValueList


def handleErrorMsg(loacalDevSN, remoteDevSN):
    promptMsg = ''
    if poolInConsistencyInfo:
        promptMsg += common.getMsg(LANG, "poolanddomain.pool.inconsistency", ','.join(poolInConsistencyInfo))
        del poolInConsistencyInfo[:]
    if pairInfoQueryFailre:
        promptMsg += common.getMsg(LANG, "poolanddomain.pairinfo.query.failure", ','.join(pairInfoQueryFailre))
    if poolIdQueryFailre:
        promptMsg += common.getMsg(LANG, "poolanddomain.poolid.query.failure", ','.join(poolIdQueryFailre))
        del poolIdQueryFailre[:]
    if poolInfoQueryFailre:
        promptMsg += common.getMsg(LANG, "poolanddomain.poolinfo.query.failure", ','.join(poolInfoQueryFailre))
        del poolInfoQueryFailre[:]
    promptMsg = common.getMsg(LANG, "poolanddomain.prompt", (str(loacalDevSN), str(remoteDevSN))) + promptMsg + lineBreak
    return promptMsg
