# -*- coding: UTF-8 -*-
import cliUtil
import common

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

def execute(cli):
    cliRet = ""
    errMsg = ""
    minTimingLength = 3
    maxTimingLength = 30
    
    try:
        #1. 判断版本是否是问题版本
        bugVersionList = ["[V100R001C20,V100R001C30SPC200]",\
                          "[V200R002C20,V200R002C30SPC200]",\
                          "[V300R001C00,V300R001C20SPC200]"]
        versionAndHotPatchDict = {"V100R001C30SPC200":"V100R001C30SPH202",\
                                  "V200R002C30SPC200":"V200R002C30SPH202",\
                                  "V300R001C20SPC200":"V300R001C20SPH202",}
        resultList, currentVersionDictList, hotPatchVersionDictList = common.parse_upgradePackage(cli, LANG)
        cliRet += resultList[1]
        if resultList[0] != True:
            return (cliUtil.RESULT_NOCHECK, cliRet, resultList[2])
    
        result, currentVersion, errInfo = common.getCurrentVersionFilterBVer(currentVersionDictList, LANG)
        if not result:
            # 修改备注：通过software信息字典列表获取版本信息（getCurrentVersionFilterBVer）返回False应该是未检查
            return (cliUtil.RESULT_NOCHECK, cliRet, errInfo)
        
        if not common.isBugProductVersion(currentVersion, bugVersionList):
            return (True, cliRet, errMsg)
        
        #打补丁解决问题的版本
        if currentVersion in versionAndHotPatchDict:
            result, hotPatchVersion, errInfo = common.getHotPatchVersion(hotPatchVersionDictList, LANG)
            if not result:
                return (False, cliRet, errInfo)
            if hotPatchVersion >= versionAndHotPatchDict.get(currentVersion):
                return (True, cliRet, errMsg)
            
        #2. 获取远程复制一致性组ID
        flag, consistencyGroupIdList, cliInfo, errInfo = getConsistencyGroupIdList(cli)
        cliRet += "\n" + cliInfo
        if flag != True:
            return (flag, cliRet, errInfo)
        
        #3. 获取远程复制一致性组的Timing Length信息；原始信息只记录有问题的，避免信息过多
        for consistencyGroupId in consistencyGroupIdList:
            flag, timingLength, cliInfo, errInfo = getConsistencyGroupTimingLength(cli, consistencyGroupId)
            
            #无法获取Timing length，后续也无法获取，直接退出
            if flag != True:
                cliRet += "\n" + cliInfo
                return (flag, cliRet, errInfo)
                
            #任何一个在[3,30]之间，则不通过，可中断后续检查直接退出 
            if minTimingLength <= timingLength <= maxTimingLength:
                cliRet += "\n" + cliInfo
                errMsg = common.getMsg(LANG, "remote.consistency.timinglength.info", (consistencyGroupId, timingLength))
                return (False, cliRet, errMsg)
        
        #4. 获取远程复制ID
        flag, remoteReplicationIdList, cliInfo, errInfo = getRemoteReplicationIdList(cli)
        cliRet += "\n" + cliInfo
        if flag != True:
            return (flag, cliRet, errInfo)
        
        #5. 获取远程复制的Consistency Group ID和Timing Length信息
        for remoteReplicationId in remoteReplicationIdList:  
            flag, consistencyGroupId, timingLength, cliInfo, errInfo = getRemoteReplicationInfo(cli, remoteReplicationId)
            
            #如果获取信息失败，后续也会高概率失败，直接退出
            if flag != True:
                cliRet += "\n" + cliInfo
                return (flag, cliRet, errInfo)
            
            #若存在远程复制的Consistency Group ID 为--且Timing Length在3秒到30秒之间，则检查结果为不通过,中断后续检查，直接退出
            if consistencyGroupId == "--" and minTimingLength <= timingLength <= maxTimingLength:
                cliRet += "\n" + cliInfo
                errMsg = common.getMsg(LANG, "remote.copy.consistency.group.id.timinglength.info", (remoteReplicationId, timingLength))
                return (False, cliRet, errMsg)
            
        return (True, cliRet, errMsg)
    
    except Exception, exception:
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, cliRet, common.getMsg(LANG, "query.result.abnormal"))
    
    
def getConsistencyGroupIdList(cli):
    '''
    @summary: 获取远程一致性组ID
    @return: 
        True|False:成功|失败
        IdList:ID列表
    ''' 
    cmd = "show consistency_group general"
    return getIdListByCmd(cli, cmd)

def getConsistencyGroupTimingLength(cli, consistencyGroupId):
    '''
    @summary: 获取远程复制一致性组的Timing Length信息
    @param consistencyGroupId: 一致性组ID
    @return: Timing Length, 统一转换成秒为单位
    '''
    timingLength = ""
    cmd = "show consistency_group general consistency_group_id=%s" % consistencyGroupId
    
    checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
    cliRet = checkRet[1]
    errMsg = checkRet[2]
    if checkRet[0] != True:
        return (checkRet[0], timingLength, cliRet, errMsg)
    
    consistencyGroupInfoDictList = cliUtil.getVerticalCliRet(checkRet[1])
    for consistencyGroupInfo in consistencyGroupInfoDictList:
        flag, timingLength = getTimingLength(consistencyGroupInfo)
        if flag:
            return (True, timingLength, cliRet, errMsg)
        
    errMsg = common.getMsg(LANG, "cannot.get.remote.consistency.some.info", consistencyGroupId)
    return (False, timingLength, cliRet, errMsg)
   
        
def getRemoteReplicationIdList(cli):
    '''
    @summary: 获取远程复制ID列表
    @return: IdList:复制ID列表
    '''    
    cmd = "show remote_replication general"
    return getIdListByCmd(cli, cmd)
    
    
def getRemoteReplicationInfo(cli, remoteReplicationId):
    '''
    @summary: 获取远程复制的Consistency Group ID和Timing Length信息
    @param remoteReplicationId: 远程复制ID
    @return: Consistency Group ID & Timing Length, Timing Length统一转换成秒为单位
    '''
    consistencyGroupId = ""
    timingLength = ""
    cmd = "show remote_replication general remote_replication_id=%s" % remoteReplicationId
    
    checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
    cliRet = checkRet[1]
    errMsg = checkRet[2]
    if checkRet[0] != True:
        return (checkRet[0], consistencyGroupId, timingLength, cliRet, errMsg)
    
    remoteReplicationInfoDictList = cliUtil.getVerticalCliRet(checkRet[1])
    for remoteReplicationInfo in remoteReplicationInfoDictList:
        flag, consistencyGroupId = getConsistencyGroupId(remoteReplicationInfo)
        if not flag:
            errMsg = common.getMsg(LANG, "cannot.get.remote.copy.consistency.group.id.info", remoteReplicationId)
            return (False, consistencyGroupId, timingLength, cliRet, errMsg)
        
        flag, timingLength = getTimingLength(remoteReplicationInfo)
        if not flag:
            errMsg = common.getMsg(LANG, "cannot.get.remote.copy.Timing.Length.info", remoteReplicationId)
            return (False, consistencyGroupId, timingLength, cliRet, errMsg)
        
        return (True, consistencyGroupId, timingLength, cliRet, errMsg)
    
    errMsg = common.getMsg(LANG, "cannot.get.remote.copy.consistency.group.id.timinglength.info", remoteReplicationId)
    return (False, consistencyGroupId, timingLength, cliRet, errMsg)

    
def getIdListByCmd(cli, cmd):
    '''
    @summary:执行给定的cmd，获取回显中的ID列表
    '''
    idList = []
    errMsg = ""
    checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
    cliRet = checkRet[1]
    errMsg = checkRet[2]
    if checkRet[0] != True:
        return (checkRet[0], idList, cliRet, errMsg)
        
    consistencyGroupDictList = cliUtil.getHorizontalCliRet(cliRet)
    for consistencyGroupDict in consistencyGroupDictList:
        id = consistencyGroupDict.get("ID")
        idList.append(id)
        
    return (True, idList, cliRet, errMsg)


def getTimingLength(dictInfo):
    '''
    @summary: 根据处理后的字典信息，获取Timing Length
    '''
    ratio = 1
    timingLength = ""
    if "Timing Length" not in dictInfo:
        return (False, timingLength)
    
    #据反馈，Timing Length都是整数，存在两种单位：Seconds 和 Minute(s)
    timingLength = dictInfo.get("Timing Length")
    
    #如果当前Timing Length显示为“--”（此时为手动同步），则认为不存在问题，直接返回一个-1
    if timingLength == "--":
        timingLength = -1
        return (True, timingLength)
    
    if "Minute" in timingLength:  #去掉（s）,避免1分钟时没有(s)
        ratio = 60
    try:  
        timingLength = int(timingLength.split()[0]) * ratio
        return (True, timingLength)
    except:
        return (False, timingLength)

def getConsistencyGroupId(dictInfo):
    '''
    @summary: 根据处理后的字典列表信息，获取Consistency Group ID
    '''
    consistencyGroupId = ""
    if "Consistency Group ID" not in dictInfo:
        return (False, consistencyGroupId)
    
    consistencyGroupId = dictInfo.get("Consistency Group ID")
    return (True, consistencyGroupId)
    
    