# -*- coding: UTF-8 -*-
import cliUtil
import common
import common_cache
import cli_util_cache
import traceback
from com.huawei.ism.tool.obase.exception import ToolException
from common import UnCheckException

PY_JAVA_ENV = py_java_env
LANG = common.getLang(PY_JAVA_ENV)
LOGGER = common.getLogger(PY_LOGGER, __file__)

# 精确模式
PRECISE_MODE = "precise"
# 自动模式
AUTOMATIC_MODE = "Automatic"


def execute(cli):
    """
    快照与源LUN容量检查
    :param cli:
    :return:
    """
    cli_ret_list = []
    old_cfg_mode = AUTOMATIC_MODE

    try:
        # 检查是否风险版本
        no_risk_flag, ret = check_not_risk_version(cli)
        cli_ret_list.append(ret)
        if no_risk_flag:
            return (
                cliUtil.RESULT_NOSUPPORT,
                "\n".join(cli_ret_list),
                "Not a risk version.",
            )

        cfg_dict_list, cli_ret = cli_util_cache.get_cur_cli_configuration(
            PY_JAVA_ENV, cli, LOGGER
        )
        cli_ret_list.append(cli_ret)
        for cfg_dict in cfg_dict_list:
            old_cfg_mode = cfg_dict.get("Capacity Mode")

        # 进入精确模式
        cli_ret = cli_util_cache.enter_cli_special_mode(
            PY_JAVA_ENV, cli, LOGGER, PRECISE_MODE
        )
        cli_ret_list.append(cli_ret)

        err_info_dict, ret_list = check_source_lun_capacity(cli)
        cli_ret_list.extend(ret_list)

        err_info_list = []
        for lun_id in err_info_dict:
            snap_id_list = err_info_dict.get(lun_id, [])
            content_key = "snapshot.lun.capacity.not.pass.content"
            err_msg = common.getMsg(
                LANG, content_key, (lun_id, ",".join(snap_id_list))
            )
            err_info_list.append(err_msg)
        ret = common_cache.save_cli_ret_to_file(
            cli_ret_list, "service_snapshot_lun_capacity", PY_JAVA_ENV,
            LOGGER)

        if err_info_list:
            title_key = "snapshot.lun.capacity.not.pass.title"
            title = common.getMsg(LANG, title_key)
            err_msg = title + "".join(err_info_list)
            return False, ret, err_msg

        return True, ret, ""
    except UnCheckException as e:
        ret = common_cache.save_cli_ret_to_file(
            cli_ret_list, "service_snapshot_lun_capacity", PY_JAVA_ENV,
            LOGGER)
        return (cliUtil.RESULT_NOCHECK, ret, e.errorMsg)
    except (ToolException, Exception) as e:
        LOGGER.logError(traceback.format_exc())
        LOGGER.logError(str(e))
        ret = common_cache.save_cli_ret_to_file(
            cli_ret_list, "service_snapshot_lun_capacity", PY_JAVA_ENV,
            LOGGER)
        return (cliUtil.RESULT_NOCHECK, ret,
                common.getMsg(LANG, "query.result.abnormal"))
    finally:
        # 退回到默认模式
        cli_util_cache.enter_cli_special_mode(
            PY_JAVA_ENV, cli, LOGGER, old_cfg_mode
        )
        # 退出到cli模式
        ret = cliUtil.enterCliModeFromSomeModel(cli, LANG)
        LOGGER.logInfo("enter cli mode from some model ret is %s" % str(ret))
        # 退出失败后为不影响后续检查项重新连接cli
        if not ret[0]:
            common.reConnectionCli(cli, LOGGER)


def check_source_lun_capacity(cli):
    ret_list = []
    snap_info_list, cli_ret = cli_util_cache.get_snapshot_info(
        PY_JAVA_ENV, cli, LOGGER
    )
    ret_list.append(cli_ret)
    err_info_dict = {}
    snap_lun_dict = {}
    lun_capacity_dict = {}
    for snap_info in snap_info_list:
        source_lun_id = snap_info.get("Source LUN ID", "")
        snap_capacity = snap_info.get("Capacity", "")
        snap_id = snap_info.get("ID", "")
        snap_info_dict = snap_lun_dict.get(source_lun_id, {})
        snap_info_dict[snap_id] = snap_capacity
        snap_lun_dict[source_lun_id] = snap_info_dict

    if not snap_lun_dict:
        return err_info_dict, ret_list

    # 获取源LUN容量
    ret_dict_list, cli_ret = cli_util_cache.get_lun_capacity_info(
        PY_JAVA_ENV, cli, LOGGER
    )
    ret_list.append(cli_ret)
    for ret_dict in ret_dict_list:
        lun_id = ret_dict.get("ID", "")
        lun_capacity = ret_dict.get("Capacity", "")
        lun_capacity_dict[lun_id] = lun_capacity

    # 比较源LUN和快照容量大小，可能存在源LUN1对多快照的问题。
    for source_lun_id in snap_lun_dict:
        lun_capacity = lun_capacity_dict.get(source_lun_id, "")
        snap_dict = snap_lun_dict.get(source_lun_id, {})
        for snap_id in snap_dict:
            snap_capacity = snap_dict.get(snap_id, "")
            if common.changUnit2B(lun_capacity) < common.changUnit2B(
                snap_capacity
            ):
                err_snap_list = err_info_dict.get(source_lun_id, [])
                err_snap_list.append(snap_id)
                err_info_dict[source_lun_id] = err_snap_list

    return err_info_dict, ret_list


def check_not_risk_version(cli):
    """
    1. 如果版本是V300R006C20及其之后的版本检查通过；V500R007C10及其之后
    的版本检查通过；V300R006C00之前的版本检查通过；否则继续检查；
    2. 如果版本是V500R007C00SPC100且安装了V500R007C00SPH102及以后版本的
    补丁则检查通过；
        如果版本是V300R006C10SPC100且安装了V300R006C10SPH102补丁及以后版
        本的补丁则检查通过；否则继续检查；

    :param cli:
    :return: True: 无风险。 False 有风险
    """
    (
        flag,
        p_version,
        p_patch,
        ret,
        msg,
    ) = common_cache.get_version_and_patch_cache(PY_JAVA_ENV, cli, LOGGER)
    if p_version.startswith("V300R006") and (
        p_version < "V300R006C20" or p_version >= "V300R006C61"
    ):
        return True, ret
    if p_version.startswith("V500R007") and (
        p_version < "V500R007C10" or p_version >= "V500R007C70"
    ):
        return True, ret

    return False, ret
