﻿# -*- coding: UTF-8 -*-
import cliUtil
import common

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

RISK_CUR_VER = "6.0.0"
RISK_HISTORY_VER = "6.0.RC1"
# 双活：15361， 远程复制：263， LUN迁移：253。
NEED_CHECK_SERVICES = ["15361", "263", "253"]

UPGRADE_OBJ_TYPE = "558"

OBJECT_TYPE_NAMW_DICT = \
    {"15361": "Succeeded In Creating HyperMetro",
     "263": "Succeeded In Creating Remote Replication",
     "253": "Succeeded In Creating A LUN Migration Task",
     "558": "Successful Upgrade"}


def execute(cli):
    """
    检查
    :param cli:
    :return:
    """
    return ValueAddedCreateTimeCheck(cli).check()


class ValueAddedCreateTimeCheck:
    def __init__(self, cli):
        self.cli_ret_all = ""
        self.err_msg = " "
        self.cli = cli
        self.upgrade_time = ""

    def check(self):
        try:
            ret_flag, need_check = self._check_ver_need_continue()
            if not ret_flag:
                return cliUtil.RESULT_NOCHECK, self.cli_ret_all, self.err_msg
            if not need_check:
                return True, self.cli_ret_all, self.err_msg

            # 获取升级成功的时间
            query_flag, self.upgrade_time, err_msg = self._get_earliest_time(
                UPGRADE_OBJ_TYPE)
            LOGGER.logInfo("upgrade time is: %s" % self.upgrade_time)
            if query_flag is not True:
                return cliUtil.RESULT_NOCHECK, self.cli_ret_all, err_msg

            return self._check_create_time_early_upgrade()
        except Exception as exception:
            LOGGER.logException(exception)
            return cliUtil.RESULT_NOCHECK, self.cli_ret_all, common.getMsg(
                LANG, "query.result.abnormal")

    def _check_ver_need_continue(self):
        """
        检查系统版本和历史版本判断是否需要后续检查
        :param cli:
        :return: 第一个True表示检查成功，False表示检查失败；第二个True表示需要继续检查，False不需要继续检查
        """
        # 获取设备当前产品版本
        check_ret, software_ver_list, _ = common.parse_upgradePackage(
            self.cli, LANG)
        self.cli_ret_all = common.joinLines(self.cli_ret_all, check_ret[1])
        if check_ret[0] is not True:
            LOGGER.logSysAbnormal()
            self.err_msg = check_ret[2]
            return False, False

        # 获取当前系统版本
        ret_flag, current_version, err_msg = common.getCurrentVersion(
            software_ver_list, LANG)
        if not ret_flag:
            self.err_msg = err_msg
            return False, False
        # 获取历史版本
        ret_flag, history_version, err_msg = common.getHistoryVersion(
            software_ver_list, LANG)
        if not ret_flag:
            self.err_msg = err_msg
            return False, False

        LOGGER.logInfo("current version[%s] and history version[%s]."
                       % (current_version, history_version))
        need_continue = \
            current_version.strip() == RISK_CUR_VER and \
            history_version.strip() == RISK_HISTORY_VER
        return True, need_continue

    def _get_earliest_time(self, object_type):
        """
        查询不同业务的最早创建时间
        :param object_type:
        :return:
        """
        create_time_earliest = ""
        query_create_time_cmd = "show event object_type=%s" % object_type
        ret_flag, cli_ret, err_msg = cliUtil.excuteCmdInCliMode(
            self.cli, query_create_time_cmd, True, LANG)
        self.cli_ret_all = common.joinLines(self.cli_ret_all, cli_ret)
        if ret_flag is not True:
            return ret_flag, create_time_earliest, err_msg

        if cliUtil.queryResultWithNoRecord(cli_ret):
            return True, create_time_earliest, ""

        cli_ret_dict_list = cliUtil.getHorizontalCliRet(cli_ret)
        for line_dict in cli_ret_dict_list:
            event_name = line_dict.get("Name", "")
            if OBJECT_TYPE_NAMW_DICT.get(object_type) not in event_name:
                continue
            create_time = line_dict.get("Occurred On", "")
            LOGGER.logInfo("create_time:" + str(create_time))
            if create_time == "" or create_time == "--":
                err_msg = common.getMsg(
                    LANG, "create.time.query.%s.time.error" % object_type)
                return False, create_time_earliest, err_msg
            if create_time_earliest == "" or \
                    create_time < create_time_earliest:
                create_time_earliest = create_time

        return True, create_time_earliest, ""

    def _check_create_time_early_upgrade(self):
        """
        检查双活创建时间是否早于升级时间
        :return:
        """
        result_flag_list = []
        for object_type in NEED_CHECK_SERVICES:
            query_flag, create_time_earliest, err_msg = \
                self._get_earliest_time(object_type)
            LOGGER.logInfo("value-added(%s) create time is:%s"
                           % (object_type, create_time_earliest))
            if not query_flag:
                self.err_msg = common.joinLines(self.err_msg, err_msg)
                result_flag_list.append(query_flag)
                continue
            if create_time_earliest == "":
                result_flag_list.append(True)
                continue
            if self.upgrade_time >= create_time_earliest:
                err_msg = common.getMsg(
                    LANG, "create.time.earliest.upgrade.%s" % object_type)
                self.err_msg = common.joinLines(self.err_msg, err_msg)
                result_flag_list.append(False)
            else:
                result_flag_list.append(True)

        return self._merge_result_flag(result_flag_list)

    def _merge_result_flag(self, result_flag_list):
        """
        合并检查结果，按严重级别上报结果：False>RESULT_NOCHECK>True
        :param result_flag_list:
        :return:
        """
        flag_lst = set(result_flag_list)
        if False in flag_lst:
            return False, self.cli_ret_all, self.err_msg
        elif cliUtil.RESULT_NOCHECK in flag_lst:
            return cliUtil.RESULT_NOCHECK, self.cli_ret_all, self.err_msg
        else:
            return True, self.cli_ret_all, self.err_msg
